package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionOrgService;
import com.ejianc.business.production.vo.*;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.business.sddjsorg.vo.OrgShareholderVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.service.IProductionService;

/**
 * 产权登记主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("production")
public class ProductionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "sddjs-production";//此处需要根据实际修改

    @Autowired
    private IProductionService service;

    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private IProductionOrgService productionOrgService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionVO> saveOrUpdate(@RequestBody ProductionVO saveorUpdateVO) {
        boolean add = false;
    	ProductionEntity entity = BeanMapper.map(saveorUpdateVO, ProductionEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            add = true;
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            saveorUpdateVO.setCreateTime(new Date());
        }else{
            saveorUpdateVO.setUpdateTime(new Date());
        }

        OrgApplyEntity applyEntity =orgApplyService.selectById(saveorUpdateVO.getSourceApplyId());
        applyEntity.setProductionState("registering");
        if(add){
            applyEntity.setProductionNum(applyEntity.getProductionNum()+1);
        }
        orgApplyService.saveOrUpdate(applyEntity);//更新 登记状态  登记中
    	service.saveOrUpdate(entity, false);
    	ProductionVO vo = BeanMapper.map(entity, ProductionVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 不登记调用
     * @return
     */
    @RequestMapping(value = "/noRegister", method = RequestMethod.POST)
    @ResponseBody
    public  CommonResponse<String> noRegister(@RequestBody Map<String,Long> param){
        Long applyId =param.get("applyId");
        OrgApplyEntity applyEntity =orgApplyService.selectById(applyId);
        applyEntity.setProductionState("noregister");
        applyEntity.setProductionNum(0);
        orgApplyService.updateById(applyEntity);
        return CommonResponse.success("不登记成功！");
    }



    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionVO> queryDetail(Long id) {
    	ProductionEntity entity = service.selectById(id);
    	ProductionVO vo = BeanMapper.map(entity, ProductionVO.class);

       // productionOrgService.saveOrUpdateOrgProduction(entity);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 查询待登记详情
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryOrgDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgApplyVOS> queryOrgDetail(Long applyId) {
        OrgApplyEntity entity = orgApplyService.selectById(applyId);
        List<OrgShareholderEntity> currencyEntities =service.queryApplyShareholderByApplyIdList(applyId,"现金");
        List<OrgShareholderEntity> noneCurrencyEntities =service.queryApplyShareholderByApplyIdList(applyId,null);

        OrgApplyVOS vo = BeanMapper.map(entity, OrgApplyVOS.class);

        vo.setCurrencyEntities(BeanMapper.mapList(currencyEntities, OrgShareholderVO.class));
        vo.setNoneCurrencyEntities(BeanMapper.mapList(currencyEntities, OrgShareholderVO.class));
        List<ProductionTypeItemEntity> productionTypeItemEntityList =service.queryProductionTypeItemList();
        //List<OrgShareholderEntity> acquisitionEquityVOList =service.queryApplyShareholderByApplyIdAllList(applyId);
        //vo.setAcquisitionEquityEntities(BeanMapper.mapList(acquisitionEquityVOList, OrgShareholderVO.class));
        vo.setConformanceContentEntities(BeanMapper.mapList(productionTypeItemEntityList,ProductionTypeItemVO.class));
        List<OrgShareholderEntity> lnvestorsEntities =service.queryApplyShareholderByApplyIdAllList(applyId);
        vo.setInvestorsEntities(BeanMapper.mapList(lnvestorsEntities,OrgShareholderVO.class));
        List<CapitalVO> capitalList =service.queryApplyShareholderByApplyIdSumCaptailName(applyId);
        vo.setCapitalEntities(capitalList);

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 根据申请id查询历史记录数据
     * @param applyId
     * @return
     */
    @RequestMapping(value = "/queryHistoryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionVO> queryHistoryDetail(Long id) {
        ProductionVO vo = new ProductionVO();
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();

        List<ProductionEntity> list =service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            ProductionEntity entity = list.get(0);
            vo =BeanMapper.map(entity, ProductionVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionVO> vos) {
        service.removeByIds(vos.stream().map(ProductionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProductionEntity> page = service.queryPage(param,false);
        IPage<ProductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表 数据量
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> queryListNum() {
        QueryParam param = new QueryParam();

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("productionState", new Parameter(QueryParam.IN, "unregistered,registering"));
        param.getParams().put("fileState", new Parameter(QueryParam.EQ, "filed"));//已归档的

        List<OrgApplyEntity> list = orgApplyService.queryList(param,false);

        return CommonResponse.success("查询列表数据成功！",list.size());
    }

    /**
     * @Description queryList 查询列表（待登记）
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryStayList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> queryOrgList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("fileState", new Parameter(QueryParam.EQ, "filed"));//已归档的

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //登记状态 未登记或者登记中
        param.getParams().put("productionState", new Parameter(QueryParam.IN, "unregistered,registering"));

        IPage<OrgApplyEntity> page = orgApplyService.queryPage(param,false);
        IPage<OrgApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表（待登记）
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryAlreadyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryAlreadyList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //param.getParams().put("currentProcessor", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));

        IPage<ProductionEntity> page = service.queryPage(param,false);
        IPage<ProductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 指派
     * @param applyId
     * @param userId
     * @param userName
     * @return
     */
    @RequestMapping(value = "/assignTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> assignTask(@RequestBody Map<String,String> param) {
        return service.assignTask(param);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelStayExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelStayExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OrgApplyEntity> list = orgApplyService.queryList(param);
        List<OrgApplyVO> orgApplyVOList = BeanMapper.mapList(list, OrgApplyVO.class);
        for(OrgApplyVO r : orgApplyVOList){
            if(StringUtils.isNotEmpty(r.getProductionState())){
                switch (r.getProductionState()){
                    case "unregistered":
                        r.setProductionState("未登记");
                    case "registered":
                        r.setProductionState("已登记");
                    case "registering":
                        r.setProductionState("登记中");
                    case "noregister":
                        r.setProductionState("不登记");
                }
            }
            if(StringUtils.isNotEmpty(r.getApplyType())){
                if("set".equals(r.getApplyType())){
                    r.setApplyTypeName("设立申请");
                }else if("change".equals(r.getApplyType())){
                    r.setApplyTypeName("变更申请");
                }else if("del".equals(r.getApplyType())){
                    r.setApplyTypeName("注销申请");
                }else if("merge".equals(r.getApplyType())){
                    r.setApplyTypeName("合并申请");
                }else if("divide".equals(r.getApplyType())){
                    r.setApplyTypeName("分立申请");
                }else if("supplementary".equals(r.getApplyType())){
                    r.setApplyTypeName("补录申请");
                }
            }

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", orgApplyVOList);
        ExcelExport.getInstance().export("production-stay-export.xlsx", beans, response);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelAlreadyExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelAlreadyExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ProductionEntity> page = service.queryPage(param,false);
        List<ProductionVO> voList =  BeanMapper.mapList(page.getRecords(), ProductionVO.class);
        for (ProductionVO r:voList){
            r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("production-register-export.xlsx", beans, response);

    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProductionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> refProductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProductionEntity> page = service.queryPage(param,false);
        IPage<ProductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OrgApplyEntity> list = orgApplyService.queryList(param);
        List<OrgApplyVO> orgApplyVOList = BeanMapper.mapList(list, OrgApplyVO.class);
        for(OrgApplyVO r : orgApplyVOList){
            if(StringUtils.isNotEmpty(r.getProductionState())){
                switch (r.getProductionState()){
                    case "unregistered":
                        r.setProductionState("未登记");
                    case "registered":
                        r.setProductionState("已登记");
                    case "registering":
                        r.setProductionState("登记中");
                    case "noregister":
                        r.setProductionState("不登记");
                }
            }
            if(StringUtils.isNotEmpty(r.getApplyType())){
                if("set".equals(r.getApplyType())){
                    r.setApplyTypeName("设立申请");
                }else if("change".equals(r.getApplyType())){
                    r.setApplyTypeName("变更申请");
                }else if("del".equals(r.getApplyType())){
                    r.setApplyTypeName("注销申请");
                }else if("merge".equals(r.getApplyType())){
                    r.setApplyTypeName("合并申请");
                }else if("divide".equals(r.getApplyType())){
                    r.setApplyTypeName("分立申请");
                }else if("supplementary".equals(r.getApplyType())){
                    r.setApplyTypeName("补录申请");
                }
            }

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", orgApplyVOList);
        ExcelExport.getInstance().export("production-stay-export.xlsx", beans, response);
    }
}
