package com.ejianc.business.sddjsorg.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 股东决策-档案资料
 *
 * @author CJ
 * @Description: 股东决策-档案资料
 * @date 2021/10/20 9:53
 */
@TableName(value = "ejc_sddjsorg_shareholder_decision_file")
public class ShareholderDecisionFileEntity extends BaseEntity {

    private static final long serialVersionUID = -3305297958379576689L;

    /**
     * 档案资料名称
     */
    @TableField(value="file_set_name")
    private String fileSetName;

    /**
     * 档案资料id
     */
    @TableField(value="file_set_id")
    private Long fileSetId;

    /**
     * 股东决策id（主表id）
     */
    @TableField(value="pid")
    private Long pid;

    /**
     * 校验时间点：submit:提交时校验，supplement:补充信息保存时校验，file:归档时校验
     */
    @TableField(value="check_time")
    private String checkTime;

    /**
     * 是否必须上传
     */
    @TableField(value="required")
    private Boolean required;

    /**
     * 附件Ids,多个逗号分隔
     */
    @TableField(value="file_id")
    private String fileIds;

    /**
     * 附件路径,多个逗号分隔
     */
    @TableField(value = "file_paths")
    private String filePaths;

    public String getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(String checkTime) {
        this.checkTime = checkTime;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getFileSetName() {
        return fileSetName;
    }

    public void setFileSetName(String fileSetName) {
        this.fileSetName = fileSetName;
    }

    public Long getFileSetId() {
        return fileSetId;
    }

    public void setFileSetId(Long fileSetId) {
        this.fileSetId = fileSetId;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getFileIds() {
        return fileIds;
    }

    public void setFileIds(String fileIds) {
        this.fileIds = fileIds;
    }

    public String getFilePaths() {
        return filePaths;
    }

    public void setFilePaths(String filePaths) {
        this.filePaths = filePaths;
    }
}
