package com.ejianc.business.sddjsorg.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.capital.vo.CapitalRecRegistryVO;
import com.ejianc.business.sddjsorg.bean.ShareholderDecisionEntity;
import com.ejianc.business.sddjsorg.bean.ShareholderDecisionFileEntity;
import com.ejianc.business.sddjsorg.service.IShareholderDecisionService;
import com.ejianc.business.sddjsorg.vo.ShareholderDecisionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 股东决策
 *
 * @author CJ
 * @Description: 股东决策
 * @date 2021/10/20 11:41
 */
@RestController
@RequestMapping("/shareholderDecision/")
public class ShareholderDecisionController {

    @Autowired
    private IShareholderDecisionService shareholderDecisionService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    private final static String BILL_CODE_RULL_CODE = "SHAREHOLDER_DECISION_01";

    @Autowired
    private SessionManager sessionManager;

    /**
     * 分页查询股东决策
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "pageList")
    public CommonResponse<IPage<ShareholderDecisionVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("sddjsOrgName");
        //查询本下
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> orgIds = childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));

        //仅我的单据参数处理
        if(null != queryParam.getParams().get("onlyMine")) {
            queryParam.getParams().put("createUserCode", new Parameter("1".equals( queryParam.getParams().get("onlyMine").getValue()) ? QueryParam.EQ : QueryParam.NE, InvocationInfoProxy.getUsercode()));
            queryParam.getParams().remove("onlyMine");
        }

        IPage<ShareholderDecisionEntity> page = shareholderDecisionService.queryPage(queryParam, false);

        IPage<ShareholderDecisionVO> result = new Page<>();
        result.setTotal(page.getTotal());
        result.setRecords(BeanMapper.mapList(page.getRecords(), ShareholderDecisionVO.class));
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        result.setPages(page.getPages());

        return CommonResponse.success("分页查询成功！", result);
    }

    /**
     * 股东决策保存/更新
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "saveOrUpdate")
    public CommonResponse<ShareholderDecisionVO> saveOrUpdate(@RequestBody ShareholderDecisionVO vo) {
        ShareholderDecisionEntity saveEntity = null;
        UserContext userContext = sessionManager.getUserContext();

        if(CollectionUtils.isNotEmpty(vo.getDocFiles())) {
            vo.getDocFiles().forEach(item -> {
                if(CollectionUtils.isNotEmpty(item.getAttachIds())) {
                    item.setFileIds(StringUtils.join(item.getAttachIds(), ","));
                } else {
                    item.setFileIds(null);
                }
            });
        }

        if(null == vo.getId()) {
            saveEntity = BeanMapper.map(vo, ShareholderDecisionEntity.class);
            //生成编码
            CommonResponse<String> billCodeResp = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_RULL_CODE, InvocationInfoProxy.getTenantid());
            if(!billCodeResp.isSuccess()) {
                return CommonResponse.error("保存失败，生成单据编码失败！");
            }
            saveEntity.setBillCode(billCodeResp.getData());

            //默认为启用状态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setCreateUserName(userContext.getUserName());

        } else {
            saveEntity = shareholderDecisionService.selectById(vo.getId());
            saveEntity.setDocFiles(BeanMapper.mapList(vo.getDocFiles(), ShareholderDecisionFileEntity.class));
            saveEntity.setSddjsOrgId(vo.getSddjsOrgId());
            saveEntity.setSddjsOrgCode(vo.getSddjsOrgCode());
            saveEntity.setSddjsOrgName(vo.getSddjsOrgName());
            saveEntity.setRemark(vo.getRemark());
            saveEntity.setDecisionContent(vo.getDecisionContent());
            saveEntity.setUndertabkeEmployeeId(vo.getUndertabkeEmployeeId());
            saveEntity.setUndertakeEmployeeName(vo.getUndertakeEmployeeName());
            saveEntity.setUndertakeDeptId(vo.getUndertakeDeptId());
            saveEntity.setUndertakeDeptName(vo.getUndertakeDeptName());
            saveEntity.setMainMattersDesc(vo.getMainMattersDesc());
            saveEntity.setMainMattersDesc(vo.getMainMattersDesc());

            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setUpdateUserCode(userContext.getUserCode());

            saveEntity.setModifyUserName(userContext.getUserName());
        }

        shareholderDecisionService.saveOrUpdate(saveEntity, false);

        return CommonResponse.success("保存成功！", BeanMapper.map(saveEntity, ShareholderDecisionVO.class));
    }

    /**
     * 查询指定的股东决策详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetail")
    public CommonResponse<ShareholderDecisionVO> queryDetail(@RequestParam(value = "id") Long id) {
        ShareholderDecisionVO resp = null;

        ShareholderDecisionEntity dbEntity = shareholderDecisionService.selectById(id);
        if(null != dbEntity) {
            resp = BeanMapper.map(dbEntity, ShareholderDecisionVO.class);
            if(CollectionUtils.isNotEmpty(resp.getDocFiles())) {
                resp.getDocFiles().forEach(item -> {
                    if(StringUtils.isNotBlank(item.getFileIds())) {
                        item.setAttachIds(Arrays.asList(item.getFileIds().split(",")).stream().map(fileId -> Long.valueOf(fileId)).collect(Collectors.toList()));
                    }
                });
            }
        }

        return CommonResponse.success("查询详情成功！", resp);
    }

    /**
     * 股东决策删除
     *
     * @param vos
     * @return
     */
    @PostMapping(value = "delete")
    public CommonResponse<String> delete(@RequestBody List<CapitalRecRegistryVO> vos) {
        for(CapitalRecRegistryVO vo : vos) {
            shareholderDecisionService.removeById(vo.getId(), false);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("sddjsOrgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        //查询本下
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("导出失败, 查询组织信息失败！");
        }
        List<Long> orgIds = childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));

        //仅我的单据参数处理
        if(null != param.getParams().get("onlyMine")) {
            param.getParams().put("createUserCode", new Parameter("1".equals( param.getParams().get("onlyMine").getValue()) ? QueryParam.EQ : QueryParam.NE, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("onlyMine");
        }

        List<ShareholderDecisionEntity> list = shareholderDecisionService.queryList(param);
        List<ShareholderDecisionVO> vos = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            ShareholderDecisionVO tmp = null;
            for(ShareholderDecisionEntity e : list) {
                tmp = BeanMapper.map(e, ShareholderDecisionVO.class);
                tmp.setCreateTimeStr(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", e.getCreateTime()));
                tmp.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
                vos.add(tmp);
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("shareholderDecisionExport.xlsx", beans, response);
    }


}
