package com.ejianc.business.sddjsorg.service.impl;

import java.util.Date;
import java.util.List;

import org.apache.commons.beanutils.BeanMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.SddjsOrgEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.fasterxml.jackson.annotation.JsonFormat;

@Service("orgApply") 
public class OrgApplyBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IOrgApplyService orgApplyservice;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ISddjsOrgService sddjsOrgService;
    @Autowired
    private IAttachmentApi attachmentApi;
	@Autowired
	private SessionManager sessionManager;
    
	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	//补录申请审批通过
	public CommonResponse<String> supplementaryApplyApproval(OrgApplyEntity entity) {
		//生成组织机构
		SddjsOrgEntity sddjsOrgEntity = BeanMapper.map(entity, SddjsOrgEntity.class);
		sddjsOrgEntity.setId(null);
		sddjsOrgEntity.setCreateTime(null);
		sddjsOrgEntity.setCreateUserCode(null);
		sddjsOrgEntity.setTenantId(InvocationInfoProxy.getTenantid());
		sddjsOrgEntity.setUpdateTime(null);
		sddjsOrgEntity.setUpdateUserCode(null);
		if(sddjsOrgEntity.getOrgShareholderList()!=null&&sddjsOrgEntity.getOrgShareholderList().size()>0){
			sddjsOrgEntity.getOrgShareholderList().forEach(older -> {
				older.setId(null);
				older.setCreateTime(null);
				older.setCreateUserCode(null);
				older.setTenantId(InvocationInfoProxy.getTenantid());
				older.setUpdateTime(null);
				older.setUpdateUserCode(null);
				older.setPid(null);
				older.setRowState("add");
			});
		}
		sddjsOrgEntity.setUseState("use");
		sddjsOrgService.saveOrUpdate(sddjsOrgEntity, false);
    	//营业执照
    	attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "businessLicense", sddjsOrgEntity.getId().toString(), "BT211012000000004", "businessLicense");
    	//公司章程
    	attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "articles", sddjsOrgEntity.getId().toString(), "BT211012000000004", "articles");
		
		//获取申请人
		CommonResponse<List<DefdocDetailVO>> docResponse = defdocApi.getDefDocByDefCode("sddjs-assign-user");
		if(docResponse.isSuccess()&&docResponse.getData().size()>0){
		    Long currentProcessor = null; // 当前处理人
		    String currentProcessorName = null; // 当前处理人
			for(DefdocDetailVO doc : docResponse.getData()){
				if("orgApply".equals(doc.getCode())){
					currentProcessor = Long.parseLong(doc.getName());
					CommonResponse<UserVO> userResponse = userApi.findUserByUserId(currentProcessor);
					if(userResponse.isSuccess()&&userResponse.getData()!=null){
						currentProcessorName = userResponse.getData().getUserName();
					}
				}
			}
			if(currentProcessor == null){
				return CommonResponse.error("获取到申请人信息失败");
			}
			entity.setCurrentProcessor(currentProcessor);
			entity.setCurrentProcessorName(currentProcessorName);
			entity.setPendingStartTime(new Date());
		}else{
			return CommonResponse.error("获取到申请人信息失败");
		}
		entity.setInUseOrgId(sddjsOrgEntity.getId());
		entity.setFileState("filed");//补录没有归档操作，默认已归档
    	entity.setFileTime(new Date());
    	entity.setFileUser(sessionManager.getUserContext().getUserName());
		entity.setProductionState("unregistered");
		orgApplyservice.saveOrUpdate(entity);
		return CommonResponse.success();
	}


	//其他申请（设立、变更、注销）审批通过
	public CommonResponse<String> otherApplyApproval(OrgApplyEntity entity) {
		//获取申请人
		CommonResponse<List<DefdocDetailVO>> docResponse = defdocApi.getDefDocByDefCode("sddjs-assign-user");
		if(docResponse.isSuccess()&&docResponse.getData().size()>0){
		    Long currentProcessor = null; // 当前处理人
		    String currentProcessorName = null; // 当前处理人
			for(DefdocDetailVO doc : docResponse.getData()){
				if("orgApply".equals(doc.getCode())){
					currentProcessor = Long.parseLong(doc.getName());
					CommonResponse<UserVO> userResponse = userApi.findUserByUserId(currentProcessor);
					if(userResponse.isSuccess()&&userResponse.getData()!=null){
						currentProcessorName = userResponse.getData().getUserName();
					}
				}
			}
			if(currentProcessor == null){
				return CommonResponse.error("获取到申请人信息失败");
			}
			entity.setCurrentProcessor(currentProcessor);
			entity.setCurrentProcessorName(currentProcessorName);
			entity.setPendingStartTime(new Date());
		}else{
			return CommonResponse.error("获取到申请人信息失败");
		}
		entity.setFileState("toFile");
		entity.setProductionState("unregistered");
		orgApplyservice.saveOrUpdate(entity);
		return CommonResponse.success();
	}
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OrgApplyEntity entity = orgApplyservice.selectById(billId);
		if(entity!=null){
			if("supplementary".equals(entity.getApplyType())){
				//补录申请--生成组织机构数据
				return this.supplementaryApplyApproval(entity);
			}else{
				return this.otherApplyApproval(entity);
			}
		}else{
			return CommonResponse.error("未获取到单据信息");
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OrgApplyEntity entity = orgApplyservice.selectById(billId);
		if(entity!=null){
			if("supplementary".equals(entity.getApplyType())){
				//补录申请--判断产权登记状态
				if(!"unregistered".equals(entity.getProductionState())){
					//非未登记状态不能弃审
					return CommonResponse.error("该申请已做产权登记，不能弃审！");
				}
			}else{
				//判断归档状态
				if("filed".equals(entity.getFileState())){
					//已归档状态不能弃审
					return CommonResponse.error("该申请已做归档，不能弃审！");
				}
			}
		}else{
			return CommonResponse.error("未获取到单据信息");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OrgApplyEntity entity = orgApplyservice.selectById(billId);
		if(entity!=null){
			if("supplementary".equals(entity.getApplyType())){
				//补录申请--生成组织机构数据
				return this.supplementaryApplyAbstaining(entity);
			}else{
				return this.otherApplyAbstaining(entity);
			}
		}else{
			return CommonResponse.error("未获取到单据信息");
		}
	}


	//补录申请弃审
	public CommonResponse<String> supplementaryApplyAbstaining(OrgApplyEntity entity) {
		//删除组织机构信息
		sddjsOrgService.removeById(entity.getInUseOrgId(), false);
		
		entity.setCurrentProcessor(null);
		entity.setCurrentProcessorName(null);
		entity.setPendingStartTime(null);
		entity.setInUseOrgId(null);
		entity.setFileState(null);
		entity.setProductionState(null);
		orgApplyservice.saveOrUpdate(entity);
		return CommonResponse.success();
	}


	//其他申请（设立、变更、注销）弃审
	public CommonResponse<String> otherApplyAbstaining(OrgApplyEntity entity) {
		//获取申请人
		entity.setCurrentProcessor(null);
		entity.setCurrentProcessorName(null);
		entity.setPendingStartTime(null);
		entity.setFileState(null);
		entity.setProductionState(null);
		orgApplyservice.saveOrUpdate(entity);
		return CommonResponse.success();
	}
}
