package com.ejianc.business.orgcenter.service;

import com.ejianc.business.orgcenter.bean.AdministrativeAreaEntity;
import com.ejianc.business.orgcenter.vo.AdministrativeAreaVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/10/12 10:48
 */
public interface IAdministrativeAreaService extends IBaseService<AdministrativeAreaEntity> {

    /**
     * 根据主键批量物理删除行政地区记录
     *
     * @param collect
     */
    void batchDelByIds(List<Long> collect);

    /**
     * 查询行政地区信息
     *
     * @param pid
     * @return
     */
    List<Map> queryAll(Long pid);

    /**
     * 查询匹配的地区列表
     *
     * @param pid
     * @param billCode
     * @param areaName
     * @param status
     * @return
     */
    List<AdministrativeAreaVO> queryList(Long pid, String billCode, String areaName, Integer status);
}
