package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.business.production.vo.InvestorsVO;
import com.ejianc.business.production.vo.ProductionVO;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.vo.OrgShareholderVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.service.IProductionOrgService;
import com.ejianc.business.production.vo.ProductionOrgVO;

/**
 * 产权登记生成的公司
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("productionOrg")
public class ProductionOrgController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "sddjs-production-org";//此处需要根据实际修改

    @Autowired
    private IProductionOrgService service;
    @Autowired
    private IProductionService productionService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionOrgVO> saveOrUpdate(@RequestBody ProductionOrgVO saveorUpdateVO) {
    	ProductionOrgEntity entity = BeanMapper.map(saveorUpdateVO, ProductionOrgEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ProductionOrgVO vo = BeanMapper.map(entity, ProductionOrgVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionOrgVO> queryDetail(Long id) {

    	ProductionOrgEntity entity = service.selectById(id);
    	ProductionOrgVO vo = BeanMapper.map(entity, ProductionOrgVO.class);
        ProductionEntity productionEntity = productionService.selectById(entity.getProductionId());
        vo.setInvestorsEntities(BeanMapper.mapList(productionEntity.getInvestorsEntities(), InvestorsVO.class));
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("org_id", entity.getOrgId());
        queryWrapper.orderByDesc("create_time");
        List<ProductionEntity> list = productionService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setHistoryList(BeanMapper.mapList(list,ProductionVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionOrgVO> vos) {
        service.removeByIds(vos.stream().map(ProductionOrgVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductionOrgVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("unifiedSocialCreditCode");
        param.getFuzzyFields().add("orgTypeName");
        param.getFuzzyFields().add("orgFormName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProductionOrgEntity> page = service.queryPage(param,false);
        IPage<ProductionOrgVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionOrgVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("unifiedSocialCreditCode");
        param.getFuzzyFields().add("orgTypeName");
        param.getFuzzyFields().add("orgFormName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProductionOrgEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ProductionOrgVO> voList =  BeanMapper.mapList(list,ProductionOrgVO.class);
        for (ProductionOrgVO r:voList){
            if(r.getInReacrd().equals(1)){
                r.setInReacrdName("备案");
            }else{
                r.setInReacrdName("未备案");
            }
            if(r.getUseStatus()){
                r.setUseStatusName("在用");
            }else{
                r.setUseStatusName("停用");
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("production-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProductionOrgData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProductionOrgVO>> refProductionOrgData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProductionOrgEntity> page = service.queryPage(param,false);
        IPage<ProductionOrgVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionOrgVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
