package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.CapitalEntity;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.bean.SddjsOrgEntity;
import com.ejianc.business.sddjsorg.mapper.OrgApplyMapper;
import com.ejianc.business.sddjsorg.mapper.OrgShareholderMapper;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.IOrgShareholderService;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.production.mapper.ProductionMapper;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.service.IProductionService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * 产权登记主表
 * 
 * @author generator
 * 
 */
@Service("productionService")
public class ProductionServiceImpl extends BaseServiceImpl<ProductionMapper, ProductionEntity> implements IProductionService{
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private OrgShareholderMapper orgShareholderMapper;
    @Autowired
    private IOrgShareholderService orgShareholderService;
    @Autowired
    private IProductionTypeItemService productionTypeItemService;
    @Autowired
    private ProductionMapper productionMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISddjsOrgService sddjsOrgService;
    /**
     * 指派
     * @param param
     * @return
     */
    public CommonResponse<String> assignTask(Map<String,String> param) {
        try{
            String applyId=  param.get("applyId");
            String userId=  param.get("userId");
            String userName= param.get("userName");
            OrgApplyEntity orgApplyEntity =orgApplyService.getById(Long.valueOf(applyId));
            orgApplyEntity.setCurrentProcessorName(userName);
            orgApplyEntity.setCurrentProcessor(Long.valueOf(userId));
            orgApplyEntity.setPendingStartTime(new Date());
            orgApplyService.saveOrUpdate(orgApplyEntity);
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.success("指派失败");
        }

        return CommonResponse.success("指派成功");
    }

    /**
     * 根据申请id 和出资类型查询数据
     * @param applyId
     * @param contributionType
     * @return
     */
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdList(Long applyId, String contributionType) {
        QueryWrapper<OrgShareholderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pid", applyId);
        queryWrapper.eq("dr","0");
        if(StringUtils.isNotBlank(contributionType)){
            queryWrapper.eq("contribution_type",contributionType);
        }else{
            queryWrapper.ne("contribution_type","现金");
        }
        return orgShareholderMapper.selectList(queryWrapper);
    }

    /**
     * 查询产权登记类型子数据
     * @return
     */
    public List<ProductionTypeItemEntity> queryProductionTypeItemList(String productionTypeCode) {
        QueryWrapper<ProductionTypeItemEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("production_type_code", productionTypeCode);
        queryWrapper.eq("in_use", 1);
        return productionTypeItemService.list(queryWrapper);
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdAllList(Long applyId) {
        QueryWrapper<OrgShareholderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pid", applyId);
        queryWrapper.eq("dr","0");

        return orgShareholderMapper.selectList(queryWrapper);
    }

    /**
     * 根据applyId 统计基本情况
     * @param applyId
     * @return
     */
    public List<CapitalVO> queryApplyShareholderByApplyIdSumCaptailName(Long applyId) {

        List<CapitalVO> resp = new ArrayList<CapitalVO>();
        QueryWrapper<OrgShareholderEntity> query = new QueryWrapper<>();
        query.select("  sum(subscribed_capital) as  declaredNumberEnterprises,captail_type as  captailType");
        query.eq("pid", applyId);
        query.groupBy("captail_type");
        List<Map<String,Object>> listMaps =orgShareholderService.listMaps(query);
        for (int i=0;i<listMaps.size();i++){
            Map<String,Object> map =listMaps.get(i);
            CapitalVO vo = new CapitalVO();
            vo.setCaptailType((String) map.get("captailType"));
            vo.setDeclaredNumberEnterprises(map.get("declaredNumberEnterprises") !=null ? new BigDecimal(map.get("declaredNumberEnterprises").toString()) :  BigDecimal.ZERO.setScale(8));
            vo.setId(IdWorker.getId());
            resp.add(vo);
        }
        return resp;
    }

    /**
     * 验证（收购企业） 收购手动输入的编号是否重复
     * @param unifiedSocialCreditCode
     * @return
     */
    public List<ProductionEntity> checkUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("unified_social_credit_code", unifiedSocialCreditCode);
        List<ProductionEntity> list =productionMapper.selectList(queryWrapper);
        return list;
    }

    @Override
    public List<ProductionEntity> queryProductionByApplyId(Long applyId) {
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_apply_id",applyId);
        queryWrapper.notIn("bill_state","1,3");
        List<ProductionEntity> list =productionMapper.selectList(queryWrapper);
        return list;
    }

    /**
     * 不登记
     * @param applyEntity
     * @return
     */
    public CommonResponse<String> updateNoRegister(OrgApplyEntity applyEntity) {

        SddjsOrgEntity sddjsOrgEntity =sddjsOrgService.getById(applyEntity.getInUseOrgId());

        if(applyEntity.getApplyType().equals("del")){
            this.updateCancellation(sddjsOrgEntity);
        }else{
            OrgVO orgVO =saveOrUpdateOrg(sddjsOrgEntity);
            sddjsOrgEntity.setOrgId(orgVO.getId());
        }

        sddjsOrgService.saveOrUpdate(sddjsOrgEntity);
        applyEntity.setProductionState("noregister");//设置申请单已登记
        orgApplyService.saveOrUpdate(applyEntity);
        return CommonResponse.success("不登记成功");
    }

    /**
     * 修改或添加组织机构
     * @param sddjsOrgEntity
     * @return
     */
    @Transactional
    public OrgVO saveOrUpdateOrg(SddjsOrgEntity sddjsOrgEntity){
        //生成组织
        CommonResponse<OrgVO> responseOrgVo =orgApi.getOneById(sddjsOrgEntity.getOrgId());
        OrgVO projectDepartment = new OrgVO();
        if (responseOrgVo.getData() != null){
            projectDepartment = responseOrgVo.getData();
        }else{
            projectDepartment.setId(IdWorker.getId());

        }
        projectDepartment.setParentId(sddjsOrgEntity.getDirectSuperiorOrgId());
        projectDepartment.setTenantId(InvocationInfoProxy.getTenantid());
        //projectDepartment.setEnterpriseId(entity.getEnterpriseId());
        projectDepartment.setIsParent(false);
        projectDepartment.setName(sddjsOrgEntity.getName());
        projectDepartment.setShortName(sddjsOrgEntity.getName());
        //projectDepartment.setSourceId(projectRegisterVO.getSourceId());
        projectDepartment.setState(1);
        //项目部类型
        projectDepartment.setOrgType(2);
        CommonResponse<OrgVO> commonResponse =orgApi.saveOrgInfo(projectDepartment);
        if(commonResponse.getCode() !=0){
            throw new BusinessException("推送组织结构异常");
        }
        return commonResponse.getData();
    }

    /**
     * 注销
     * @param entity
     */
    public void updateCancellation(SddjsOrgEntity sddjsOrgEntity){

        CommonResponse<OrgVO> responseOrgVo =orgApi.getOneById(sddjsOrgEntity.getOrgId());
        OrgVO projectDepartment = new OrgVO();
        if (responseOrgVo.getData() != null){
            projectDepartment = responseOrgVo.getData();
            projectDepartment.setState(0);//停用
            orgApi.saveOrgInfo(projectDepartment);
        }
    }
}
