/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.production.bean.ProductionTypeEntity;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.service.IProductionTypeService;
import com.ejianc.business.production.vo.ProductionTypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"productionType"})
public class ProductionTypeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProductionTypeItemService productionTypeItemService;
    private static final String BILL_CODE = "sddjs-productionType";
    @Autowired
    private IProductionTypeService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProductionTypeVO> saveOrUpdate(@RequestBody ProductionTypeVO saveorUpdateVO) {
        ProductionTypeEntity entity = (ProductionTypeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProductionTypeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProductionTypeVO vo = (ProductionTypeVO)BeanMapper.map((Object)((Object)entity), ProductionTypeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionTypeVO> queryDetail(Long id) {
        ProductionTypeEntity entity = (ProductionTypeEntity)((Object)this.service.selectById(id));
        ProductionTypeVO vo = (ProductionTypeVO)BeanMapper.map((Object)((Object)entity), ProductionTypeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionTypeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List dataList = this.service.queryList(param);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        if (dataList != null && dataList.size() > 0) {
            jsonObject.put("data", ProductionTypeController.createTreeData(dataList));
        }
        return CommonResponse.success((Object)jsonObject);
    }

    public static List<ProductionTypeEntity> createTreeData(List<ProductionTypeEntity> list) {
        ArrayList<ProductionTypeEntity> resp = new ArrayList<ProductionTypeEntity>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ProductionTypeEntity> listMap = new HashMap<String, ProductionTypeEntity>();
        for (ProductionTypeEntity vo : list) {
            listMap.put(vo.getId().toString(), vo);
        }
        for (int i = 0; i < list.size(); ++i) {
            ProductionTypeEntity productionTypeEntity = list.get(i);
            String parentId = productionTypeEntity.getPid() != null && productionTypeEntity.getPid() > 0L ? productionTypeEntity.getPid().toString() : "";
            ProductionTypeEntity parent = (ProductionTypeEntity)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ProductionTypeEntity> child = parent.getChildren();
                if (child != null) {
                    child.add(productionTypeEntity);
                    continue;
                }
                ArrayList<ProductionTypeEntity> children = new ArrayList<ProductionTypeEntity>();
                children.add(productionTypeEntity);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(productionTypeEntity.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ProductionTypeEntity)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    public static List<ProductionTypeVO> createTreeDataVO(List<ProductionTypeVO> list) {
        ArrayList<ProductionTypeVO> resp = new ArrayList<ProductionTypeVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ProductionTypeVO> listMap = new HashMap<String, ProductionTypeVO>();
        for (ProductionTypeVO vo : list) {
            listMap.put(vo.getId().toString(), vo);
        }
        for (int i = 0; i < list.size(); ++i) {
            ProductionTypeVO vo;
            vo = list.get(i);
            String parentId = vo.getPid() != null && vo.getPid() > 0L ? vo.getPid().toString() : "";
            ProductionTypeVO parent = (ProductionTypeVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(vo);
                    continue;
                }
                ArrayList<ProductionTypeVO> children = new ArrayList<ProductionTypeVO>();
                children.add(vo);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(vo.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ProductionTypeVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProductionType-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProductionTypeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProductionTypeVO>> refProductionTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionTypeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProductionTypeVO>> queryListByCode(String code) {
        QueryParam param = new QueryParam();
        param.getParams().put("code", new Parameter("eq", (Object)code));
        List list = this.service.queryList(param);
        if (ListUtil.isEmpty((List)list)) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u7c7b\u578b\u4ea7\u6743\u767b\u8bb0!");
        }
        param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)((ProductionTypeEntity)((Object)list.get(0))).getId()));
        list = this.service.queryList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)list, ProductionTypeVO.class));
    }
}

