package com.ejianc.business.sddjsorg.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
/**
 * 组织机构申请单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sddjsorg_org_apply_bill")
public class OrgApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="code")
    private String code; // 申请单号
    @TableField(value="apply_type")
    private String applyType; // 申请单类型，set:设立申请，change：变更，del：注销，merge：合并，divide：分立，supplementary:补录
    @TableField(value="name")
    private String name; // 公司名称
    @TableField(value="name_short_cn")
    private String nameShortCn; // 公司名称中文缩写
    @TableField(value="name_short_en")
    private String nameShortEn; // 公司名称英文缩写
    @TableField(value="org_nature_id")
    private Long orgNatureId; // 公司注册性质id
    @TableField(value="org_nature_name")
    private String orgNatureName; // 公司注册性质
    @TableField(value="direct_superior_id")
    private Long directSuperiorId; // 直接上级单位id
    @TableField(value="direct_superior")
    private String directSuperior; // 直接上级单位
    @TableField(value="direct_superior_org_id")
    private Long directSuperiorOrgId; // 直接上级单位平台组织id
    @TableField(value="subject_corporate_management_responsibility")
    private Long subjectCorporateManagementResponsibility; // 公司管理责任主体
    @TableField(value="subject_corporate_management_responsibility_name")
    private String subjectCorporateManagementResponsibilityName; // 公司管理责任主体
    @TableField(value="register_country_id")
    private Long registerCountryId; // 注册国家地区id
    @TableField(value="register_country_name")
    private String registerCountryName; // 注册国家地区名称
    @TableField(value="register_area_v")
    private String registerAreaV; // 注册所在地区value
    @TableField(value="register_area_name")
    private String registerAreaName; // 注册所在地区name
    @TableField(value="register_address")
    private String registerAddress; // 注册地详细地址
    @TableField(value="register_in")
    private String registerIn; // 注册地境内/境外
    @TableField(value="report_merge")
    private Boolean reportMerge; // 报表合并
    @TableField(value="whether_report_to_group")
    private Boolean whetherReportToGroup; // 是否上报集团批复
    @TableField(value="apply_reason")
    private String applyReason; // 申请原因、注销原因
    @TableField(value="business_scope")
    private String businessScope; // 营业范围
    @TableField(value="register_capital")
    private BigDecimal registerCapital; // 注册资本
    @TableField(value="currency_type_id")
    private Long currencyTypeId; // 注册资本币种id
    @TableField(value="currency_type_name")
    private String currencyTypeName; // 注册资本币种名称
    @TableField(value="control_status")
    private Long controlStatus; // 控制状态id
    @TableField(value="control_status_name")
    private String controlStatusName; // 控制状态
    @TableField(value="equity_ratio")
    private BigDecimal equityRatio; // 股权比例
    @TableField(value="legal_representative")
    private Long legalRepresentative; // 法定人代表
    @TableField(value="legal_representative_name")
    private String legalRepresentativeName; // 法定人代表
    @TableField(value="director")
    private Long director; // 董事
    @TableField(value="director_name")
    private String directorName; // 董事
    @TableField(value="supervisor")
    private Long supervisor; // 监事
    @TableField(value="supervisor_name")
    private String supervisorName; // 监事
    @TableField(value="general_manager")
    private Long generalManager; // 总经理
    @TableField(value="general_manager_name")
    private String generalManagerName; // 总经理
    @TableField(value="acting_holder")
    private Long actingHolder; // 代持方
    @TableField(value="acting_holder_name")
    private String actingHolderName; // 代持方
    @TableField(value="held_by_employees")
    private BigDecimal heldByEmployees; // 职工持有(%)
    @TableField(value="held_by_subsidiary")
    private BigDecimal heldBySubsidiary; // 分子公司持有(%)
    @TableField(value="held_by_local")
    private BigDecimal heldByLocal; // 当地居民或公司持有
    @TableField(value="date_incorporation")
    private Date dateIncorporation; // 成立日期
    @TableField(value="unified_social_credit_code")
    private String unifiedSocialCreditCode; // 统一社会信用代码
    @TableField(value="taxpayer_number")
    private String taxpayerNumber; // 纳税人识别号
    @TableField(value="bank_account_number")
    private String bankAccountNumber; // 银行基本账号
    @TableField(value="merge_type")
    private String mergeType; // 合并类型：newSet 新设，receive吸收
    @TableField(value="sub_type")
    private String subType; // 分立类型：解散、续存
    @TableField(value="production_state")
    private String productionState; // 产权登记状态：unregistered：未登记，registered：已登记，registering:登记中，noregister：不登记
    @TableField(value="apply_org_name")
    private String applyOrgName; // 申请组织(系统上下文组织)
    @TableField(value="apply_org_id")
    private Long applyOrgId; // 申请组织(系统上下文组织)
    @TableField(value="current_processor")
    private Long currentProcessor; // 当前处理人
    @TableField(value="current_processor_name")
    private String currentProcessorName; // 当前处理人
    @TableField(value="pending_start_time")
    private Date pendingStartTime; // 待处理开始时间
    @TableField(value="file_state")
    private String fileState; // 归档状态：toFile:待归档，filed:已归档
    
    @TableField(value="file_user")
    private String fileUser; // 归档人
    @TableField(value="file_time")
    private Date fileTime; // 归档时间
    
    @TableField(value="in_use_org_id")
    private Long inUseOrgId; // 在用组织id(用于组织详情关联查询申请单)
    
    @TableField(value="legal_flag")
    private Integer legalFlag; // 是否法人单位 ，1是法人，0非法人

    @TableField(value="production_num")
    private Integer productionNum; // 发生产权登记单数量
    
    @TableField(exist=false)
    @SubEntity(serviceName="orgApplyFileService", pidName="pid")
    private List<OrgApplyFileEntity> orgApplyFileList = new ArrayList<>(); // 组织申请单-上传档案项

    @TableField(exist=false)
    @SubEntity(serviceName="orgShareholderService", pidName="pid")
    private List<OrgShareholderEntity> orgShareholderList = new ArrayList<>(); // 组织申请单-上传档案项

    @TableField(exist=false)
    @SubEntity(serviceName="orgCancelService")
    private List<OrgCancelEntity> orgCancelList = new ArrayList<>(); // 组织申请单-组织机构合并-被注销企业
    
    @TableField(value="change_old_content")
    private String changeOldContent; // 变更前内容

    @TableField(value="org_code")
    private String orgCode; // 注销时公司编码
    /**
     * 申请单号
     */
    public String getCode() {
        return code;
    }

    /**
     * 申请单号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 申请单类型，set:设立申请，change：变更，del：注销，merge：合并，divide：分立，supplementary:补录
     */
    public String getApplyType() {
        return applyType;
    }

    /**
     * 申请单类型，set:设立申请，change：变更，del：注销，merge：合并，divide：分立，supplementary:补录
     */
    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }
    /**
     * 公司名称
     */
    public String getName() {
        return name;
    }

    /**
     * 公司名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 公司名称中文缩写
     */
    public String getNameShortCn() {
        return nameShortCn;
    }

    /**
     * 公司名称中文缩写
     */
    public void setNameShortCn(String nameShortCn) {
        this.nameShortCn = nameShortCn;
    }

    public Integer getProductionNum() {
        return productionNum;
    }

    public void setProductionNum(Integer productionNum) {
        this.productionNum = productionNum;
    }

    /**
     * 公司名称英文缩写
     */
    public String getNameShortEn() {
        return nameShortEn;
    }

    /**
     * 公司名称英文缩写
     */
    public void setNameShortEn(String nameShortEn) {
        this.nameShortEn = nameShortEn;
    }
    /**
     * 公司注册性质id
     */
    public Long getOrgNatureId() {
        return orgNatureId;
    }

    /**
     * 公司注册性质id
     */
    public void setOrgNatureId(Long orgNatureId) {
        this.orgNatureId = orgNatureId;
    }
    /**
     * 公司注册性质
     */
    public String getOrgNatureName() {
        return orgNatureName;
    }

    /**
     * 公司注册性质
     */
    public void setOrgNatureName(String orgNatureName) {
        this.orgNatureName = orgNatureName;
    }
    /**
     * 直接上级单位id
     */
    public Long getDirectSuperiorId() {
        return directSuperiorId;
    }

    /**
     * 直接上级单位id
     */
    public void setDirectSuperiorId(Long directSuperiorId) {
        this.directSuperiorId = directSuperiorId;
    }
    /**
     * 直接上级单位
     */
    public String getDirectSuperior() {
        return directSuperior;
    }

    /**
     * 直接上级单位
     */
    public void setDirectSuperior(String directSuperior) {
        this.directSuperior = directSuperior;
    }
    /**
     * 公司管理责任主体
     */
    public Long getSubjectCorporateManagementResponsibility() {
        return subjectCorporateManagementResponsibility;
    }

    /**
     * 公司管理责任主体
     */
    public void setSubjectCorporateManagementResponsibility(Long subjectCorporateManagementResponsibility) {
        this.subjectCorporateManagementResponsibility = subjectCorporateManagementResponsibility;
    }
    /**
     * 注册国家地区id
     */
    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    /**
     * 注册国家地区id
     */
    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    /**
     * 注册国家地区名称
     */
    public String getRegisterCountryName() {
        return registerCountryName;
    }

    /**
     * 注册国家地区名称
     */
    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    /**
     * 注册所在地区value
     */
    public String getRegisterAreaV() {
        return registerAreaV;
    }

    /**
     * 注册所在地区value
     */
    public void setRegisterAreaV(String registerAreaV) {
        this.registerAreaV = registerAreaV;
    }
    /**
     * 注册所在地区name
     */
    public String getRegisterAreaName() {
        return registerAreaName;
    }

    /**
     * 注册所在地区name
     */
    public void setRegisterAreaName(String registerAreaName) {
        this.registerAreaName = registerAreaName;
    }
    /**
     * 注册地详细地址
     */
    public String getRegisterAddress() {
        return registerAddress;
    }

    /**
     * 注册地详细地址
     */
    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress;
    }
    /**
     * 注册地境内/境外
     */
    public String getRegisterIn() {
        return registerIn;
    }

    /**
     * 注册地境内/境外
     */
    public void setRegisterIn(String registerIn) {
        this.registerIn = registerIn;
    }
    /**
     * 报表合并
     */
    public Boolean getReportMerge() {
        return reportMerge;
    }

    /**
     * 报表合并
     */
    public void setReportMerge(Boolean reportMerge) {
        this.reportMerge = reportMerge;
    }
    /**
     * 是否上报集团批复
     */
    public Boolean getWhetherReportToGroup() {
        return whetherReportToGroup;
    }

    /**
     * 是否上报集团批复
     */
    public void setWhetherReportToGroup(Boolean whetherReportToGroup) {
        this.whetherReportToGroup = whetherReportToGroup;
    }
    /**
     * 申请原因、注销原因
     */
    public String getApplyReason() {
        return applyReason;
    }

    /**
     * 申请原因、注销原因
     */
    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }
    /**
     * 营业范围
     */
    public String getBusinessScope() {
        return businessScope;
    }

    /**
     * 营业范围
     */
    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    /**
     * 注册资本
     */
    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    /**
     * 注册资本
     */
    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }
    /**
     * 注册资本币种id
     */
    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    /**
     * 注册资本币种id
     */
    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }
    /**
     * 注册资本币种名称
     */
    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    /**
     * 注册资本币种名称
     */
    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }
    /**
     * 控制状态id
     */
    public Long getControlStatus() {
        return controlStatus;
    }

    /**
     * 控制状态id
     */
    public void setControlStatus(Long controlStatus) {
        this.controlStatus = controlStatus;
    }
    /**
     * 控制状态
     */
    public String getControlStatusName() {
        return controlStatusName;
    }

    /**
     * 控制状态
     */
    public void setControlStatusName(String controlStatusName) {
        this.controlStatusName = controlStatusName;
    }
    /**
     * 股权比例
     */
    public BigDecimal getEquityRatio() {
        return equityRatio;
    }

    /**
     * 股权比例
     */
    public void setEquityRatio(BigDecimal equityRatio) {
        this.equityRatio = equityRatio;
    }
    /**
     * 法定人代表
     */
    public Long getLegalRepresentative() {
        return legalRepresentative;
    }

    /**
     * 法定人代表
     */
    public void setLegalRepresentative(Long legalRepresentative) {
        this.legalRepresentative = legalRepresentative;
    }
    /**
     * 法定人代表
     */
    public String getLegalRepresentativeName() {
        return legalRepresentativeName;
    }

    /**
     * 法定人代表
     */
    public void setLegalRepresentativeName(String legalRepresentativeName) {
        this.legalRepresentativeName = legalRepresentativeName;
    }
    /**
     * 董事
     */
    public Long getDirector() {
        return director;
    }

    /**
     * 董事
     */
    public void setDirector(Long director) {
        this.director = director;
    }
    /**
     * 董事
     */
    public String getDirectorName() {
        return directorName;
    }

    /**
     * 董事
     */
    public void setDirectorName(String directorName) {
        this.directorName = directorName;
    }
    /**
     * 监事
     */
    public Long getSupervisor() {
        return supervisor;
    }

    /**
     * 监事
     */
    public void setSupervisor(Long supervisor) {
        this.supervisor = supervisor;
    }
    /**
     * 监事
     */
    public String getSupervisorName() {
        return supervisorName;
    }

    /**
     * 监事
     */
    public void setSupervisorName(String supervisorName) {
        this.supervisorName = supervisorName;
    }
    /**
     * 总经理
     */
    public Long getGeneralManager() {
        return generalManager;
    }

    /**
     * 总经理
     */
    public void setGeneralManager(Long generalManager) {
        this.generalManager = generalManager;
    }
    /**
     * 总经理
     */
    public String getGeneralManagerName() {
        return generalManagerName;
    }

    /**
     * 总经理
     */
    public void setGeneralManagerName(String generalManagerName) {
        this.generalManagerName = generalManagerName;
    }
    /**
     * 代持方
     */
    public Long getActingHolder() {
        return actingHolder;
    }

    /**
     * 代持方
     */
    public void setActingHolder(Long actingHolder) {
        this.actingHolder = actingHolder;
    }
    /**
     * 职工持有(%)
     */
    public BigDecimal getHeldByEmployees() {
        return heldByEmployees;
    }

    /**
     * 职工持有(%)
     */
    public void setHeldByEmployees(BigDecimal heldByEmployees) {
        this.heldByEmployees = heldByEmployees;
    }
    /**
     * 分子公司持有(%)
     */
    public BigDecimal getHeldBySubsidiary() {
        return heldBySubsidiary;
    }

    /**
     * 分子公司持有(%)
     */
    public void setHeldBySubsidiary(BigDecimal heldBySubsidiary) {
        this.heldBySubsidiary = heldBySubsidiary;
    }
    /**
     * 当地居民或公司持有
     */
    public BigDecimal getHeldByLocal() {
        return heldByLocal;
    }

    /**
     * 当地居民或公司持有
     */
    public void setHeldByLocal(BigDecimal heldByLocal) {
        this.heldByLocal = heldByLocal;
    }
    /**
     * 成立日期
     */
    public Date getDateIncorporation() {
        return dateIncorporation;
    }

    /**
     * 成立日期
     */
    public void setDateIncorporation(Date dateIncorporation) {
        this.dateIncorporation = dateIncorporation;
    }
    /**
     * 统一社会信用代码
     */
    public String getUnifiedSocialCreditCode() {
        return unifiedSocialCreditCode;
    }

    /**
     * 统一社会信用代码
     */
    public void setUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        this.unifiedSocialCreditCode = unifiedSocialCreditCode;
    }
    /**
     * 纳税人识别号
     */
    public String getTaxpayerNumber() {
        return taxpayerNumber;
    }

    /**
     * 纳税人识别号
     */
    public void setTaxpayerNumber(String taxpayerNumber) {
        this.taxpayerNumber = taxpayerNumber;
    }
    /**
     * 银行基本账号
     */
    public String getBankAccountNumber() {
        return bankAccountNumber;
    }

    /**
     * 银行基本账号
     */
    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }
    /**
     * 合并类型：新设，吸收
     */
    public String getMergeType() {
        return mergeType;
    }

    /**
     * 合并类型：新设 newSet ，吸收 receive
     */
    public void setMergeType(String mergeType) {
        this.mergeType = mergeType;
    }
    /**
     * 分立类型：解散、续存
     */
    public String getSubType() {
        return subType;
    }

    /**
     * 分立类型：解散、续存
     */
    public void setSubType(String subType) {
        this.subType = subType;
    }
    /**
     * 产权登记状态：unregistered：未登记，registered：已登记，registering:登记中，noregister：不登记
     */
    public String getProductionState() {
        return productionState;
    }

    /**
     * 产权登记状态：unregistered：未登记，registered：已登记，registering:登记中，noregister：不登记
     */
    public void setProductionState(String productionState) {
        this.productionState = productionState;
    }
    /**
     * 申请组织(系统上下文组织)
     */
    public String getApplyOrgName() {
        return applyOrgName;
    }

    /**
     * 申请组织(系统上下文组织)
     */
    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    /**
     * 当前处理人
     */
    public Long getCurrentProcessor() {
        return currentProcessor;
    }

    /**
     * 当前处理人
     */
    public void setCurrentProcessor(Long currentProcessor) {
        this.currentProcessor = currentProcessor;
    }
    /**
     * 当前处理人
     */
    public String getCurrentProcessorName() {
        return currentProcessorName;
    }

    /**
     * 当前处理人
     */
    public void setCurrentProcessorName(String currentProcessorName) {
        this.currentProcessorName = currentProcessorName;
    }
    /**
     * 待处理开始时间
     */
    public Date getPendingStartTime() {
        return pendingStartTime;
    }

    /**
     * 待处理开始时间
     */
    public void setPendingStartTime(Date pendingStartTime) {
        this.pendingStartTime = pendingStartTime;
    }
    /**
     * 归档状态：toFile:待归档，filed:已归档
     */
    public String getFileState() {
        return fileState;
    }

    /**
     * 归档状态：toFile:待归档，filed:已归档
     */
    public void setFileState(String fileState) {
        this.fileState = fileState;
    }
    /**
     * 在用组织id(用于组织详情关联查询申请单)
     */
    public Long getInUseOrgId() {
        return inUseOrgId;
    }

    /**
     * 在用组织id(用于组织详情关联查询申请单)
     */
    public void setInUseOrgId(Long inUseOrgId) {
        this.inUseOrgId = inUseOrgId;
    }

	public String getFileUser() {
		return fileUser;
	}

	public void setFileUser(String fileUser) {
		this.fileUser = fileUser;
	}

	public Date getFileTime() {
		return fileTime;
	}

	public void setFileTime(Date fileTime) {
		this.fileTime = fileTime;
	}
	
	public List<OrgApplyFileEntity> getOrgApplyFileList() {
		return orgApplyFileList;
	}

	public void setOrgApplyFileList(List<OrgApplyFileEntity> orgApplyFileList) {
		this.orgApplyFileList = orgApplyFileList;
	}

	public List<OrgShareholderEntity> getOrgShareholderList() {
		return orgShareholderList;
	}

	public void setOrgShareholderList(List<OrgShareholderEntity> orgShareholderList) {
		this.orgShareholderList = orgShareholderList;
	}

    public List<OrgCancelEntity> getOrgCancelList() {
        return orgCancelList;
    }

    public void setOrgCancelList(List<OrgCancelEntity> orgCancelList) {
        this.orgCancelList = orgCancelList;
    }

    public Integer getLegalFlag() {
		return legalFlag;
	}

	public void setLegalFlag(Integer legalFlag) {
		this.legalFlag = legalFlag;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public Long getApplyOrgId() {
		return applyOrgId;
	}

	public void setApplyOrgId(Long applyOrgId) {
		this.applyOrgId = applyOrgId;
	}

	public String getChangeOldContent() {
		return changeOldContent;
	}

	public void setChangeOldContent(String changeOldContent) {
		this.changeOldContent = changeOldContent;
	}

	public Long getDirectSuperiorOrgId() {
		return directSuperiorOrgId;
	}

	public void setDirectSuperiorOrgId(Long directSuperiorOrgId) {
		this.directSuperiorOrgId = directSuperiorOrgId;
	}

	public String getSubjectCorporateManagementResponsibilityName() {
		return subjectCorporateManagementResponsibilityName;
	}

	public void setSubjectCorporateManagementResponsibilityName(String subjectCorporateManagementResponsibilityName) {
		this.subjectCorporateManagementResponsibilityName = subjectCorporateManagementResponsibilityName;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getActingHolderName() {
		return actingHolderName;
	}

	public void setActingHolderName(String actingHolderName) {
		this.actingHolderName = actingHolderName;
	}
	
}
