/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.orgcenter.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.orgcenter.bean.DirectorEntity;
import com.ejianc.business.orgcenter.service.IDirectorService;
import com.ejianc.business.orgcenter.vo.DirectorVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/director/"})
public class DirectorController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDirectorService directorService;
    @Autowired
    private IBillTypeApi billTypeApi;
    private String billTypeCode = "BT211101000000002";

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<DirectorVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.directorService.queryPage(queryParam, false);
        Page result = new Page();
        result.setTotal(page.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DirectorVO.class));
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        result.setPages(page.getPages());
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<DirectorVO> saveOrUpdate(@RequestBody DirectorVO vo) {
        List billCodeEntityList;
        DirectorEntity saveEntity = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)vo.getBillCode());
        if (null != vo.getId()) {
            query.ne((Object)"id", (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(billCodeEntityList = this.directorService.list((Wrapper)query)))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4eba\u5458\u7f16\u53f7\u91cd\u590d\uff01");
        }
        if (null == vo.getId()) {
            saveEntity = (DirectorEntity)((Object)BeanMapper.map((Object)vo, DirectorEntity.class));
            saveEntity.setStatus(DirectorVO.DIRECTOR_STATUS_VALID);
        } else {
            saveEntity = (DirectorEntity)((Object)this.directorService.selectById(vo.getId()));
            saveEntity.setDirectorName(vo.getDirectorName());
            saveEntity.setBillCode(vo.getBillCode());
            saveEntity.setOrgName(vo.getOrgName());
            saveEntity.setPostName(vo.getPostName());
        }
        this.directorService.saveOrUpdate((Object)saveEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)saveEntity), DirectorVO.class));
    }

    @PostMapping(value={"saveEmployeeRefers"})
    public CommonResponse<String> saveEmployeeRefers(@RequestBody List<DirectorVO> vos) {
        ArrayList idList = new ArrayList();
        ArrayList billCodeList = new ArrayList();
        HashMap voMap = new HashMap();
        vos.stream().forEach(vo -> {
            idList.add(vo.getId());
            voMap.put(vo.getId(), vo);
            billCodeList.add(vo.getBillCode());
        });
        QueryWrapper repeatQuery = new QueryWrapper();
        repeatQuery.in((Object)"bill_code", billCodeList);
        List billCodeEntityList = this.directorService.list((Wrapper)repeatQuery);
        if (CollectionUtils.isNotEmpty((Collection)billCodeEntityList)) {
            for (DirectorEntity dire : billCodeEntityList) {
                if (null != voMap.get(dire.getId()) && ((DirectorVO)voMap.get(dire.getId())).equals(dire.getBillCode())) continue;
                return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u7f16\u53f7\u4e3a" + dire.getBillCode() + "\u7684\u4eba\u5458\uff01"));
            }
        }
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", idList);
        List saveList = this.directorService.list((Wrapper)query);
        DirectorVO tmp = null;
        if (CollectionUtils.isNotEmpty((Collection)saveList)) {
            for (DirectorEntity directorEntity : saveList) {
                tmp = (DirectorVO)voMap.get(directorEntity.getId());
                directorEntity.setPostName(tmp.getPostName());
                directorEntity.setOrgName(tmp.getOrgName());
                directorEntity.setBillCode(tmp.getBillCode());
                directorEntity.setDirectorName(tmp.getDirectorName());
                vos.remove(tmp);
            }
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            DirectorEntity e = null;
            for (DirectorVO d : vos) {
                e = (DirectorEntity)((Object)BeanMapper.map((Object)d, DirectorEntity.class));
                e.setCreateTime(null);
                e.setCreateUserCode(null);
                e.setUpdateTime(null);
                e.setUpdateUserCode(null);
                saveList.add(e);
            }
        }
        this.directorService.saveOrUpdateBatch(saveList, vos.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<DirectorVO> queryDetail(@RequestParam(value="id") Long id) {
        DirectorVO resp = null;
        DirectorEntity dbEntity = (DirectorEntity)((Object)this.directorService.selectById(id));
        if (null != dbEntity) {
            resp = (DirectorVO)BeanMapper.map((Object)((Object)dbEntity), DirectorVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<DirectorVO> vos) {
        Boolean deleteFlag = true;
        String returnMsg = "";
        if (CollectionUtils.isNotEmpty(vos)) {
            for (DirectorVO e : vos) {
                CommonResponse resp;
                if (e.getId() == null || (resp = this.billTypeApi.checkQuote(this.billTypeCode, e.getId())).isSuccess()) continue;
                if (deleteFlag.booleanValue()) {
                    deleteFlag = false;
                }
                this.logger.info("\u8463\u76d1\u9ad8\u4eba\u5458\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
                if (StringUtils.isBlank((CharSequence)returnMsg)) {
                    returnMsg = returnMsg + "\u5458\u5de5\uff1a" + e.getDirectorName();
                    continue;
                }
                returnMsg = returnMsg + "\u3001" + e.getDirectorName();
            }
        }
        if (!deleteFlag.booleanValue()) {
            returnMsg = returnMsg + " \u5df2\u5728\u4e1a\u52a1\u5355\u636e\u4e2d\u4f7f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\uff01";
            return CommonResponse.error((String)returnMsg);
        }
        this.directorService.batchDelByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"changeStatus"})
    public CommonResponse<String> changeStatus(@RequestBody DirectorVO vo) {
        DirectorEntity dbEntity = (DirectorEntity)((Object)this.directorService.selectById(vo.getId()));
        if (null != dbEntity) {
            dbEntity.setStatus(vo.getStatus());
            this.directorService.saveOrUpdate((Object)dbEntity, false);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"syncEmployeeDetails"})
    public CommonResponse<String> syncEmployeeDetails() {
        this.directorService.syncEmployeeDetails();
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @RequestMapping(value={"queryRefList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DirectorVO>> queryRefList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)DirectorVO.DIRECTOR_STATUS_VALID));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                param.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("directorName");
            fuzzyFields.add("orgName");
            fuzzyFields.add("postName");
            fuzzyFields.add("billCode");
        }
        IPage page = this.directorService.queryPage(param, false);
        Page result = new Page();
        result.setTotal(page.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DirectorVO.class));
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        result.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u4ed3\u5e93\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }
}

