/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.mapper.ProductionMapper;
import com.ejianc.business.production.service.IProductionOrgService;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.production.vo.OrgApplyVOS;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.bean.SddjsOrgEntity;
import com.ejianc.business.sddjsorg.mapper.OrgShareholderMapper;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.IOrgShareholderService;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productionService")
public class ProductionServiceImpl
extends BaseServiceImpl<ProductionMapper, ProductionEntity>
implements IProductionService {
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private OrgShareholderMapper orgShareholderMapper;
    @Autowired
    private IOrgShareholderService orgShareholderService;
    @Autowired
    private IProductionTypeItemService productionTypeItemService;
    @Autowired
    private ProductionMapper productionMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISddjsOrgService sddjsOrgService;
    @Autowired
    private IProductionOrgService productionOrgService;

    @Override
    public CommonResponse<String> assignTask(Map<String, String> param) {
        try {
            String applyId = param.get("applyId");
            String userId = param.get("userId");
            String userName = param.get("userName");
            OrgApplyEntity orgApplyEntity = (OrgApplyEntity)((Object)this.orgApplyService.getById(Long.valueOf(applyId)));
            orgApplyEntity.setCurrentProcessorName(userName);
            orgApplyEntity.setCurrentProcessor(Long.valueOf(userId));
            orgApplyEntity.setPendingStartTime(new Date());
            this.orgApplyService.saveOrUpdate((Object)orgApplyEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success((String)"\u6307\u6d3e\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u6307\u6d3e\u6210\u529f");
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdList(Long applyId, String contributionType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)applyId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (StringUtils.isNotBlank((String)contributionType)) {
            queryWrapper.eq((Object)"contribution_type", (Object)contributionType);
        } else {
            queryWrapper.ne((Object)"contribution_type", (Object)"\u73b0\u91d1");
        }
        return this.orgShareholderMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<ProductionTypeItemEntity> queryProductionTypeItemList(String productionTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"production_type_code", (Object)productionTypeCode);
        queryWrapper.eq((Object)"in_use", (Object)1);
        return this.productionTypeItemService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdAllList(Long pid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)pid);
        queryWrapper.eq((Object)"dr", (Object)"0");
        return this.orgShareholderMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<CapitalVO> queryApplyShareholderByApplyIdSumCaptailName(Long pid) {
        ArrayList<CapitalVO> resp = new ArrayList<CapitalVO>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"  sum(subscribed_capital) as  declaredNumberEnterprises,captail_type as  captailType"});
        query.eq((Object)"pid", (Object)pid);
        query.groupBy((Object[])new String[]{"captail_type"});
        List listMaps = this.orgShareholderService.listMaps((Wrapper)query);
        for (int i = 0; i < listMaps.size(); ++i) {
            Map map = (Map)listMaps.get(i);
            CapitalVO vo = new CapitalVO();
            vo.setCaptailType((String)map.get("captailType"));
            vo.setDeclaredNumberEnterprises(map.get("declaredNumberEnterprises") != null ? new BigDecimal(map.get("declaredNumberEnterprises").toString()) : BigDecimal.ZERO.setScale(8));
            vo.setId(Long.valueOf(IdWorker.getId()));
            resp.add(vo);
        }
        return resp;
    }

    @Override
    public List<ProductionEntity> checkUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"unified_social_credit_code", (Object)unifiedSocialCreditCode);
        List list = this.productionMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public List<ProductionEntity> queryProductionByApplyId(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_apply_id", (Object)applyId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{"1,3"});
        List list = this.productionMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public CommonResponse<String> updateNoRegister(OrgApplyEntity applyEntity) {
        SddjsOrgEntity sddjsOrgEntity = (SddjsOrgEntity)((Object)this.sddjsOrgService.getById(applyEntity.getInUseOrgId()));
        if (applyEntity.getApplyType().equals("del")) {
            this.updateCancellation(sddjsOrgEntity);
        } else {
            OrgVO orgVO = this.saveOrUpdateOrg(sddjsOrgEntity);
            sddjsOrgEntity.setOrgId(orgVO.getId());
        }
        if ("set".equals(applyEntity.getApplyType()) || "supplementary".equals(applyEntity.getApplyType()) || "merge".equals(applyEntity.getApplyType()) && "newSet".equals(applyEntity.getMergeType())) {
            sddjsOrgEntity.setRegister("noregister");
        }
        this.sddjsOrgService.saveOrUpdate((Object)sddjsOrgEntity);
        applyEntity.setProductionState("noregister");
        this.orgApplyService.saveOrUpdate((Object)applyEntity);
        return CommonResponse.success((String)"\u4e0d\u767b\u8bb0\u6210\u529f");
    }

    @Override
    public OrgApplyVOS queryDel(Long inUseOrgId) {
        ProductionEntity entity = this.queryByInUseId(inUseOrgId);
        if (entity == null) {
            throw new BusinessException("\u8be5\u4f01\u4e1a\u6ca1\u767b\u8bb0");
        }
        ProductionEntity productionEntity = (ProductionEntity)((Object)this.selectById(entity.getId()));
        OrgApplyVOS vo = (OrgApplyVOS)BeanMapper.map((Object)((Object)productionEntity), OrgApplyVOS.class);
        vo.setId(null);
        vo.setCreateTime(null);
        vo.setApplyType("del");
        return vo;
    }

    @Override
    public List<ProductionOrgEntity> getProductionOrgByInUseId(Long[] inUseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"in_use_org_id", (Object[])inUseId);
        queryWrapper.eq((Object)"use_status", (Object)true);
        List list = this.productionOrgService.list((Wrapper)queryWrapper);
        return list;
    }

    public ProductionEntity queryByInUseId(Long inUserOrgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"in_use_org_id", (Object)inUserOrgId);
        queryWrapper.in((Object)"apply_type", new Object[]{"set", "supplementary"});
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ProductionEntity entity = (ProductionEntity)((Object)list.get(0));
            return entity;
        }
        return null;
    }

    @Transactional
    public OrgVO saveOrUpdateOrg(SddjsOrgEntity sddjsOrgEntity) {
        CommonResponse responseOrgVo = this.orgApi.getOneById(sddjsOrgEntity.getOrgId());
        OrgVO projectDepartment = new OrgVO();
        if (responseOrgVo.getData() != null) {
            projectDepartment = (OrgVO)responseOrgVo.getData();
        } else {
            projectDepartment.setId(Long.valueOf(IdWorker.getId()));
        }
        projectDepartment.setParentId(sddjsOrgEntity.getDirectSuperiorOrgId());
        projectDepartment.setTenantId(InvocationInfoProxy.getTenantid());
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setName(sddjsOrgEntity.getName());
        projectDepartment.setShortName(sddjsOrgEntity.getName());
        projectDepartment.setState(Integer.valueOf(1));
        projectDepartment.setOrgType(Integer.valueOf(2));
        CommonResponse commonResponse = this.orgApi.saveOrgInfo(projectDepartment);
        if (commonResponse.getCode() != 0) {
            throw new BusinessException("\u63a8\u9001\u7ec4\u7ec7\u7ed3\u6784\u5f02\u5e38");
        }
        return (OrgVO)commonResponse.getData();
    }

    public void updateCancellation(SddjsOrgEntity sddjsOrgEntity) {
        CommonResponse responseOrgVo = this.orgApi.getOneById(sddjsOrgEntity.getOrgId());
        OrgVO projectDepartment = new OrgVO();
        if (responseOrgVo.getData() != null) {
            projectDepartment = (OrgVO)responseOrgVo.getData();
            projectDepartment.setState(Integer.valueOf(0));
            this.orgApi.saveOrgInfo(projectDepartment);
        }
    }
}

