/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sddjsorg.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.IOrgShareholderService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.business.sddjsorg.vo.OrgShareholderVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"orgApply"})
public class OrgApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sddjs-org-apply";
    @Autowired
    private IOrgApplyService service;
    @Autowired
    private IOrgShareholderService orgShareholderService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrgApplyVO> saveOrUpdate(@RequestBody OrgApplyVO saveorUpdateVO) {
        OrgApplyEntity entity;
        if ("set".equals(saveorUpdateVO.getApplyType()) || "supplementary".equals(saveorUpdateVO.getApplyType()) || "merge".equals(saveorUpdateVO.getApplyType()) && "newSet".equals(saveorUpdateVO.getMergeType())) {
            this.checkRepetition(saveorUpdateVO);
        }
        if ((entity = (OrgApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OrgApplyEntity.class))).getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setProductionState("unregistered");
            entity.setProductionNum(0);
        }
        if (entity.getApplyType().equals("change")) {
            QueryWrapper applyingWrapper = new QueryWrapper();
            applyingWrapper.eq((Object)"file_state", (Object)"filed");
            applyingWrapper.eq((Object)"in_use_org_id", (Object)entity.getInUseOrgId());
            applyingWrapper.eq((Object)"apply_type", (Object)"change");
            applyingWrapper.orderByDesc((Object)"create_time");
            List list = this.service.list((Wrapper)applyingWrapper);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                OrgApplyEntity orgApplyEntity = (OrgApplyEntity)((Object)this.service.selectById(((OrgApplyEntity)((Object)list.get(0))).getId()));
                entity.setChangeOldBefore(JSON.toJSONString((Object)((Object)orgApplyEntity)));
                entity.setShareholderChangeBefore(JSON.toJSONString(orgApplyEntity.getOrgShareholderList()));
                entity.setShareholderChangeAfter(JSON.toJSONString((Object)saveorUpdateVO.getOrgShareholderList()));
            } else {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"in_use_org_id", (Object)entity.getInUseOrgId());
                queryWrapper.eq((Object)"apply_type", (Object)"set");
                queryWrapper.eq((Object)"file_state", (Object)"filed");
                queryWrapper.orderByDesc((Object)"create_time");
                List setList = this.service.list((Wrapper)queryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)setList)) {
                    OrgApplyEntity orgApplyEntity = (OrgApplyEntity)((Object)this.service.selectById(((OrgApplyEntity)((Object)setList.get(0))).getId()));
                    entity.setChangeOldBefore(JSON.toJSONString((Object)((Object)orgApplyEntity)));
                    entity.setShareholderChangeBefore(JSON.toJSONString(orgApplyEntity.getOrgShareholderList()));
                    entity.setShareholderChangeAfter(JSON.toJSONString((Object)saveorUpdateVO.getOrgShareholderList()));
                }
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public void checkRepetition(OrgApplyVO saveorUpdateVO) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter("eq", (Object)saveorUpdateVO.getName()));
        ArrayList<String> applyType = new ArrayList<String>();
        applyType.add("set");
        applyType.add("supplementary");
        queryParam.getParams().put("applyType", new Parameter("in", applyType));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (saveorUpdateVO.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)saveorUpdateVO.getId()));
        }
        if ((list = this.service.queryList(queryParam, false)) != null && list.size() > 0) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u5df2\u7ecf\u5b58\u5728\u516c\u53f8\u540d\u79f0\u4e3a[" + saveorUpdateVO.getName() + "]\u7684\u7ec4\u7ec7\u673a\u6784");
        }
        if (StringUtils.isNotBlank((CharSequence)saveorUpdateVO.getUnifiedSocialCreditCode())) {
            List listCode;
            QueryParam queryParamCode = new QueryParam();
            queryParamCode.getParams().put("unifiedSocialCreditCode", new Parameter("eq", (Object)saveorUpdateVO.getUnifiedSocialCreditCode()));
            queryParamCode.getParams().put("applyType", new Parameter("in", applyType));
            queryParamCode.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            if (saveorUpdateVO.getId() != null) {
                queryParamCode.getParams().put("id", new Parameter("ne", (Object)saveorUpdateVO.getId()));
            }
            if ((listCode = this.service.queryList(queryParamCode, false)) != null && listCode.size() > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u5df2\u7ecf\u5b58\u5728\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a[" + saveorUpdateVO.getUnifiedSocialCreditCode() + "]\u7684\u7ec4\u7ec7\u673a\u6784");
            }
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgApplyVO> queryDetail(Long id) {
        OrgApplyEntity entity = (OrgApplyEntity)((Object)this.service.selectById(id));
        OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrgApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("nameShortCn");
        fuzzyFields.add("nameShortEn");
        fuzzyFields.add("orgNatureName");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("registerAreaName");
        fuzzyFields.add("actingHolderName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("applyOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("nameShortCn");
        fuzzyFields.add("nameShortEn");
        fuzzyFields.add("orgNatureName");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("registerAreaName");
        fuzzyFields.add("actingHolderName");
        String type = "";
        if (param.getParams().get("type") != null) {
            type = ((Parameter)param.getParams().get("type")).getValue().toString();
            param.getParams().remove("type");
        }
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("applyOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, OrgApplyVO.class);
        for (OrgApplyVO vo : vos) {
            if ("set".equals(vo.getApplyType())) {
                vo.setApplyTypeName("\u8bbe\u7acb\u7533\u8bf7");
            } else if ("change".equals(vo.getApplyType())) {
                vo.setApplyTypeName("\u53d8\u66f4\u7533\u8bf7");
            } else if ("del".equals(vo.getApplyType())) {
                vo.setApplyTypeName("\u6ce8\u9500\u7533\u8bf7");
            } else if ("merge".equals(vo.getApplyType())) {
                vo.setApplyTypeName("\u5408\u5e76\u7533\u8bf7");
            } else if ("divide".equals(vo.getApplyType())) {
                vo.setApplyTypeName("\u5206\u7acb\u7533\u8bf7");
            } else if ("supplementary".equals(vo.getApplyType())) {
                vo.setApplyTypeName("\u8865\u5f55\u7533\u8bf7");
            }
            vo.setCreateDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)vo.getCreateTime()));
            if (vo.getPendingStartTime() != null) {
                vo.setPendingStartDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)vo.getPendingStartTime()));
            }
            if (vo.getFileTime() != null) {
                vo.setFileDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)vo.getFileTime()));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getProductionState())) {
                if (vo.getProductionState().equals("unregistered")) {
                    vo.setProductionStateName("\u672a\u767b\u8bb0");
                } else if (vo.getProductionState().equals("registered")) {
                    vo.setProductionStateName("\u5df2\u767b\u8bb0");
                } else if (vo.getProductionState().equals("registering")) {
                    vo.setProductionStateName("\u767b\u8bb0\u4e2d");
                } else if (vo.getProductionState().equals("noregister")) {
                    vo.setProductionStateName("\u4e0d\u767b\u8bb0");
                }
            }
            if (vo.getBillState() == 0) {
                vo.setBillStateName("\u81ea\u7531\u6001");
                continue;
            }
            if (vo.getBillState() == 1) {
                vo.setBillStateName("\u5df2\u63d0\u4ea4");
                continue;
            }
            if (vo.getBillState() == 2) {
                vo.setBillStateName("\u5ba1\u6279\u4e2d");
                continue;
            }
            if (vo.getBillState() == 3) {
                vo.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                continue;
            }
            if (vo.getBillState() == 4) {
                vo.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                continue;
            }
            if (vo.getBillState() != 5) continue;
            vo.setBillStateName("\u5ba1\u6279\u4e2d");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        String fileName = "orgApplyExport.xlsx";
        if (StringUtils.isNotBlank((CharSequence)type)) {
            if ("apply".equals(type)) {
                fileName = "orgApplyExport.xlsx";
            }
            if ("toFile".equals(type)) {
                fileName = "orgTofileExport.xlsx";
            }
            if ("filed".equals(type)) {
                fileName = "orgFiledExport.xlsx";
            }
            if ("supplementary".equals(type)) {
                fileName = "orgSupplementaryApplyExport.xlsx";
            }
        }
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    @RequestMapping(value={"/refOrgApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> refOrgApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refOrgShareholderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrgShareholderVO>> refOrgShareholderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"orgApplyId") == null) {
                return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5931\u8d25\uff0c\u7ec4\u7ec7\u673a\u6784\u7533\u8bf7id\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5931\u8d25\uff0c\u7ec4\u7ec7\u673a\u6784\u7533\u8bf7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.getParams().put("pid", new Parameter("eq", (Object)_con.get((Object)"orgApplyId").toString()));
        IPage page = this.orgShareholderService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgShareholderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/file"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> file(Long id) {
        return this.service.file(id);
    }

    @RequestMapping(value={"/unfile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> unfile(Long id) {
        return this.service.unfile(id);
    }

    @RequestMapping(value={"/assign"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> assign(@RequestBody OrgApplyVO saveorUpdateVO) {
        OrgApplyEntity entity = (OrgApplyEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setCurrentProcessor(saveorUpdateVO.getCurrentProcessor());
        entity.setCurrentProcessorName(saveorUpdateVO.getCurrentProcessorName());
        entity.setPendingStartTime(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        String[] receivers = new String[]{saveorUpdateVO.getCurrentProcessor().toString()};
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5f85\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u8bbe\u7acb\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName());
        String url = this.baseHost + "ejc-sddjsorg-frontend/#/orgApply/setApplyCard?id=" + entity.getId();
        parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5f85\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u8bbe\u7acb\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        if ("change".equals(saveorUpdateVO.getApplyType())) {
            url = this.baseHost + "ejc-sddjsorg-frontend/#/orgApply/changeCard?id=" + entity.getId();
            parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5f85\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u53d8\u66f4\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName());
            parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5f85\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u53d8\u66f4\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        }
        if ("del".equals(saveorUpdateVO.getApplyType())) {
            url = this.baseHost + "ejc-sddjsorg-frontend/#/orgApply/cancellationCard?id=" + entity.getId();
            parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5f85\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u6ce8\u9500\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName());
            parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5f85\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u6ce8\u9500\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        }
        if ("merge".equals(saveorUpdateVO.getApplyType())) {
            url = this.baseHost + "ejc-sddjsorg-frontend/#/orgApply/cancellationCard?id=" + entity.getId();
            parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5f85\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u5408\u5e76\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName());
            parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5f85\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u5408\u5e76\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        }
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
        return CommonResponse.success((String)"\u6307\u6d3e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/supplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrgApplyVO> supplement(@RequestBody OrgApplyVO saveorUpdateVO) {
        if ("set".equals(saveorUpdateVO.getApplyType()) || "supplementary".equals(saveorUpdateVO.getApplyType())) {
            this.checkRepetition(saveorUpdateVO);
        }
        OrgApplyEntity entity = (OrgApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OrgApplyEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        String[] receivers = new String[]{saveorUpdateVO.getCurrentProcessor().toString()};
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject("\u3010\u7ec4\u7ec7\u673a\u6784\u8bbe\u7acb\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f");
        String url = this.baseHost + "ejc-sddjsorg-frontend/#/orgApply/setApplyCard?id=" + entity.getId();
        parameter.setContent("\u3010\u7ec4\u7ec7\u673a\u6784\u8bbe\u7acb\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        if ("change".equals(saveorUpdateVO.getApplyType())) {
            url = this.baseHost + "ejc-sddjsorg-frontend/#/orgApply/changeCard?id=" + entity.getId();
            parameter.setSubject("\u3010\u7ec4\u7ec7\u673a\u6784\u53d8\u66f4\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f");
            parameter.setContent("\u3010\u7ec4\u7ec7\u673a\u6784\u53d8\u66f4\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        }
        if ("del".equals(saveorUpdateVO.getApplyType())) {
            url = this.baseHost + "ejc-sddjsorg-frontend/#/orgApply/cancellationCard?id=" + entity.getId();
            parameter.setSubject("\u3010\u7ec4\u7ec7\u673a\u6784\u6ce8\u9500\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f");
            parameter.setContent("\u3010\u7ec4\u7ec7\u673a\u6784\u6ce8\u9500\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        }
        if ("merge".equals(saveorUpdateVO.getApplyType())) {
            url = this.baseHost + "ejc-sddjsorg-frontend/#/orgApply/cancellationCard?id=" + entity.getId();
            parameter.setSubject("\u3010\u7ec4\u7ec7\u673a\u6784\u5408\u5e76\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f");
            parameter.setContent("\u3010\u7ec4\u7ec7\u673a\u6784\u5408\u5e76\u7533\u8bf7\u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        }
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
        OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryNumber"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryNumber() {
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper applyingWrapper = new QueryWrapper();
        ArrayList<String> applyType = new ArrayList<String>();
        applyType.add("set");
        applyType.add("change");
        applyType.add("del");
        applyType.add("merge");
        applyType.add("divide");
        applyingWrapper.in((Object)"apply_type", applyType);
        ArrayList<Integer> billState = new ArrayList<Integer>();
        billState.add(0);
        billState.add(2);
        billState.add(5);
        applyingWrapper.in((Object)"bill_state", billState);
        applyingWrapper.eq((Object)"dr", (Object)0);
        applyingWrapper.in((Object)"apply_org_id", orgIds);
        Integer applyingNumber = this.service.count((Wrapper)applyingWrapper);
        QueryWrapper tofileWrapper = new QueryWrapper();
        tofileWrapper.in((Object)"apply_type", applyType);
        tofileWrapper.eq((Object)"file_state", (Object)"toFile");
        tofileWrapper.eq((Object)"dr", (Object)0);
        tofileWrapper.in((Object)"apply_org_id", orgIds);
        Integer tofileNumber = this.service.count((Wrapper)tofileWrapper);
        QueryWrapper filedWrapper = new QueryWrapper();
        filedWrapper.in((Object)"apply_type", applyType);
        filedWrapper.eq((Object)"file_state", (Object)"filed");
        filedWrapper.eq((Object)"dr", (Object)0);
        filedWrapper.in((Object)"apply_org_id", orgIds);
        Integer filedNumber = this.service.count((Wrapper)filedWrapper);
        JSONObject json = new JSONObject();
        json.put("applyingNumber", (Object)applyingNumber);
        json.put("tofileNumber", (Object)tofileNumber);
        json.put("filedNumber", (Object)filedNumber);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryCheckChange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryCheckChange(Long inUseOrgId) {
        if (this.service.queryCheckChange(inUseOrgId).booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f01\u4e1a\u5b58\u5728\u672a\u5f52\u6863\u7684\u53d8\u66f4\uff0c\u4e0d\u80fd\u91cd\u65b0\u7533\u8bf7\uff01");
        }
        return CommonResponse.success((String)"\u6210\u529f");
    }

    @RequestMapping(value={"/queryUseDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgApplyVO> queryUseDetail(Long inUseOrgId) {
        QueryWrapper applyingWrapper = new QueryWrapper();
        applyingWrapper.eq((Object)"in_use_org_id", (Object)inUseOrgId);
        applyingWrapper.eq((Object)"apply_type", (Object)"change");
        applyingWrapper.orderByDesc((Object)"create_time");
        List list = this.service.list((Wrapper)applyingWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            OrgApplyEntity entity = (OrgApplyEntity)((Object)list.get(0));
            OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }
}

