package com.ejianc.business.projectapply.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 项目申请-执行主体
 *
 * @author CJ
 * @Description: 项目申请-执行主体
 * @date 2021/9/6 9:46
 */
@TableName(value = "ejc_sddjsproject_executive_agent")
public class ExecutiveAgentEntity extends BaseEntity {
    private static final long serialVersionUID = -6754129515659486169L;


    /**
     * 项目申请主表Id
     */
    @TableField(value = "project_apply_id")
    private Long projectApplyId;

    /**
     * 拆分类型：E、P、C、O，
     * 仅当拆分项目时有值，非拆分项目该字段无效
     */
    @TableField(value = "split_type")
    private String splitType;

    /**
     * 执行主体Id
     */
    @TableField(value = "executive_agent_id")
    private Long executiveAgentId;

    /**
     * 执行主体名称
     */
    @TableField(value = "executive_agent_name")
    private String executiveAgentName;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**** 冗余字段  ****/
    /**
     * 项目是否需要拆分
     */
    @TableField(value = "project_split")
    private Boolean projectSplit;

    public String getSplitType() {
        return splitType;
    }

    public void setSplitType(String splitType) {
        this.splitType = splitType;
    }

    public Long getExecutiveAgentId() {
        return executiveAgentId;
    }

    public void setExecutiveAgentId(Long executiveAgentId) {
        this.executiveAgentId = executiveAgentId;
    }

    public String getExecutiveAgentName() {
        return executiveAgentName;
    }

    public void setExecutiveAgentName(String executiveAgentName) {
        this.executiveAgentName = executiveAgentName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Boolean getProjectSplit() {
        return projectSplit;
    }

    public void setProjectSplit(Boolean projectSplit) {
        this.projectSplit = projectSplit;
    }

    public Long getProjectApplyId() {
        return projectApplyId;
    }

    public void setProjectApplyId(Long projectApplyId) {
        this.projectApplyId = projectApplyId;
    }
}
