package com.ejianc.business.projectapply.service;

import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 项目申请服务
 *
 * @author CJ
 * @Description:
 * @date 2021/9/6 9:58
 */
public interface IProjectApplyService extends IBaseService<ProjectApplyEntity> {
    /**
     * 查询匹配数据总数
     *
     * @param searchText
     * @param billState
     * @param createTime
     * @param projectSplit
     * @param orgIds
     * @return
     */
    long countPage(String searchText, String billState, String createTime, String projectSplit, List<Long> orgIds,
			String status);

    /**
     * 分页查询匹配的项目列表
     *
     * @param searchText
     * @param billState
     * @param createTime
     * @param projectSplit
     * @param orgIds
     * @param startLine
     * @param pageSize
     * @param orderBy: 示例：createTime desc bill_code asc
     * @return
     */
    List<ProjectApplyVO> pageList(String searchText, String billState, String createTime, String projectSplit, List<Long> orgIds, long startLine, long pageSize, String orderBy,
			String status);


    /**
     * 查询匹配的项目列表
     *
     * @param vo
     * @return
     */
    List<ProjectApplyEntity> getDuplicateList(ProjectApplyVO vo);

    /**
     * 查询匹配数据总数
     *
     * @param searchText
     * @param params
     * @return
     */
    long dynamicCountPage(String searchText, Map<String, Parameter> params);

    /**
     * 动态参数分页查询
     *
     * @param searchText
     * @param newP
     * @param startLine
     * @param pageSize
     * @param orderBy
     * @return
     */
    List<ProjectApplyVO> dynamicPageList(String searchText, Map<String, Parameter> newP, long startLine, long pageSize, String orderBy);
}
