package com.ejianc.business.projectapply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.mapper.ProjectApplyMapper;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


/**
 * 项目申请服务实现
 *
 * @author CJ
 * @Description: 项目申请服务实现
 * @date 2021/9/6 9:59
 */
@Service(value = "projectApplyService")
public class ProjectApplyServiceImpl extends BaseServiceImpl<ProjectApplyMapper, ProjectApplyEntity> implements IProjectApplyService {

    @Autowired
    private ProjectApplyMapper projectApplyMapper;

    @Override
    public long countPage(String searchText, String billState, String createTime, String projectSplit, List<Long> orgIds, String status) {
        return projectApplyMapper.countPage(searchText, billState, createTime, projectSplit, orgIds, status);
    }

    @Override
    public List<ProjectApplyVO> pageList(String searchText, String billState, String createTime, String projectSplit,
                                         List<Long> orgIds, long startLine, long pageSize, String orderBy, String status) {
        return projectApplyMapper.pageList(searchText, billState, createTime, projectSplit, orgIds, startLine, pageSize, orderBy, status);
    }

    @Override
    public List<ProjectApplyEntity> getDuplicateList(ProjectApplyVO vo) {
        //中文名称/英文名重复校验
        QueryWrapper<ProjectApplyEntity> query = new QueryWrapper();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(vo.getCnName())) {
            query.eq("cn_name", vo.getCnName());
        }
        if(null != vo.getId()) {
            query.ne("id", vo.getId());
        }
        if(StringUtils.isNotBlank(vo.getEnName())) {
            query.eq("en_name", vo.getEnName());
        }

        return projectApplyMapper.selectList(query);
    }

    @Override
    public long dynamicCountPage(String searchText, Map<String, Parameter> params) {
        return projectApplyMapper.dynamicCountPage(searchText, params);
    }

    @Override
    public List<ProjectApplyVO> dynamicPageList(String searchText, Map<String, Parameter> newP, long startLine, long pageSize, String orderBy) {
        return projectApplyMapper.dynamicPageList(searchText, newP, startLine, pageSize, orderBy);
    }

}
