package com.ejianc.business.projectapply.vo;

import java.math.BigDecimal;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 项目申请-执行主体
 *
 * @author CJ
 * @Description:
 * @date 2021/9/6 9:52
 */
public class ExecutiveAgentVO extends BaseVO {
    private static final long serialVersionUID = -425288490056913614L;

    /**
     * 项目申请主表Id
     */
    private Long projectApplyId;

    /**
     * 拆分类型：E、P、C、O，
     * 仅当拆分项目时有值，非拆分项目该字段无效
     */
    private String splitType;

    /**
     * 执行主体Id
     */
    private Long executiveAgentId;

    /**
     * 执行主体名称
     */
    private String executiveAgentName;

    /**
     * 备注
     */
    private String remark;

    /**** 冗余字段  ****/
    /**
     * 项目是否需要拆分
     */
    private Boolean projectSplit;
    
    /*******合同字段（后续查询使用）start***************/

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同金额
     */
    private BigDecimal contractAmount;

    /**
     * 折算人民币
     */
    private BigDecimal contractAmountRMB;

    /**
     * 合同执行地
     */
    private String contractExecutionPlace;

    /**
     * 合同范围
     */
    private String contractRange;

    /*******合同字段（后续查询使用）end***************/

    public String getSplitType() {
        return splitType;
    }

    public void setSplitType(String splitType) {
        this.splitType = splitType;
    }

    public Long getExecutiveAgentId() {
        return executiveAgentId;
    }

    @ReferDeserialTransfer
    public void setExecutiveAgentId(Long executiveAgentId) {
        this.executiveAgentId = executiveAgentId;
    }

    public String getExecutiveAgentName() {
        return executiveAgentName;
    }

    public void setExecutiveAgentName(String executiveAgentName) {
        this.executiveAgentName = executiveAgentName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Boolean getProjectSplit() {
        return projectSplit;
    }

    public void setProjectSplit(Boolean projectSplit) {
        this.projectSplit = projectSplit;
    }

    public Long getProjectApplyId() {
        return projectApplyId;
    }

    public void setProjectApplyId(Long projectApplyId) {
        this.projectApplyId = projectApplyId;
    }

	public String getContractName() {
		return contractName;
	}

	public void setContractName(String contractName) {
		this.contractName = contractName;
	}

	public BigDecimal getContractAmount() {
		return contractAmount;
	}

	public void setContractAmount(BigDecimal contractAmount) {
		this.contractAmount = contractAmount;
	}

	public BigDecimal getContractAmountRMB() {
		return contractAmountRMB;
	}

	public void setContractAmountRMB(BigDecimal contractAmountRMB) {
		this.contractAmountRMB = contractAmountRMB;
	}

	public String getContractExecutionPlace() {
		return contractExecutionPlace;
	}

	public void setContractExecutionPlace(String contractExecutionPlace) {
		this.contractExecutionPlace = contractExecutionPlace;
	}

	public String getContractRange() {
		return contractRange;
	}

	public void setContractRange(String contractRange) {
		this.contractRange = contractRange;
	}
    
}
