package com.ejianc.business.projectapply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.projectapply.bean.ExecutiveAgentEntity;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.bean.ProjectChangeEntity;
import com.ejianc.business.projectapply.mapper.ProjectChangeMapper;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.service.IProjectChangeService;
import com.ejianc.business.projectapply.vo.ExecutiveAgentVO;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.business.projectapply.vo.ProjectChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 项目变更
 *
 * @author liyj
 * @Description: 项目变更
 * @date 2021/9/8 10:01
 */
@Service(value = "projectChangeService")
public class ProjectChangeServiceImpl extends BaseServiceImpl<ProjectChangeMapper, ProjectChangeEntity> implements IProjectChangeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ProjectChangeMapper projectChangeMapper;

    @Autowired
    private IOrgApi orgApi;

    @Value("${oms.splitPrjBelongOrgName}")
    private String splitPrjBelongOrgName;

    @Value("${oms.splitPrjBelongOrgType}")
    private Integer splitPrjBelongOrgType;

    @Override
    public List<ProjectChangeEntity> getAllByProjectId(Long projectId) {
        QueryWrapper<ProjectChangeEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("project_id", projectId);

        return projectChangeMapper.selectList(query);
    }

    @Autowired
    private IProjectApplyService projectApplyService;
	@Autowired
	private SessionManager sessionManager;

    @Autowired
    private IProjectChangeService projectChangeService;

	@Override
	public CommonResponse<ProjectApplyVO> saveChange(ProjectApplyVO vo) {

        ProjectApplyVO checkVo = new ProjectApplyVO();
        checkVo.setId(vo.getId());
        checkVo.setCnName(vo.getCnName());
        List<ProjectApplyEntity> checklist = projectApplyService.getDuplicateList(checkVo);
        if(CollectionUtils.isNotEmpty(checklist)) {
            return CommonResponse.error("保存失败，项目中文名称已被使用.");
        }
        if(StringUtils.isNotBlank(vo.getEnName())) {
            checkVo.setCnName(null);
            checkVo.setEnName(vo.getEnName());
            checklist = projectApplyService.getDuplicateList(checkVo);
            if(CollectionUtils.isNotEmpty(checklist)) {
                return CommonResponse.error("保存失败, 项目英文名称已被使用.");
            }
        }
		//校验执行主题
        Set<String> repeatCheck = new HashSet<>();
        if(CollectionUtils.isNotEmpty(vo.getExecutiveAgentList())) {
            //重新将所有执行主体名称汇总
            StringBuilder executiveAgentNames = new StringBuilder();
            String repeatCheckStr = null;
            for(ExecutiveAgentVO e : vo.getExecutiveAgentList()) {
                if(!"del".equals(e.getRowState())) {
                    executiveAgentNames.append(e.getExecutiveAgentName()).append(",");
                    e.setProjectSplit(vo.getProjectSplit());
                    repeatCheckStr = getRepeatCheckStr(e.getSplitType(), e.getExecutiveAgentId());
                    if(e.getProjectSplit() && repeatCheck.contains(repeatCheckStr)) {
                        return CommonResponse.error("保存失败，执行主体："+e.getExecutiveAgentName()+"["+e.getSplitType()+"]"+"重复！");
                    } else {
                        repeatCheck.add(repeatCheckStr);
                    }
                }
            }

            vo.setExecutiveAgentNames(executiveAgentNames.substring(0, executiveAgentNames.length()-1));
        }
        if(StringUtils.isBlank(vo.getExecutiveAgentNames())) {
            return CommonResponse.error("保存失败，执行主体不能为空！");
        }

		//1、查询之前的项目信息；
        ProjectApplyEntity oldEntity = projectApplyService.selectById(vo.getId());
    	//2、判断两次的数据是否一致，不一致则添加到变更内容中
    	//主表
        String changeContent = "";
        boolean nameChange = false;
        String oldCnName = oldEntity.getCnName();
        String oldEnName = oldEntity.getEnName();
        
        //判断是否变更项目部信息。
        boolean changeOrg = false;	//变更项目部标志
        
        //是否需要拆分、项目名称(中文)、项目名称(英文)、项目类型、计划开工/竣工日期
        if(!vo.getCnName().equals(oldEntity.getCnName())){
        	//项目名称(中文)
        	changeContent += ("[项目名称(中文)]：由"+'"'+(StringUtils.isNotBlank(oldEntity.getCnName())?oldEntity.getCnName():"")
        			+'"'+"改为"+'"'+(StringUtils.isNotBlank(vo.getCnName())?vo.getCnName():"")+'"');
        	nameChange = true;
        	changeOrg = true;
        	oldEntity.setCnName(vo.getCnName());
        }
        if((StringUtils.isBlank(vo.getEnName())&&StringUtils.isNotBlank(oldEntity.getEnName())) ||
        		(StringUtils.isBlank(oldEntity.getEnName())&&StringUtils.isNotBlank(vo.getEnName())) ||
        		(StringUtils.isNotBlank(oldEntity.getEnName())&&StringUtils.isNotBlank(vo.getEnName())&&(!vo.getEnName().equals(oldEntity.getEnName())))){
        	//项目名称(英文)
        	if(changeContent.length()>0){
        		changeContent += (",[项目名称(英文)]：由"+'"'+(StringUtils.isNotBlank(oldEntity.getEnName())?oldEntity.getEnName():"")
            			+'"'+"改为"+'"'+(StringUtils.isNotBlank(vo.getEnName())?vo.getEnName():"")+'"');
        	}else{
        		changeContent += ("[项目名称(英文)]：由"+'"'+(StringUtils.isNotBlank(oldEntity.getEnName())?oldEntity.getEnName():"")
            			+'"'+"改为"+'"'+(StringUtils.isNotBlank(vo.getEnName())?vo.getEnName():"")+'"');
        	}
        	
        	nameChange = true;
        	oldEntity.setEnName(vo.getEnName());
        }
        if(nameChange){
        	if(StringUtils.isNotBlank(oldEntity.getUsedNames())){
        		oldEntity.setUsedNames(oldEntity.getUsedNames()+","+oldCnName+(StringUtils.isNotBlank(oldEnName)?("("+oldEnName+")"):""));
        	}else{
        		oldEntity.setUsedNames(oldCnName+(StringUtils.isNotBlank(oldEnName)?("("+oldEnName+")"):""));
        	}
        }
        if(!vo.getProjectType().equals(oldEntity.getProjectType())){
        	if(changeContent.length()>0){
        		changeContent += (","+"[项目类型]：由"+'"'+oldEntity.getProjectTypeName()+'"'+"改为"+'"'+vo.getProjectTypeName()+'"');
        	}else{
        		changeContent += ("[项目类型]：由"+'"'+oldEntity.getProjectTypeName()+'"'+"改为"+'"'+vo.getProjectTypeName()+'"');
        	}
        	//项目类型
        	oldEntity.setProjectType(vo.getProjectType());
        	oldEntity.setProjectTypeName(vo.getProjectTypeName());
        }
        if(!vo.getProjectClassification().equals(oldEntity.getProjectClassification())){
        	if(changeContent.length()>0){
        		changeContent += (","+"[国内/国外项目]：由"+'"'+oldEntity.getProjectClassification()+'"'+"改为"+'"'+vo.getProjectClassification()+'"');
        	}else{
        		changeContent += ("[国内/国外项目]：由"+'"'+oldEntity.getProjectClassification()+'"'+"改为"+'"'+vo.getProjectClassification()+'"');
        	}
        	//项目分类：国内-国内项目，国外-国外项目
        	oldEntity.setProjectClassification(vo.getProjectClassification());
        }

        if((StringUtils.isBlank(vo.getRemark())&&StringUtils.isNotBlank(oldEntity.getRemark())) ||
        		(StringUtils.isBlank(oldEntity.getRemark())&&StringUtils.isNotBlank(vo.getRemark())) ||
        		(StringUtils.isNotBlank(oldEntity.getRemark())&&StringUtils.isNotBlank(vo.getRemark())&&(!vo.getRemark().equals(oldEntity.getRemark())))){
        	//备注
        	if(changeContent.length()>0){
        		changeContent += (",[备注]：由"+'"'+(StringUtils.isNotBlank(oldEntity.getRemark())?oldEntity.getRemark():"")
            			+'"'+"改为"+'"'+(StringUtils.isNotBlank(vo.getRemark())?vo.getRemark():"")+'"');
        	}else{
        		changeContent += ("[备注]：由"+'"'+(StringUtils.isNotBlank(oldEntity.getRemark())?oldEntity.getRemark():"")
            			+'"'+"改为"+'"'+(StringUtils.isNotBlank(vo.getRemark())?vo.getRemark():"")+'"');
        	}
        	
        	nameChange = true;
        	oldEntity.setRemark(vo.getRemark());
        }

        if(!vo.getProjectStartDate().equals(oldEntity.getProjectStartDate())){
        	//判断开工日期是否改变
        	SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        	String oldStart = formatter.format(oldEntity.getProjectStartDate());
        	String oldFinish = formatter.format(oldEntity.getProjectFinishDate());
        	String old = (oldStart + " - " + oldFinish);
        	String newStart = formatter.format(vo.getProjectStartDate());
        	String newFinish = formatter.format(vo.getProjectFinishDate());
        	String newd = (newStart + " - " + newFinish);
        	if(changeContent.length()>0){
        		changeContent += (","+"[计划开工/竣工日期]：由"+'"'+old+'"'+"改为"+'"'+newd+'"');
        	}else{
        		changeContent += ("[计划开工/竣工日期]：由"+'"'+old+'"'+"改为"+'"'+newd+'"');
        	}
        	oldEntity.setProjectStartDate(vo.getProjectStartDate());
        }else{
        	//判断竣工日期是否改变
        	if(!vo.getProjectFinishDate().equals(oldEntity.getProjectFinishDate())){
            	//判断开工日期是否改变
            	SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            	String oldStart = formatter.format(oldEntity.getProjectStartDate());
            	String oldFinish = formatter.format(oldEntity.getProjectFinishDate());
            	String old = (oldStart + " - " + oldFinish);
            	String newStart = formatter.format(vo.getProjectStartDate());
            	String newFinish = formatter.format(vo.getProjectFinishDate());
            	String newd = (newStart + " - " + newFinish);
            	if(changeContent.length()>0){
            		changeContent += (","+"[计划开工/竣工日期]：由"+'"'+old+'"'+"改为"+'"'+newd+'"');
            	}else{
            		changeContent += ("[计划开工/竣工日期]：由"+'"'+old+'"'+"改为"+'"'+newd+'"');
            	}
            	oldEntity.setProjectFinishDate(vo.getProjectFinishDate());
            }
        }
        if(!vo.getProjectSplit().equals(oldEntity.getProjectSplit())){
            //判断拆分类型是否改变，若改变则组织的上级节点一定改变
        	changeOrg = true;
        	dealOrg(vo,oldEntity);
        }else if(!vo.getProjectSplit()){
        	//拆分类型为否时，判断执行主体是否改变，若改变则项目部信息需要改变；
        	//取最新的执行主体
        	Long newOrgId = null;
            for(ExecutiveAgentVO e : vo.getExecutiveAgentList()){
            	if(!"del".equals(e.getRowState())){
            		newOrgId = e.getExecutiveAgentId();
            		break;
            	}
            }
            if(!oldEntity.getExecutiveAgentList().get(0).getExecutiveAgentId().equals(newOrgId)){
            	changeOrg = true;
            	dealOrg(vo,oldEntity);
            }
        	//当拆分类型为是时，变化拆分主体不影响项目部的层级结构
        }
        oldEntity.setProjectSplit(vo.getProjectSplit());
    	//子表--执行主体
        List<ExecutiveAgentVO> executiveAgentList = vo.getExecutiveAgentList();
        if(executiveAgentList!=null&&executiveAgentList.size()>0){
        	String content = "";
        	String oldContent = "";
        	boolean change = false;
        	Map<Long,ExecutiveAgentEntity> oldExecutiveMap = new HashMap<>();
        	if(oldEntity.getExecutiveAgentList()!=null&&oldEntity.getExecutiveAgentList().size()>0){
        		for(ExecutiveAgentEntity executiveAgentEntity : oldEntity.getExecutiveAgentList()){
        			oldExecutiveMap.put(executiveAgentEntity.getId(), executiveAgentEntity);
        			if(oldContent.length()>0){
        				oldContent += (","+(StringUtils.isNotBlank(executiveAgentEntity.getSplitType())?(executiveAgentEntity.getSplitType()+"-"):"")+executiveAgentEntity.getExecutiveAgentName());
            		}else{
            			oldContent += ((StringUtils.isNotBlank(executiveAgentEntity.getSplitType())?(executiveAgentEntity.getSplitType()+"-"):"")+executiveAgentEntity.getExecutiveAgentName());
            		}
        		}
        	}
        	for(ExecutiveAgentVO executiveAgentVO : executiveAgentList){
            	if("add".equals(executiveAgentVO.getRowState())){
            		change = true;
            		if(content.length()>0){
            			content += (","+(StringUtils.isNotBlank(executiveAgentVO.getSplitType())?(executiveAgentVO.getSplitType()+"-"):"")+executiveAgentVO.getExecutiveAgentName());
            		}else{
            			content += ((StringUtils.isNotBlank(executiveAgentVO.getSplitType())?(executiveAgentVO.getSplitType()+"-"):"")+executiveAgentVO.getExecutiveAgentName());
            		}
            	}else if("del".equals(executiveAgentVO.getRowState())){
            		change = true;
            	}else if("edit".equals(executiveAgentVO.getRowState())){
            		ExecutiveAgentEntity entity = oldExecutiveMap.get(executiveAgentVO.getId());
                    if(!entity.getSplitType().equals(executiveAgentVO.getSplitType())){
                    	change = true;
                    }
                    if(!entity.getExecutiveAgentId().equals(executiveAgentVO.getExecutiveAgentId())){
                    	change = true;
                    }
                    if(!entity.getRemark().equals(executiveAgentVO.getRemark())){
                    	change = true;
                    }
            		if(content.length()>0){
            			content += (","+(StringUtils.isNotBlank(executiveAgentVO.getSplitType())?(executiveAgentVO.getSplitType()+"-"):"")+executiveAgentVO.getExecutiveAgentName());
            		}else{
            			content += ((StringUtils.isNotBlank(executiveAgentVO.getSplitType())?(executiveAgentVO.getSplitType()+"-"):"")+executiveAgentVO.getExecutiveAgentName());
            		}
            	}else{
            		if(content.length()>0){
            			content += (","+(StringUtils.isNotBlank(executiveAgentVO.getSplitType())?(executiveAgentVO.getSplitType()+"-"):"")+executiveAgentVO.getExecutiveAgentName());
            		}else{
            			content += ((StringUtils.isNotBlank(executiveAgentVO.getSplitType())?(executiveAgentVO.getSplitType()+"-"):"")+executiveAgentVO.getExecutiveAgentName());
            		}
            	}
            }
        	if(change){
        		if(changeContent.length()>0){
            		changeContent += (","+"[执行主体]：由"+'"'+oldContent+'"'+"改为"+'"'+content+'"');
            	}else{
            		changeContent += ("[执行主体]：由"+'"'+oldContent+'"'+"改为"+'"'+content+'"');
            	}
        	}
        	List<ExecutiveAgentEntity> list = BeanMapper.mapList(executiveAgentList, ExecutiveAgentEntity.class);
        	oldEntity.setExecutiveAgentList(list);
        	oldEntity.setExecutiveAgentNames(vo.getExecutiveAgentNames());
        }

        //同步保存项目信息
        if(changeOrg){
        	 CommonResponse<OrgVO> oldOrgData = orgApi.detailById(oldEntity.getProjectDepartmentId());
             if(oldOrgData.isSuccess()&&oldOrgData.getData()!=null){
             	OrgVO orgVO = oldOrgData.getData();
             	orgVO.setName(oldEntity.getCnName());
             	orgVO.setParentId(oldEntity.getOrgId());
     			orgApi.saveOrgInfo(orgVO );
             }else{
             	logger.info("同步项目部信息失败，未获取到项目部信息---->"+oldOrgData.getMsg());
             	throw new BusinessException("同步项目部信息失败，未获取到项目部信息");
             }
        }
        projectApplyService.saveOrUpdate(oldEntity, false);
        
        ProjectChangeEntity projectChange = new ProjectChangeEntity();
        projectChange.setChangeUserName(sessionManager.getUserContext().getUserName());
        projectChange.setChangeContent(changeContent);
        projectChange.setProjectId(oldEntity.getId());
    	//保存变更记录
        this.saveOrUpdate(projectChange, false);
        ProjectApplyVO back = BeanMapper.map(oldEntity, ProjectApplyVO.class);

    	QueryWrapper<ProjectChangeEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("dr", 0);
    	queryWrapper.eq("project_id", oldEntity.getId());
		List<ProjectChangeEntity> list = projectChangeService.list(queryWrapper);
		List<ProjectChangeVO> backList = new ArrayList<>();
		if(list!=null&&list.size()>0){
			backList = BeanMapper.mapList(list, ProjectChangeVO.class);
		}
        back.setProjectChangeList(backList);
        return CommonResponse.success("保存成功！", back);
	}

    private String getRepeatCheckStr(String splitType, Long executiveAgentId) {
        if(StringUtils.isBlank(splitType)) {
            return executiveAgentId.toString();
        } else if(splitType.indexOf(",") < 0) {
            return splitType + executiveAgentId;
        } else {
            String[] typeArr = splitType.split(",");
            Arrays.sort(typeArr, String.CASE_INSENSITIVE_ORDER);
            return StringUtils.join(typeArr, ",") + executiveAgentId;
        }
    }

    private void dealOrg(ProjectApplyVO vo, ProjectApplyEntity oldEntity) {
        OrgVO parent = null;
        //设置项目部所属组织Id：拆分项目，上级组织固定为组织类型为"集团"的山东电力建设第三工程有限公司
        //非拆分项目，生成的项目部，上级组织为"执行主体"
        if(vo.getProjectSplit()) {
            //设置上级组织
            OrgVO query = new OrgVO();
            query.setName(splitPrjBelongOrgName);
            query.setTenantId(InvocationInfoProxy.getTenantid());
            query.setOrgType(splitPrjBelongOrgType);
            CommonResponse<OrgVO> parentOrgInfoResp = orgApi.findOneByOrgVO(query);

            if(!parentOrgInfoResp.isSuccess()) {
            	throw new BusinessException("拆分项目查询指定上级: 名称-" + splitPrjBelongOrgName + "，类型-" +splitPrjBelongOrgType + "的组织失败！");
            }
            parent = parentOrgInfoResp.getData();
        } else {
            //上级组织为执行主体
            ExecutiveAgentVO sub = new ExecutiveAgentVO();
            for(ExecutiveAgentVO e : vo.getExecutiveAgentList()){
            	if(!"del".equals(e.getRowState())){
            		sub = e;
            		break;
            	}
            }
            CommonResponse<OrgVO> parentOrgInfoResp = orgApi.detailById(sub.getExecutiveAgentId());
            if(!parentOrgInfoResp.isSuccess()) {
            	throw new BusinessException("非拆分项目查询指定上级: 名称-" + sub.getExecutiveAgentName() + "的组织失败！");
            }

            parent = parentOrgInfoResp.getData();
        }
        if(null == parent) {
            throw new BusinessException("项目上级组织在系统中不存在！");
        }

        //保存项目部信息以及所属组织信息
        oldEntity.setOrgName(parent.getName());
        oldEntity.setOrgId(parent.getId());
    }
}
