package com.ejianc.business.projectapply.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;

/**
 * 项目申请实体
 *
 * @author CJ
 * @Description: 项目申请实体
 * @date 2021/9/4 17:14
 */
@TableName(value = "ejc_sdsjproject_prj_apply")
public class ProjectApplyEntity extends BaseEntity {
    private static final long serialVersionUID = -8584906635590363078L;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 项目状态：0-未开工，1-在建，2-停工，3-已完工
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 项目编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 项目是否需要拆分
     */
    @TableField(value = "project_split")
    private Boolean projectSplit;

    /**
     * 项目所在国家地区
     */
    @TableField(value = "belong_area")
    private Long belongArea;

    /**
     * 项目所在国家地区名称
     */
    @TableField(value = "belong_area_name")
    private String belongAreaName;

    /**
     * 项目分类：国内-国内项目，国外-国外项目
     */
    @TableField(value = "project_classification")
    private String projectClassification;

    /**
     * 项目中文名称
     */
    @TableField(value = "cn_name")
    private String cnName;

    /**
     * 项目英文名称，当项目为国外项目时，该项必填
     */
    @TableField(value = "en_name")
    private String enName;

    /**
     * 项目类型Id
     */
    @TableField(value = "project_type")
    private Long projectType;

    /**
     * 项目类型名称
     */
    @TableField(value = "project_type_name")
    private String projectTypeName;

    /**
     * 项目业主Id
     */
    @TableField(value = "business_entrepreneur")
    private Long businessEntrepreneur;

    /**
     * 项目业主名称
     */
    @TableField(value = "business_entrepreneur_name")
    private String businessEntrepreneurName;

    /**
     * 计划开工
     */
    @TableField(value = "project_start_date")
    private Date projectStartDate;

    /**
     * 竣工日期
     */
    @TableField(value = "project_finish_date")
    private Date projectFinishDate;

    /**
     * 计划工期（天）
     */
    @TableField(value = "plan_days_limit")
    private Integer planDaysLimit;

    /**
     * 项目曾用名
     */
    @TableField(value = "used_names")
    private String usedNames;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 执行主体子表
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "executiveAgentService", pidName = "projectApplyId")
    List<ExecutiveAgentEntity> executiveAgentList;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "commit_date")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField(value = "commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField(value = "commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "effective_date")
    private Date effectiveDate;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 执行主体名称，多个逗号分隔
     */
    @TableField(value = "executive_agent_names")
    private String executiveAgentNames;

    /**
     * 申请人Id
     */
    @TableField(value = "apply_user_id")
    private Long applyUserId;
    /**
     * 申请人名称
     */
    @TableField(value = "apply_user_name")
    private String applyUserName;

    /**
     * 申请部门Id
     */
    @TableField(value = "apply_dept_id")
    private Long applyDeptId;
    /**
     * 申请部门名称
     */
    @TableField(value = "apply_dept_name")
    private String applyDeptName;

    /**
     * 所属项目部Id
     */
    @TableField(value = "project_department_id")
    private Long projectDepartmentId;

    /**
     * 项目部所属组织Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 项目部所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getApplyDeptId() {
        return applyDeptId;
    }

    public void setApplyDeptId(Long applyDeptId) {
        this.applyDeptId = applyDeptId;
    }

    public String getApplyDeptName() {
        return applyDeptName;
    }

    public void setApplyDeptName(String applyDeptName) {
        this.applyDeptName = applyDeptName;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getExecutiveAgentNames() {
        return executiveAgentNames;
    }

    public void setExecutiveAgentNames(String executiveAgentNames) {
        this.executiveAgentNames = executiveAgentNames;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Boolean getProjectSplit() {
        return projectSplit;
    }

    public void setProjectSplit(Boolean projectSplit) {
        this.projectSplit = projectSplit;
    }

    public Long getBelongArea() {
        return belongArea;
    }

    public void setBelongArea(Long belongArea) {
        this.belongArea = belongArea;
    }

    public String getBelongAreaName() {
        return belongAreaName;
    }

    public void setBelongAreaName(String belongAreaName) {
        this.belongAreaName = belongAreaName;
    }

    public String getProjectClassification() {
        return projectClassification;
    }

    public void setProjectClassification(String projectClassification) {
        this.projectClassification = projectClassification;
    }

    public String getCnName() {
        return cnName;
    }

    public void setCnName(String cnName) {
        this.cnName = cnName;
    }

    public String getEnName() {
        return enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public Long getProjectType() {
        return projectType;
    }

    public void setProjectType(Long projectType) {
        this.projectType = projectType;
    }

    public Long getBusinessEntrepreneur() {
        return businessEntrepreneur;
    }

    public void setBusinessEntrepreneur(Long businessEntrepreneur) {
        this.businessEntrepreneur = businessEntrepreneur;
    }

    public String getBusinessEntrepreneurName() {
        return businessEntrepreneurName;
    }

    public void setBusinessEntrepreneurName(String businessEntrepreneurName) {
        this.businessEntrepreneurName = businessEntrepreneurName;
    }

    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getProjectFinishDate() {
        return projectFinishDate;
    }

    public void setProjectFinishDate(Date projectFinishDate) {
        this.projectFinishDate = projectFinishDate;
    }

    public Integer getPlanDaysLimit() {
        return planDaysLimit;
    }

    public void setPlanDaysLimit(Integer planDaysLimit) {
        this.planDaysLimit = planDaysLimit;
    }

    public String getUsedNames() {
        return usedNames;
    }

    public void setUsedNames(String usedNames) {
        this.usedNames = usedNames;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<ExecutiveAgentEntity> getExecutiveAgentList() {
        return executiveAgentList;
    }

    public void setExecutiveAgentList(List<ExecutiveAgentEntity> executiveAgentList) {
        this.executiveAgentList = executiveAgentList;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
}
