package com.ejianc.business.projectapply.mapper;

import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/9/6 9:57
 */
@Mapper
public interface ProjectApplyMapper extends BaseCrudMapper<ProjectApplyEntity> {
    /**
     * 查询匹配的数据总数
     *
     * @param searchText
     * @param billState
     * @param createTime
     * @param projectSplit
     * @param orgIds
     * @return
     */
    long countPage(@Param(value = "searchText") String searchText, @Param(value = "billState")  String billState,
                   @Param(value = "createTime")  String createTime, @Param(value = "projectSplit")  String projectSplit,
                   @Param(value = "orgIds")  List<Long> orgIds, @Param(value = "status") String status);

    /**
     * 分页查询匹配的项目列表
     *
     * @param searchText
     * @param billState
     * @param createTime
     * @param projectSplit
     * @param orgIds
     * @param startLine
     * @param pageSize
     * @return
     */
    List<ProjectApplyVO> pageList(@Param(value = "searchText") String searchText, @Param(value = "billState")  String billState,
                                  @Param(value = "createTime")  String createTime, @Param(value = "projectSplit")  String projectSplit,
                                  @Param(value = "orgIds")  List<Long> orgIds, @Param(value = "startLine") long startLine,
                                  @Param(value = "pageSize") long pageSize, @Param(value = "createTimeOrderType") String createTimeOrderType,
                                  @Param(value = "status") String status);
}
