package com.ejianc.business.sealm.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.YzxhEntity;
import com.ejianc.business.sealm.bean.ZzryjEntity;
import com.ejianc.business.sealm.consts.SealmYzztConsts;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.service.IYzxhService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("yzxh") 
public class YzxhBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IYzxhService service;

	@Autowired
	private IYzdjService yzdjService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		//责任人变更审批通过后修改印章登记里的当前保管人
		YzxhEntity yzxhEntity =service.getById(billId);
		//根据印章编号将印章登记中状态改为已销毁
		LambdaUpdateWrapper<YzdjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzdjEntity::getZt, SealmYzztConsts.YXH);
		updateWrapper.eq(YzdjEntity::getBillCode, yzxhEntity.getYzbhCode());
		yzdjService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//流程撤回时将印章登记里的状态改为总部在库
		YzxhEntity yzxhEntity =service.getById(billId);
		//根据印章编号将印章登记中状态改为总部在库
		LambdaUpdateWrapper<YzdjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzdjEntity::getZt, SealmYzztConsts.ZBZK);
		updateWrapper.eq(YzdjEntity::getBillCode, yzxhEntity.getYzbhCode());
		yzdjService.update(updateWrapper);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//责任人变更审批通过后修改印章登记里的当前保管人
		YzxhEntity yzxhEntity =service.getById(billId);
		//根据印章编号将印章登记中状态改为已销毁
		LambdaUpdateWrapper<YzdjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzdjEntity::getZt, SealmYzztConsts.YXH);
		updateWrapper.eq(YzdjEntity::getBillCode, yzxhEntity.getYzbhCode());
		yzdjService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//流程撤回时将印章登记里的状态改为总部在库
		YzxhEntity yzxhEntity =service.getById(billId);
		//根据印章编号将印章登记中状态改为总部在库
		LambdaUpdateWrapper<YzdjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzdjEntity::getZt, SealmYzztConsts.ZBZK);
		updateWrapper.eq(YzdjEntity::getBillCode, yzxhEntity.getYzbhCode());
		yzdjService.update(updateWrapper);
		return CommonResponse.success();
	}

}
