package com.ejianc.business.sealm.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.consts.SealmYzztConsts;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.utils.AESUtil;
import com.ejianc.business.sealm.utils.YZMUtil;
import com.ejianc.business.sealm.vo.QjykyVO;
import com.ejianc.business.sealm.vo.YzsqSealOrderVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("zcyysq") 
public class ZcyysqBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IZcyysqService service;


	private static final String PREFIX_URL = "https://zzyj.ca.qunje.com:8008/stampInterface/";
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		//调用群杰接口，发送短信码
		ZcyysqEntity zcyysqEntity = service.selectById(billId);
		YzsqSealOrderVo yzsqSealOrderVo = new YzsqSealOrderVo();
		if (zcyysqEntity != null && "1472850976309252098".equals(zcyysqEntity.getYzlbId().toString())) {  //判断是印控仪才走下面的代码
			// 请求url
			String createUrl = PREFIX_URL + "order/addYZSQAndSealOrder";
			String caseId =	zcyysqEntity.getBillCode() + zcyysqEntity.getId();  //当前办理事项ID,默认是申请表code+id形式
			String vertifyCode = YZMUtil.GenerateSafeCode();  //生成六位随机验证码
			yzsqSealOrderVo.setWorkflowName("t_seal_zcyysq");  //表名
			yzsqSealOrderVo.setCaseId(caseId);
			yzsqSealOrderVo.setTitle("支出合同用印申请调永群杰验证码");
			yzsqSealOrderVo.setFingerNo(zcyysqEntity.getCreateUserCode());  //授权人账号
			yzsqSealOrderVo.setSealUserName(zcyysqEntity.getCreateUserName());  //实际用印人姓名
			yzsqSealOrderVo.setFormNo(zcyysqEntity.getBillCode());  //流程单号
			yzsqSealOrderVo.setVertifyCode(vertifyCode);
			yzsqSealOrderVo.setApplicantName(zcyysqEntity.getJbrName());  //申请人姓名
			yzsqSealOrderVo.setDepName(zcyysqEntity.getOrgName());  //组织
			yzsqSealOrderVo.setDescription(zcyysqEntity.getYyReason());  //用印事由
			yzsqSealOrderVo.setPhoneNumber(zcyysqEntity.getJbrTel());  //经办人手机号
			yzsqSealOrderVo.setIsTakeOut(zcyysqEntity.getSfWdgz().toString());  //是否外带公章,1是，0否
			//子表信息封装
			List<QjykyVO> qjykyVOList = new ArrayList<QjykyVO>();
			QjykyVO qjykyVO = new QjykyVO();
			qjykyVO.setSessionId(zcyysqEntity.getId().toString());  //授权明细ID
			qjykyVO.setCaseId(caseId);
			qjykyVO.setSealNo("2019062419336378");  //设备编码
			qjykyVO.setSealCount(zcyysqEntity.getYycs().toString());  //申请次数
			qjykyVOList.add(qjykyVO);

			yzsqSealOrderVo.setDetail(qjykyVOList);  //

			// 转换为json字符串
			String jsonString = JSONObject.toJSONString(yzsqSealOrderVo);
			// 加密
			String resultStr = AESUtil.encrypt(jsonString, AESUtil.key);
			// 发送请求
			String json = HttpUtil.post(createUrl, resultStr);

			JSONObject jsonObject =JSONObject.parseObject(json);
			String code = jsonObject.getString("errCode");
			//判断是否调用成功，不成功就终结掉操作
			if ("200".equals(code)) {
				zcyysqEntity.setYzm(vertifyCode);  //验证码发送成功后，将验证码同步到本地库
				service.updateById(zcyysqEntity);
			}

		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
