package com.ejianc.business.sealm.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.service.IZcyysqSignatureService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.io.Serializable;

/**
 * 用印申请
 * 
 * @author sunxiaoyi
 * 
 */
@Controller
@RequestMapping("zcyysqSignature")
public class ZcyysqSignatureController implements Serializable {
	private static final long serialVersionUID = 1L;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IZcyysqService service;

    @Autowired
    IZcyysqSignatureService izcyysqSignatureService;


    @RequestMapping(value = "/changeStatus", method = RequestMethod.POST)
    public CommonResponse<String> changeStatus(@RequestBody String objectStr) {
        if (StringUtils.isEmpty(objectStr)) {
            throw new BusinessException("签章流程返回对象为空，请检查！");
        }
        logger.info("签章流程返回对象--{}", objectStr);
        JSONObject object = (JSONObject) JSONObject.parse(objectStr);
        String billId = object.getString("billId");
        String status = object.getString("status");
        String refCode = object.getString("refCode");
        if (StringUtils.isEmpty(billId) || StringUtils.isEmpty(status) || StringUtils.isEmpty(refCode)) {
            return CommonResponse.error("参数异常，请检查相关参数！");
        }
        return izcyysqSignatureService.relieveContract(Long.valueOf(billId), status, refCode);
    }



}
