package com.ejianc.business.sealm.controller.api;

import java.security.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.ejianc.business.sealm.bean.HtyysxEntity;
import com.ejianc.business.sealm.bean.YysqEntity;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.service.IHtyysxService;
import com.ejianc.business.sealm.service.IYysqService;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.business.sealm.vo.ZcyysqVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/instore/")
public class InstoreApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "YYSQ_CODE";//此处需要根据实际修改

    @Autowired
    private IYysqService service;

    @Autowired
    private IYzdjService djservice;

    @Autowired
    private IHtyysxService htsxservice;


    @Autowired
    private IZcyysqService zcyysqService;



    /**
     * @Author liyongjia
     * @Date 2020/6/10  新增用印申请
     * @Description updatePayment
     * @Param [vos]
     * @Return 
     */
    @RequestMapping(value = "addYysq", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> addYysq(@RequestBody YysqVO vo) {
        if(null != vo) {
            String BILL_CODE = "YYSQ_CODE";//此处需要根据实际修改
            YysqEntity entity = BeanMapper.map(vo, YysqEntity.class);
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            entity.setBillCode(billCode.getData());
            service.saveOrUpdate(entity,false);
            logger.info("接收到项目用印Task参数：{我要保存啦}" +vo);
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }


    /**
     * @Author chenchunlei
     * @Date 2021/1/26  新增印章登记
     * @Description updatePayment
     * @Param [vos]
     * @Return
     */
    @RequestMapping(value = "addYzdj", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> addYzdj(@RequestBody YzdjVO vo) {
        if(null != vo) {
            String BILL_CODE = "YZDJ_CODE";//此处需要根据实际修改
            YzdjEntity entity = BeanMapper.map(vo, YzdjEntity.class);
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            entity.setBillCode(billCode.getData());
            djservice.saveOrUpdate(entity,false);
            logger.info("接收到投标参数：{我要保存啦}");
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }

    /*
    * 根据印章编号查询保管人*/
    @RequestMapping(value = "selectYzBgr", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> selectYzBgr(@RequestBody String yzbh) {
        Long Bgrid=null;
        if(null != yzbh) {
           LambdaQueryWrapper<YzdjEntity> queryWrapper =new LambdaQueryWrapper<>();
           queryWrapper.eq(YzdjEntity::getYzbh,yzbh);
           YzdjEntity yzdj =djservice.getOne(queryWrapper);
           Bgrid =yzdj.getDqbgrId();
        }
        return CommonResponse.success("查询成功！",Bgrid);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10  通过合同详情新增合同用印申请
     * @Description updatePayment
     * @Param [vos]
     * @Return
     */
    @RequestMapping(value = "addHtyysqbydetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> addHtyysqbydetail(@RequestBody ZcyysqVO vo) {
        if(null != vo) {
            String BILL_CODE = "ZCHTYY_CODE";//此处需要根据实际修改
            //合同用印申请实体转换
            ZcyysqEntity entity = BeanMapper.map(vo, ZcyysqEntity.class);
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            entity.setBillCode(billCode.getData());
            entity.setBillState(3);  //推送数据默认为审批通过的
            entity.setMessageFrom(1);// 数据来源：0自建，1业务单据

            java.util.Date date = new Date();//获得当前时间
           DateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String format = simpleDateFormat.format(date);
           Date parse = null;
           try {
                parse =  simpleDateFormat.parse(format);
               entity.setSqDate(parse);
            }catch (ParseException e){
                e.printStackTrace();
           }

            //Integer ContractType=entity.getHtlb();
            String yysxbh=entity.getDjlj();//通过单据链接传递用印事项code
            /*查询合同用印事项*/
            if(null != yysxbh) {
                LambdaQueryWrapper<HtyysxEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(HtyysxEntity::getBillCode, yysxbh);
                HtyysxEntity htyysx = htsxservice.getOne(queryWrapper);
                entity.setZkbmId(htyysx.getZkbmId());//主控部门ID
                entity.setZkbmId(htyysx.getZkbmId());//主控部门name

                entity.setHtlxId(htyysx.getId());//合同类型，绑定的合同用印事项的id
                entity.setHtlxName(htyysx.getHtlbName());//合同类型

                entity.setHtlb(htyysx.getHtlx());//补充协议、正式合同、变更

                entity.setDjlj(htyysx.getBdlj());//表单链接
            }
            /*根据印章编号获取详细信息*/
            CommonResponse<YzdjVO> yzdjVOCommonResponse = selectYzxxByCode(entity.getYzbhCode());
            if (!yzdjVOCommonResponse.isSuccess()) {
                throw new BusinessException("通过印章编号获取印章登记信息失败！" + yzdjVOCommonResponse);
            }
            YzdjVO data = yzdjVOCommonResponse.getData();
            entity.setYzbhId(data.getId());//印章（编号）id
           entity.setYzlbId(data.getYzlbId());//印章类别
            entity.setYzlbName(data.getYzlbName());
            entity.setYzjbId(data.getYzjbId());//印章级别
            entity.setYzjbName(data.getYzjbName());
            entity.setYylxId(data.getYylxId());//用印类型
            entity.setYylxName(data.getYylxName());
            entity.setXgcs(0);//盖章确认次数000
            zcyysqService.saveOrUpdate(entity,false);
            logger.info("接收到合同用印Task参数：{我要保存啦}" +vo);
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10  通过合同详情新增合同用印申请
     * @Description updatePayment
     * @Param [vos]
     * @Return
     */
    @RequestMapping(value = "addHtyysq", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> addHtyysq(@RequestBody ZcyysqVO vo) {
        if(null != vo) {
            String BILL_CODE = "ZCHTYY_CODE";//此处需要根据实际修改
            ZcyysqEntity entity = BeanMapper.map(vo, ZcyysqEntity.class);
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            entity.setBillCode(billCode.getData());
            zcyysqService.saveOrUpdate(entity,false);
            logger.info("接收到合同用印Task参数：{我要保存啦}" +vo);
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }



    /*
     * 根据印章编号查询印章信息*/
    @RequestMapping(value = "selectYzxxByCode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<YzdjVO> selectYzxxByCode(@RequestBody String yzbh) {

        if(null != yzbh) {
            LambdaQueryWrapper<YzdjEntity> queryWrapper =new LambdaQueryWrapper<>();
            queryWrapper.eq(YzdjEntity::getYzbh,yzbh);
            YzdjEntity yzdj =djservice.getOne(queryWrapper);
            YzdjVO vo = BeanMapper.map(yzdj, YzdjVO.class);
            return CommonResponse.success("查询成功！",vo);
        }else {
            throw new BusinessException("印章编号为空，请检查印章编号！");
        }
    }
}
