package com.ejianc.business.sealm.controller.utils;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sealm.bean.YysqEntity;
import com.ejianc.business.sealm.service.IYysqService;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用于报表中获取组织结构树之类的，郑州一建公共的一些接口服务
 * 
 * @author generatoryysq
 * 
 */
@Controller
@RequestMapping("zzyjcommon")
public class CommonController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "SealM-XMYYSQ";//此处需要根据实际修改

    private static final String PREFIX_URL = "https://zzyj.ca.qunje.com:8008/stampInterface/";


    @Autowired
    private IYysqService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<YysqVO> saveOrUpdate(@RequestBody YysqVO saveorUpdateVO) {
    	YysqEntity entity = BeanMapper.map(saveorUpdateVO, YysqEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
         //       entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际
                entity.setXgcs(0);
                entity.setMessageFrom(0);  //自建的默认数据来源为0
                // 修改 删除本行或者上一行
                entity.setCreateUserName(sessionManager.getUserContext().getUserName());  //创建人
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

        } else {
            entity.setUpdateUserName(sessionManager.getUserContext().getUserName());  //修改人
        }
    	service.saveOrUpdate(entity, false);
    	YysqVO vo = BeanMapper.map(entity, YysqVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description 获取本下级的组织结构树
     */
    @RequestMapping(value = "/getPrjTreeQueryParam", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QueryParam> getPrjFinanceQueryParam(HttpServletRequest req) {
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            return CommonResponse.error("获取参数失败，获取当前用户本下组织信息失败。");
        }
        List<OrgVO> orgList = orgListResp.getData();
        QueryParam queryParam = new QueryParam();
        //queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        return CommonResponse.success(queryParam);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YysqVO> queryDetail(Long id) {
    	YysqEntity entity = service.selectById(id);
    	YysqVO vo = BeanMapper.map(entity, YysqVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YysqVO> vos) {
        service.removeByIds(vos.stream().map(YysqVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<YysqVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 模糊搜索配置字段示例 */
        fuzzyFields.add("billCode"); //申请单编号
        fuzzyFields.add("sqdwName");  //申请单位
        fuzzyFields.add("sqrName");  //申请人
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<YysqEntity> page = service.queryPage(param,false);
        IPage<YysqVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), YysqVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


            /**
             * @Description 导出
             * @param param
             * @Return void
            */
            @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<YysqEntity> list = service.queryList(param);

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Yysq-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refYysqData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<YysqVO>> refYysqData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<YysqEntity> page = service.queryPage(param,false);
        IPage<YysqVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), YysqVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/getStampInfo", method = RequestMethod.GET)
    @ResponseBody
    public String getStampInfo() {
        // 请求url
        String url = PREFIX_URL + "order/getStampInfo";
        // 参数组织
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("caseId", "HBJS-OASealUseApply-2");
        param.put("sessionId", "HBJS-OASealUseApplyItem-2");
        // 转换为json字符串
        String jsonString = JSONObject.toJSONString(param);
        // 发送请求
        String result = HttpUtil.post(url, jsonString);


        return result;

    }
}
