package com.ejianc.business.sealm.service.impl;

import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.service.IZcyysqSignatureService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 用印申请
 * 
 * @author generator
 * 
 */
@Service("zcyysqSignatureService")
public class ZcyysqSignatureServiceImpl implements IZcyysqSignatureService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IZcyysqService service;

    @Autowired
    IZcyysqSignatureService izcyysqSignatureService;


    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param id              合同解除单据id
     * @param signatureStatus 签章状态
     * @param refCode         唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(Long id, String signatureStatus, String refCode) {
        logger.info("更新用印申请合同状态，入参--id；{}，signatureStatus：{}，refCode：{}", id, signatureStatus, refCode);

        ZcyysqEntity zcyysqEntity = service.selectById(id);
        if (zcyysqEntity != null) {
            //修改签章状态
            zcyysqEntity.setSignatureStatus(signatureStatus);
            service.saveOrUpdate(zcyysqEntity);
        }
        return null;
    }
}
