package com.ejianc.business.sealm.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.ZzryjEntity;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.service.IZzryjService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("zzryj") 
public class ZzryjBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IZzryjService service;

	@Autowired
	private IYzdjService yzdjService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		//责任人变更审批通过后修改印章登记里的当前保管人
		ZzryjEntity zzryjEntity =service.getById(billId);
		//根据印章编号修改印章登记信息
		LambdaUpdateWrapper<YzdjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzdjEntity::getDqbgrId, zzryjEntity.getDqbgrId());
		updateWrapper.set(YzdjEntity::getDqbgrName, zzryjEntity.getDqbgrName());
		updateWrapper.eq(YzdjEntity::getBillCode, zzryjEntity.getYzbhCode());
		yzdjService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//流程撤回时将保管人修改为印章登记里的当前保管人
		ZzryjEntity zzryjEntity =service.getById(billId);
		QueryWrapper<YzdjEntity> objectQueryWrapper = new QueryWrapper<>();
		YzdjEntity yzdjEntity = new YzdjEntity();
		yzdjEntity.setBillCode(zzryjEntity.getYzbhCode());
		objectQueryWrapper.setEntity(yzdjEntity);
		//通过印章登记编号查询印章登记里的当前保管人
		YzdjEntity yzdjEnties  = yzdjService.getOne(objectQueryWrapper);
		//根据印章编号修改印章登记信息
		//根据印章编号修改印章登记信息
		LambdaUpdateWrapper<ZzryjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(ZzryjEntity::getDqbgrId, yzdjEnties.getDqbgrId());
		updateWrapper.eq(ZzryjEntity::getId, billId);
		service.update(updateWrapper);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 有审批流的审批通过回调
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//责任人变更审批通过后修改印章登记里的当前保管人
		ZzryjEntity zzryjEntity =service.getById(billId);
		//根据印章编号修改印章登记信息
		LambdaUpdateWrapper<YzdjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzdjEntity::getDqbgrId, zzryjEntity.getDqbgrId());
		updateWrapper.set(YzdjEntity::getDqbgrName, zzryjEntity.getDqbgrName());
		updateWrapper.eq(YzdjEntity::getBillCode, zzryjEntity.getYzbhCode());
		yzdjService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//流程撤回时将保管人修改为印章登记里的当前保管人
		ZzryjEntity zzryjEntity =service.getById(billId);
		//将印章登记编号封装进参数体
		QueryWrapper<YzdjEntity> objectQueryWrapper = new QueryWrapper<>();
		YzdjEntity yzdjEntity = new YzdjEntity();
		yzdjEntity.setBillCode(zzryjEntity.getYzbhCode());
		objectQueryWrapper.setEntity(yzdjEntity);
		//通过印章登记编号查询印章登记里的当前保管人
		YzdjEntity yzdjEnties  = yzdjService.getOne(objectQueryWrapper);
		//根据印章编号修改印章登记信息
		//根据印章编号修改印章登记信息
		LambdaUpdateWrapper<ZzryjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(ZzryjEntity::getDqbgrId, yzdjEnties.getDqbgrId());
		updateWrapper.eq(ZzryjEntity::getId, billId);
		service.update(updateWrapper);
		return CommonResponse.success();
	}

}
