/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sealm.controller.utils;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sealm.bean.YysqEntity;
import com.ejianc.business.sealm.service.IYysqService;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"zzyjcommon"})
public class CommonController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "SealM-XMYYSQ";
    private static final String PREFIX_URL = "https://zzyj.ca.qunje.com:8008/stampInterface/";
    @Autowired
    private IYysqService service;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<YysqVO> saveOrUpdate(@RequestBody YysqVO saveorUpdateVO) {
        YysqEntity entity = (YysqEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, YysqEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            entity.setXgcs(0);
            entity.setMessageFrom(0);
            entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        } else {
            entity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        YysqVO vo = (YysqVO)BeanMapper.map((Object)((Object)entity), YysqVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getPrjTreeQueryParam"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QueryParam> getPrjFinanceQueryParam(HttpServletRequest req) {
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgListResp.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u53c2\u6570\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        List orgList = (List)orgListResp.getData();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter("in", orgList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((Object)queryParam);
    }

    @RequestMapping(value={"/getPrjTreeQueryParamNew"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QueryParam> getPrjTreeQueryParamNew(HttpServletRequest req) {
        Long orgId;
        String leftTreeId = req.getParameter("leftTreeId");
        if (StringUtils.isNotEmpty((String)leftTreeId)) {
            this.logger.info("leftTreeId:::" + leftTreeId);
            orgId = Long.valueOf(leftTreeId);
        } else {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u53c2\u6570\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        List orgList = (List)orgListResp.getData();
        this.logger.info("orgList:::" + JSON.toJSON((Object)orgList).toString());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter("in", orgList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((Object)queryParam);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<YysqVO> queryDetail(Long id) {
        YysqEntity entity = (YysqEntity)((Object)this.service.selectById(id));
        YysqVO vo = (YysqVO)BeanMapper.map((Object)((Object)entity), YysqVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YysqVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<YysqVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("billCode");
        fuzzyFields.add("sqdwName");
        fuzzyFields.add("sqrName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YysqVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Yysq-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refYysqData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<YysqVO>> refYysqData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YysqVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getStampInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public String getStampInfo() {
        String url = "https://zzyj.ca.qunje.com:8008/stampInterface/order/getStampInfo";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("caseId", "HBJS-OASealUseApply-2");
        param.put("sessionId", "HBJS-OASealUseApplyItem-2");
        String jsonString = JSONObject.toJSONString(param);
        String result = HttpUtil.post((String)url, (String)jsonString);
        return result;
    }
}

