package com.ejianc.business.sealm.controller.api;

import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.service.IZcyysqSignatureService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.LinkedHashMap;
import java.util.List;

@RestController
@RequestMapping("/api/sealmZcyysq/")
public class SealmZcyysqApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IZcyysqService zcyysqService;
    @Autowired
    private IZcyysqSignatureService signatureService;



    @RequestMapping(value = "querySignatureFileId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Long> querySignatureFileId(@RequestParam Long contractId) {

        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 租户隔离 */
        param.getParams().put("htId", new Parameter(QueryParam.EQ, contractId));

        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));

        param.getParams().put("signatureStatus", new Parameter(QueryParam.EQ, "4"));

        LinkedHashMap<String, String> orderMap = param.getOrderMap();

        orderMap.put("create_time", QueryParam.DESC);

        List<ZcyysqEntity> zcyysqEntities = zcyysqService.queryList(param);
        if (zcyysqEntities != null && zcyysqEntities.size() > 0){
            if (zcyysqEntities.get(0).getSignedFileId() != null) {
                return CommonResponse.success("查询成功！", zcyysqEntities.get(0).getSignedFileId());
            }else {
                Long aLong = signatureService.updateSignFileId(zcyysqEntities.get(0).getId());
                if (aLong != null) {
                    return CommonResponse.success("查询成功！", aLong);
                }else {
                    return CommonResponse.error("获取签章文件id失败！");
                }
            }
        }else {
            return CommonResponse.error("没有找到该合同的用印记录！");
        }
    }


}
