package com.ejianc.business.sealm.service.impl;

import com.ejianc.business.sealm.bean.G9dzhtEntity;
import com.ejianc.business.sealm.service.IG9dzhtService;
import com.ejianc.business.sealm.service.IG9dzhtSignatureService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 用印申请
 * 
 * @author generator
 * 
 */
@Service("g9dzhtSignatureService")
public class G9dzhtSignatureServiceImpl implements IG9dzhtSignatureService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IG9dzhtService service;

    @Autowired
    IG9dzhtSignatureService ig9dzhtSignatureService;


    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param id              合同解除单据id
     * @param signatureStatus 签章状态
     * @param refCode         唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(Long id, String signatureStatus, String refCode) {
        logger.info("更新用印申请合同状态，入参--id；{}，signatureStatus：{}，refCode：{}", id, signatureStatus, refCode);

        G9dzhtEntity g9dzhtEntity = service.selectById(id);
        if (g9dzhtEntity != null) {
            //修改签章状态
            g9dzhtEntity.setSignatureStatus(signatureStatus);
            service.saveOrUpdate(g9dzhtEntity);
        }
        return CommonResponse.success("签章状态修改成功！");
    }
}
