package com.ejianc.business.sealm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.api.IContractFillingApi;
import com.ejianc.business.sealm.bean.FillingEntity;
import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.mapper.ZcyysqSignatureMapper;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.service.IZcyysqSignatureService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 用印申请
 *
 * @author generator
 */
@Service("zcyysqSignatureService")
public class ZcyysqSignatureServiceImpl implements IZcyysqSignatureService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IZcyysqService service;

    @Autowired
    IZcyysqSignatureService izcyysqSignatureService;

    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Autowired
    private ZcyysqSignatureMapper mapper;

    @Autowired
    private IContractFillingApi fillingApi;


    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param id              合同解除单据id
     * @param signatureStatus 签章状态
     * @param refCode         唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(Long id, String signatureStatus, String refCode) {
        logger.info("更新用印申请合同状态，入参--id；{}，signatureStatus：{}，refCode：{}", id, signatureStatus, refCode);

//        ArrayList<ContractVO> cvs = new ArrayList<>();
//        ContractVO cv = new ContractVO();

        ZcyysqEntity zcyysqEntity = service.selectById(id);
        if (zcyysqEntity != null) {
//            cv.setContractId(zcyysqEntity.getId());
//            cv.setContractName(zcyysqEntity.getAttachmentFileName());
//            cv.setBillType("BT220121000000005");
//            cv.setSourceType("contract");
//            cvs.add(cv);
            if (signatureStatus.equals("4")) {
//                CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
//                if(!signResp.isSuccess()) {
//                    logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", id, "无", signResp.getMsg());
//                    throw new BusinessException("获取合同签章文件信息失败");
//                }
//
//                List<SignMgrPreviewVO> fileList = signResp.getData();
//                if(CollectionUtils.isEmpty(fileList)) {
//                    throw new BusinessException("未获取到合同签章文件信息");
//                }
//
//                SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
//                zcyysqEntity.setSignedFileId(signedFileInfo.getFileId());
                //修改签章状态
                zcyysqEntity.setSignatureStatus(signatureStatus);

                service.saveOrUpdate(zcyysqEntity);
                /**
                 * 修改登记合同的归档状态
                 */

                if (zcyysqEntity.getHtId() != null) {

                    if (zcyysqEntity.getHtlxName().equals("施工合同")) {
                        mapper.updateSghtStatus(zcyysqEntity.getHtId(), new Date(), zcyysqEntity.getId());
                    } else {
                        FillingEntity fillingEntity = new FillingEntity();
                        if (zcyysqEntity.getHtlxName().equals("劳务分包合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("laborSub");
                            //mapper.updateLwfbStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("劳务分包合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("laborSubChange");
                            //mapper.updateLwfbbgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("材料采购合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractMaterial");
                            //mapper.updateXhcStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("材料采购合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractMaterialChange");
                            //mapper.updateXhcbgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("专业分包合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("proSub");
                            //mapper.updateLwfbStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("专业分包合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("proSubChange");
                            //mapper.updateLwfbbgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("商砼采购合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractConcrete");
                            //mapper.updateXhcStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("商砼采购合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractConcreteChange");
                            //mapper.updateXhcbgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("周转材租赁合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("rmat");
                            //mapper.updateZzcStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("周转材租赁合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("rmatChange");
                            //mapper.updateZzcbgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("其他支出合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractOther");
                            //mapper.updateQtzcStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("其他支出合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractOtherChange");
                            //mapper.updateQtzcbgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备安拆合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractAC");
                            //mapper.updateJxsbacStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备安拆合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractACChange");
                            //mapper.updateJxsbacbgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备租赁合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentRent");
                            //mapper.updateJxsbzlStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备租赁合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentRentChange");
                            //mapper.updateJxsbzlbgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备采购合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentPurchase");
                            //mapper.updateJxsbcgStatus(zcyysqEntity.getHtId());
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备采购合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentPurchaseChange");
                            //mapper.updateJxsbcgbgStatus(zcyysqEntity.getHtId());
                        }
                        if (fillingEntity.getFillingType() != null) {
                            String s = JSONObject.toJSONString(fillingEntity);
                            CommonResponse<String> stringCommonResponse = fillingApi.updateFilingStatus(s);
                            logger.info("修改归档状态：{}",stringCommonResponse.getMsg());
                        }
                    }
                }
            } else {
                //修改签章状态
                zcyysqEntity.setSignatureStatus(signatureStatus);
                service.saveOrUpdate(zcyysqEntity);
            }
        }
        return CommonResponse.success("签章状态修改成功！");
    }

    @Override
    public Long updateSignFileId(Long id) {
        ArrayList<ContractVO> cvs = new ArrayList<>();
        ContractVO cv = new ContractVO();
        ZcyysqEntity zcyysqEntity = service.selectById(id);

        if (zcyysqEntity != null) {
            cv.setContractId(zcyysqEntity.getId());
            cv.setContractName(zcyysqEntity.getAttachmentFileName());
            cv.setBillType("BT220121000000005");
            cv.setSourceType("contract");
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                logger.error("获取单据id-{}，billType-{}，签章文件信息失败: {}", id, "无", signResp.getMsg());
                throw new BusinessException("获取合同签章文件信息失败");
            }

            List<SignMgrPreviewVO> fileList = signResp.getData();
            if (CollectionUtils.isEmpty(fileList)) {
                throw new BusinessException("未获取到合同签章文件信息");
            }

            SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
            zcyysqEntity.setSignedFileId(signedFileInfo.getFileId());

            service.saveOrUpdate(zcyysqEntity);
            return signedFileInfo.getFileId();
        }
        return null;
    }
}
