package com.ejianc.business.sealm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sealm.bean.ZzyzEntity;
import com.ejianc.business.sealm.service.IZzyzService;
import com.ejianc.business.sealm.vo.ContractVO;
import com.ejianc.business.sealm.vo.ZzyzVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 组织印章
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("zzyz")
public class ZzyzController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IZzyzService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ZzyzVO> saveOrUpdate(@RequestBody ZzyzVO saveOrUpdateVO) {
    	ZzyzEntity entity = BeanMapper.map(saveOrUpdateVO, ZzyzEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ZzyzVO vo = BeanMapper.map(entity, ZzyzVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ZzyzVO> queryDetail(Long id) {
    	ZzyzEntity entity = service.selectById(id);
    	ZzyzVO vo = BeanMapper.map(entity, ZzyzVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ZzyzVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ZzyzVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ZzyzVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ZzyzVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            //orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());

        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ZzyzEntity> page = service.queryPage(param,false);
        IPage<ZzyzVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ZzyzVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ZzyzEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Zzyz-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refZzyzData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ZzyzVO>> refZzyzData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            Long gldw = con.getLong("gldw");
            if (gldw != null){
                param.getParams().put("gldwId", new Parameter(QueryParam.EQ,gldw ));
            }
        }

        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ZzyzVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        if (parentId != null) {
            wrapper.apply("\n(" +
                    "org_code = '" + code + "'\n" +
                    "or\n" +
                    "org_code like '" + code + "%'\n" +
                    "or\n" +
                    "org_code = '1'\n" +
                    "or\n" +
                    "org_id = " + parentId +")" );
        }else {
            wrapper.apply("\n(" +
                    "org_code = '" + code + "'\n" +
                    "or\n" +
                    "org_code like '" + code + "%'\n" +
                    "or\n" +
                    "org_code = '1'\n)" );
        }

        //自定义查询，写xml
        List<ZzyzVO> list = service. queryStoreInstoreData (page, wrapper);
        IPage<ZzyzVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description 机械设备采购参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refJxsbcgData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refJxsbcgData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                              String condition,
                                                              String searchObject,
                                                              String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("change_draft_type", new Parameter(QueryParam.IN,
                Arrays.asList(3,4)));


        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }

        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.queryJxsbcgData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refJxsbzlData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refJxsbzlData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("change_draft_type", new Parameter(QueryParam.IN,
                Arrays.asList(3,4)));


        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }

        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.queryJxsbzlData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refJxsbacData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refJxsbacData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("change_draft_type", new Parameter(QueryParam.IN,
                Arrays.asList(3,4)));


        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.queryJxsbacData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * @Description 材料采购合同参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refClcgData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refClcgData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("change_draft_type", new Parameter(QueryParam.IN,
                Arrays.asList(3,4)));


        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if(null != con.getInteger("contractType")) {
                param.getParams().put("contractType", new Parameter(QueryParam.EQ,  con.getInteger("contractType")));
            }
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.refClcgData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 施工合同参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refSghtData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refSghtData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.refSghtData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }

/*    *//**
     * @Description 商砼采购参照
     * @param
     * @Return void
     *//*
    @RequestMapping(value = "/refStcgData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refStcgData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        *//** 租户隔离 *//*
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        if(StringUtils.isNotEmpty(condition)){
            *//** 处理condition *//*
            JSONObject con = JSONObject.parseObject(condition);
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.queryJxsbacData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    *//**
     * @Description 周转材采购参照
     * @param
     * @Return void
     *//*
    @RequestMapping(value = "/refZzcData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refZzcData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        *//** 租户隔离 *//*
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        if(StringUtils.isNotEmpty(condition)){
            *//** 处理condition *//*
            JSONObject con = JSONObject.parseObject(condition);
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.queryJxsbacData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }*/

    /**
     * @Description 分包参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refFbData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refFbData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                        String condition,
                                                        String searchObject,
                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("change_draft_type", new Parameter(QueryParam.IN,
                Arrays.asList(3,4)));


        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if(null != con.getInteger("contractType")) {
                param.getParams().put("contractType", new Parameter(QueryParam.EQ,  con.getInteger("contractType")));
            }
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.refFbData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 其他支出参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refQtzcData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refQtzcData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("change_draft_type", new Parameter(QueryParam.IN,
                Arrays.asList(3,4)));


        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.refQtzcData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * @Description 周转材租赁变更参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refZzcData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refZzcData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        param.getParams().put("change_draft_type", new Parameter(QueryParam.IN,
                Arrays.asList(3,4)));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        //自定义查询，写xml
        List<ContractVO> list = service.refZzcData (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * @Description 其他支出参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refQtzc1Data", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refQtzc1Data(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("draft_type", new Parameter(QueryParam.IN,
                Arrays.asList(3,4)));


        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        //获取当前组织code以及parentId
        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        String code = data.getCode();
        Long parentId = data.getParentId();

        //自定义查询，拼接查询语句
        Page<ContractVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        //自定义查询，写xml
        List<ContractVO> list = service.refQtzc1Data (page, wrapper);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
