package com.ejianc.business.settle.api;

import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.hystrix.SettlementCenterDcDrwgrpInfoHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@FeignClient(
        name = "ejc-settle-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-settle-web",
        fallback = SettlementCenterDcDrwgrpInfoHystrix.class
)
public interface ISettlementCenterDcDrwgrpInfoApi {
    @RequestMapping(value = "/settlementCenterDcDrwgrpInfo/saveOrUpdateDcDrwgrpInfo", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdateSettlementCenterDcDrwgrpInfo(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO);

    @RequestMapping(value = "/settlementCenterBudgetFee/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<SettlementCenterBudgetFeeVO> saveOrUpdateSettlementCenterBudgetFee(@RequestBody SettlementCenterBudgetFeeVO saveOrUpdateVO);

    @RequestMapping(value = "/settlementCenterBudgetMeasure/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<SettlementCenterBudgetMeasureVO> saveOrUpdateSettlementCenterBudgetMeasure(@RequestBody SettlementCenterBudgetMeasureVO saveOrUpdateVO);

    @RequestMapping(value = "/settlementCenterBudgetOther/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<SettlementCenterBudgetOtherVO> saveOrUpdateSettlementCenterBudgetOther(@RequestBody SettlementCenterBudgetOtherVO saveOrUpdateVO);

    @RequestMapping(value = "/settlementCenterBudgetSub/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<SettlementCenterBudgetSubVO> saveOrUpdateSettlementCenterBudgetSub(@RequestBody SettlementCenterBudgetSubVO saveOrUpdateVO);

    @RequestMapping(value = "/settlementCenterDcDrwgrpInfo/deleteForDrwgrp", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> deleteForDrwgrp(List<Long> dcDrwgrpId);


}
