package com.ejianc.business.settle.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SettleFlowStateEnum {
    ONE("1","未判别"),
    TWO("2","已合并数"),
    THREE("3","待项目负责人派发"),
    FOUR("4","待统计"),
    FIVE("5","待专业主管审核"),
    SIX("6","待项目负责人复审"),
    SEVEN("7","待合同主管复审"),
    EIGHT("8","待综合管理员复审"),
    NINE("9","已完成统计"),
    TEN("10","待会签");

    private final String code;
    private final String name;
    private static Map<String, SettleFlowStateEnum> enumMap = new HashMap();

    private SettleFlowStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static SettleFlowStateEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = EnumSet.allOf(SettleFlowStateEnum.class).stream().collect(Collectors.toMap(SettleFlowStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

}
