package com.ejianc.business.settle.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 图纸到图计划
 * 
 * @author generator
 * 
 */
public class SettlementCenterDrawPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectMajorId; // 项目专业id
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String settlementCenterMajorName; // 结算中心专业名称
    private Long settlementCenterMajor; // 结算中心专业
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private String systemName; // 系统名称
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date proStartTime; // 工程开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date proEndTime; // 工程结束时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date calStartTime; // 计量开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date calEndTime; // 计量结束时间
    private Integer totalNum; // 总册数

    private BigDecimal contractTaxMny; // 合同金额
    private Long statisticalPerson; // 负责人
    private Long majorManagerPerson; // 专业主管
    private Long projectResponsiblePerson; // 项目负责人
    private Long projectContractPerson; // 项目合同主管
    private Long compositePerson; // 综合管理员
    private Integer planFinishDays; // 期望值

    private List<SettlementCenterDrawPlanDetailVO> settlementCenterDrawPlanDetailList = new ArrayList<>(); // 图纸到图计划明细


    @ReferSerialTransfer(referCode="idm-employee")
    public Long getMajorManagerPerson() {
        return majorManagerPerson;
    }
    @ReferDeserialTransfer
    public void setMajorManagerPerson(Long majorManagerPerson) {
        this.majorManagerPerson = majorManagerPerson;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectResponsiblePerson() {
        return projectResponsiblePerson;
    }
    @ReferDeserialTransfer
    public void setProjectResponsiblePerson(Long projectResponsiblePerson) {
        this.projectResponsiblePerson = projectResponsiblePerson;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectContractPerson() {
        return projectContractPerson;
    }
    @ReferDeserialTransfer
    public void setProjectContractPerson(Long projectContractPerson) {
        this.projectContractPerson = projectContractPerson;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCompositePerson() {
        return compositePerson;
    }

    @ReferDeserialTransfer
    public void setCompositePerson(Long compositePerson) {
        this.compositePerson = compositePerson;
    }

    public Integer getPlanFinishDays() {
        return planFinishDays;
    }

    public void setPlanFinishDays(Integer planFinishDays) {
        this.planFinishDays = planFinishDays;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getStatisticalPerson() {
        return statisticalPerson;
    }

    @ReferDeserialTransfer
    public void setStatisticalPerson(Long statisticalPerson) {
        this.statisticalPerson = statisticalPerson;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    @ReferSerialTransfer(referCode = "project_major")
    public Long getProjectMajorId() {
        return projectMajorId;
    }

    @ReferDeserialTransfer
    public void setProjectMajorId(Long projectMajorId) {
        this.projectMajorId = projectMajorId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getSettlementCenterMajorName() {
        return settlementCenterMajorName;
    }

    public void setSettlementCenterMajorName(String settlementCenterMajorName) {
        this.settlementCenterMajorName = settlementCenterMajorName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSettlementCenterMajor() {
        return settlementCenterMajor;
    }

    @ReferDeserialTransfer
    public void setSettlementCenterMajor(Long settlementCenterMajor) {
        this.settlementCenterMajor = settlementCenterMajor;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getSystemName() {
        return systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }
    public Date getProStartTime() {
        return proStartTime;
    }

    public void setProStartTime(Date proStartTime) {
        this.proStartTime = proStartTime;
    }
    public Date getProEndTime() {
        return proEndTime;
    }

    public void setProEndTime(Date proEndTime) {
        this.proEndTime = proEndTime;
    }
    public Date getCalStartTime() {
        return calStartTime;
    }

    public void setCalStartTime(Date calStartTime) {
        this.calStartTime = calStartTime;
    }
    public Date getCalEndTime() {
        return calEndTime;
    }

    public void setCalEndTime(Date calEndTime) {
        this.calEndTime = calEndTime;
    }
    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }
    
     public List<SettlementCenterDrawPlanDetailVO> getSettlementCenterDrawPlanDetailList() {
        return settlementCenterDrawPlanDetailList;
     }

     public void setSettlementCenterDrawPlanDetailList(List<SettlementCenterDrawPlanDetailVO> settlementCenterDrawPlanDetailList) {
        this.settlementCenterDrawPlanDetailList = settlementCenterDrawPlanDetailList;
     }
}
