package com.ejianc.business.settle.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SettleDrawTypeEnum {
    N("1","无需统计(总图、通用图)"),
    Y("2","需统计(默认值)"),
    OTHER("3","已并入其它图册");

    private final String code;
    private final String name;
    private static Map<String, SettleDrawTypeEnum> enumMap = new HashMap();

    private SettleDrawTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static SettleDrawTypeEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = EnumSet.allOf(SettleDrawTypeEnum.class).stream().collect(Collectors.toMap(SettleDrawTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

}
