package com.ejianc.business.settle.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 结算中心系统产值表
 * 
 * @author generator
 * 
 */
public class SettlementCenterSystemDrwgrpVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String settlementCenterMajor; // 结算中心专业
    private String settlementCenterMajorName; // 结算中心专业名称
    private BigDecimal statisticalOutput; // 统计产值
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date desiredTime; // 期望完成时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date firstNodeTime; // 数据生成的时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date secondNodeTime; // 预算员接收时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date thirdNodeTime; // 预算员提交时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date fourthNodeTime; // 专业主管审核时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date fifthNodeTime; // 结算中心项目负责人复审时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sixthNodeTime; // 项目合同主管复审时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date seventhNodeTime; // 综合管理员复审归档时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date eighthNodeTime; // 完成时间
    private String thirdNodeUserId; // 预算员
    private String fourthNodeUserId; // 专业主管
    private Long fifthNodeUserId; // 结算中心项目负责人
    private Long sixthNodeUserId; // 项目合同主管
    private Long seventhNodeUserId; // 综合管理员
    private String thirdNodeUserName; // 预算员
    private String fourthNodeUserName; // 专业主管
    private String fifthNodeUserName; // 结算中心项目负责人
    private String sixthNodeUserName; // 项目合同主管
    private String seventhNodeUserName; // 综合管理员
    private Long createDeptId; // 创建部门id
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String flowState; // 流程状态
    private String flowStateName; // 流程状态名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private String contractId; // 承包合同id
    private String contractCode; // 承包合同code
    private String sourceUnitid; // 设计单位id
    private String sourceUnitname; // 设计单位
    private BigDecimal contractMny; // 合同金额
    private Long systemId; // 系统id
    private String systemName; // 系统名称
    private String statisticalResults; // 统计成果文件名称
    private String statisticalResultsFile; // 统计成果文件id

    private List<SettlementCenterSystemNumDetailVO> settlementCenterSystemNumDetailList = new ArrayList<>(); // 结算中心系统工程量明细

    public List<SettlementCenterSystemNumDetailVO> getSettlementCenterSystemNumDetailList() {
        return settlementCenterSystemNumDetailList;
    }

    public void setSettlementCenterSystemNumDetailList(List<SettlementCenterSystemNumDetailVO> settlementCenterSystemNumDetailList) {
        this.settlementCenterSystemNumDetailList = settlementCenterSystemNumDetailList;
    }

    public String getStatisticalResults() {
        return statisticalResults;
    }

    public void setStatisticalResults(String statisticalResults) {
        this.statisticalResults = statisticalResults;
    }

    public String getStatisticalResultsFile() {
        return statisticalResultsFile;
    }

    public void setStatisticalResultsFile(String statisticalResultsFile) {
        this.statisticalResultsFile = statisticalResultsFile;
    }

    private List<SettlementCenterDcDrwgrpInfoVO> infoList = new ArrayList<>();

    public List<SettlementCenterDcDrwgrpInfoVO> getInfoList() {
        return infoList;
    }

    public void setInfoList(List<SettlementCenterDcDrwgrpInfoVO> infoList) {
        this.infoList = infoList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getSettlementCenterMajor() {
        return settlementCenterMajor;
    }
    @ReferDeserialTransfer
    public void setSettlementCenterMajor(String settlementCenterMajor) {
        this.settlementCenterMajor = settlementCenterMajor;
    }
    public String getSettlementCenterMajorName() {
        return settlementCenterMajorName;
    }

    public void setSettlementCenterMajorName(String settlementCenterMajorName) {
        this.settlementCenterMajorName = settlementCenterMajorName;
    }
    public BigDecimal getStatisticalOutput() {
        return statisticalOutput;
    }

    public void setStatisticalOutput(BigDecimal statisticalOutput) {
        this.statisticalOutput = statisticalOutput;
    }
    public Date getDesiredTime() {
        return desiredTime;
    }

    public void setDesiredTime(Date desiredTime) {
        this.desiredTime = desiredTime;
    }
    public Date getFirstNodeTime() {
        return firstNodeTime;
    }

    public void setFirstNodeTime(Date firstNodeTime) {
        this.firstNodeTime = firstNodeTime;
    }
    public Date getSecondNodeTime() {
        return secondNodeTime;
    }

    public void setSecondNodeTime(Date secondNodeTime) {
        this.secondNodeTime = secondNodeTime;
    }
    public Date getThirdNodeTime() {
        return thirdNodeTime;
    }

    public void setThirdNodeTime(Date thirdNodeTime) {
        this.thirdNodeTime = thirdNodeTime;
    }
    public Date getFourthNodeTime() {
        return fourthNodeTime;
    }

    public void setFourthNodeTime(Date fourthNodeTime) {
        this.fourthNodeTime = fourthNodeTime;
    }
    public Date getFifthNodeTime() {
        return fifthNodeTime;
    }

    public void setFifthNodeTime(Date fifthNodeTime) {
        this.fifthNodeTime = fifthNodeTime;
    }
    public Date getSixthNodeTime() {
        return sixthNodeTime;
    }

    public void setSixthNodeTime(Date sixthNodeTime) {
        this.sixthNodeTime = sixthNodeTime;
    }
    public Date getSeventhNodeTime() {
        return seventhNodeTime;
    }

    public void setSeventhNodeTime(Date seventhNodeTime) {
        this.seventhNodeTime = seventhNodeTime;
    }
    public Date getEighthNodeTime() {
        return eighthNodeTime;
    }

    public void setEighthNodeTime(Date eighthNodeTime) {
        this.eighthNodeTime = eighthNodeTime;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public String getThirdNodeUserId() {
        return thirdNodeUserId;
    }
    @ReferDeserialTransfer
    public void setThirdNodeUserId(String thirdNodeUserId) {
        this.thirdNodeUserId = thirdNodeUserId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public String getFourthNodeUserId() {
        return fourthNodeUserId;
    }
    @ReferDeserialTransfer
    public void setFourthNodeUserId(String fourthNodeUserId) {
        this.fourthNodeUserId = fourthNodeUserId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getFifthNodeUserId() {
        return fifthNodeUserId;
    }
    @ReferDeserialTransfer
    public void setFifthNodeUserId(Long fifthNodeUserId) {
        this.fifthNodeUserId = fifthNodeUserId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSixthNodeUserId() {
        return sixthNodeUserId;
    }
    @ReferDeserialTransfer
    public void setSixthNodeUserId(Long sixthNodeUserId) {
        this.sixthNodeUserId = sixthNodeUserId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSeventhNodeUserId() {
        return seventhNodeUserId;
    }
    @ReferDeserialTransfer
    public void setSeventhNodeUserId(Long seventhNodeUserId) {
        this.seventhNodeUserId = seventhNodeUserId;
    }
    public String getThirdNodeUserName() {
        return thirdNodeUserName;
    }

    public void setThirdNodeUserName(String thirdNodeUserName) {
        this.thirdNodeUserName = thirdNodeUserName;
    }
    public String getFourthNodeUserName() {
        return fourthNodeUserName;
    }

    public void setFourthNodeUserName(String fourthNodeUserName) {
        this.fourthNodeUserName = fourthNodeUserName;
    }
    public String getFifthNodeUserName() {
        return fifthNodeUserName;
    }

    public void setFifthNodeUserName(String fifthNodeUserName) {
        this.fifthNodeUserName = fifthNodeUserName;
    }
    public String getSixthNodeUserName() {
        return sixthNodeUserName;
    }

    public void setSixthNodeUserName(String sixthNodeUserName) {
        this.sixthNodeUserName = sixthNodeUserName;
    }
    public String getSeventhNodeUserName() {
        return seventhNodeUserName;
    }

    public void setSeventhNodeUserName(String seventhNodeUserName) {
        this.seventhNodeUserName = seventhNodeUserName;
    }
    public Long getCreateDeptId() {
        return createDeptId;
    }

    public void setCreateDeptId(Long createDeptId) {
        this.createDeptId = createDeptId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getFlowState() {
        return flowState;
    }

    public void setFlowState(String flowState) {
        this.flowState = flowState;
    }
    public String getFlowStateName() {
        return flowStateName;
    }

    public void setFlowStateName(String flowStateName) {
        this.flowStateName = flowStateName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode = "pro-income-contract")
    public String getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    @ReferSerialTransfer(referCode = "Dc-drawSourceMaintenance-Menu-Refer")
    public String getSourceUnitid() {
        return sourceUnitid;
    }
    @ReferDeserialTransfer
    public void setSourceUnitid(String sourceUnitid) {
        this.sourceUnitid = sourceUnitid;
    }
    public String getSourceUnitname() {
        return sourceUnitname;
    }

    public void setSourceUnitname(String sourceUnitname) {
        this.sourceUnitname = sourceUnitname;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    @ReferSerialTransfer(referCode = "draw_plan")
    public Long getSystemId() {
        return systemId;
    }

    @ReferDeserialTransfer
    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }
    public String getSystemName() {
        return systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }
    
}
