package com.ejianc.business.settle.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.service.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 结算中心卷册信息表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settlementCenterDcDrwgrpInfo")
public class SettlementCenterDcDrwgrpInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService service;
    @Autowired
    private ISettlementCenterBudgetFeeService feeService;
    @Autowired
    private ISettlementCenterBudgetMeasureService measureService;
    @Autowired
    private ISettlementCenterBudgetSubService subService;
    @Autowired
    private ISettlementCenterBudgetOtherService otherService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdate(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
    	SettlementCenterDcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
    	service.saveOrUpdate(entity, false);
    	SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
    卷册审批完成新增数据
     */
    @RequestMapping(value = "/saveOrUpdateDcDrwgrpInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdateDcDrwgrpInfo(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        SettlementCenterDcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class);
        SettlementCenterDcDrwgrpInfoEntity exist = service.getOne(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, saveOrUpdateVO.getDcDrwgrpInfoId())
        );
        if (exist != null){
            exist.setFirstNodeTime(new Date());
            service.updateById(exist);
        }else {
            SettlementCenterDcDrwgrpInfoEntity notUpgrade = service.getOne(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoCode, saveOrUpdateVO.getDcDrwgrpInfoCode())
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getWhetherUpgrade, 0)
            );
            if (notUpgrade != null){
                notUpgrade.setWhetherUpgrade(1);
                service.updateById(notUpgrade);
            }
            service.save(entity);
        }
        SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> queryDetail(Long id) {
    	SettlementCenterDcDrwgrpInfoEntity entity = service.selectById(id);
        SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
        //母版数据
        List<SettlementCenterBudgetSubEntity> subEntities = subService.list(
                new QueryWrapper<SettlementCenterBudgetSubEntity>().lambda()
                        .eq(SettlementCenterBudgetSubEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetSubEntity::getDr, 0)
                        .eq(SettlementCenterBudgetSubEntity::getDcDrwgrpInfo,0)
        );
        List<SettlementCenterBudgetMeasureEntity> measureEntities = measureService.list(
                new QueryWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
                        .eq(SettlementCenterBudgetMeasureEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetMeasureEntity::getDr, 0)
                        .eq(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo,0)
        );
        List<SettlementCenterBudgetOtherEntity> otherEntities = otherService.list(
                new QueryWrapper<SettlementCenterBudgetOtherEntity>().lambda()
                        .eq(SettlementCenterBudgetOtherEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetOtherEntity::getDr, 0)
                        .eq(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo,0)
        );
        List<SettlementCenterBudgetFeeEntity> feeEntities = feeService.list(
                new QueryWrapper<SettlementCenterBudgetFeeEntity>().lambda()
                        .eq(SettlementCenterBudgetFeeEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetFeeEntity::getDr, 0)
                        .eq(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo,0)
        );
        //图纸工程量数据
        List<SettlementCenterBudgetSubEntity> dcSubEntities = subService.list(
                new QueryWrapper<SettlementCenterBudgetSubEntity>().lambda()
                        .eq(SettlementCenterBudgetSubEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetSubEntity::getDr, 0)
                        .eq(SettlementCenterBudgetSubEntity::getDcDrwgrpInfo,entity.getId())
        );
        List<SettlementCenterBudgetMeasureEntity> dcMeasureEntities = measureService.list(
                new QueryWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
                        .eq(SettlementCenterBudgetMeasureEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetMeasureEntity::getDr, 0)
                        .eq(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo,entity.getId())
        );
        List<SettlementCenterBudgetOtherEntity> dcOtherEntities = otherService.list(
                new QueryWrapper<SettlementCenterBudgetOtherEntity>().lambda()
                        .eq(SettlementCenterBudgetOtherEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetOtherEntity::getDr, 0)
                        .eq(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo,entity.getId())
        );
        List<SettlementCenterBudgetFeeEntity> dcFeeEntities = feeService.list(
                new QueryWrapper<SettlementCenterBudgetFeeEntity>().lambda()
                        .eq(SettlementCenterBudgetFeeEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetFeeEntity::getDr, 0)
                        .eq(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo,entity.getId())
        );
        if (subEntities != null && subEntities.size() >0) {
            List<SettlementCenterBudgetSubVO> subVos = BeanMapper.mapList(subEntities, SettlementCenterBudgetSubVO.class);
            BigDecimal totalMny = new BigDecimal(0);//无税金额
            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
            BigDecimal totalTax = new BigDecimal(0);//税额
            BigDecimal totalOutput = new BigDecimal(0);//统计产值
            for (SettlementCenterBudgetSubVO subVo : subVos) {
                totalMny = totalMny.add(subVo.getSubMny() == null ? BigDecimal.ZERO:subVo.getSubMny());
                totalTaxMny = totalTaxMny.add(subVo.getSubTaxMny() == null ? BigDecimal.ZERO:subVo.getSubTaxMny());
                totalTax = totalTax.add(subVo.getSubTax() == null ? BigDecimal.ZERO:subVo.getSubTax());
                for (SettlementCenterBudgetSubEntity dcSubEntity : dcSubEntities) {
                    if (dcSubEntity.getParentId().equals(subVo.getId())){
                        subVo.setSettlementCenterSubMny(dcSubEntity.getSettlementCenterSubMny()  == null ? BigDecimal.ZERO:dcSubEntity.getSettlementCenterSubMny());
                        subVo.setSettlementCenterSubNum(dcSubEntity.getSettlementCenterSubNum() == null ? BigDecimal.ZERO:dcSubEntity.getSettlementCenterSubNum());
                        subVo.setSettlementCenterSubTax(dcSubEntity.getSettlementCenterSubTax() == null ? BigDecimal.ZERO:dcSubEntity.getSettlementCenterSubTax());
                        subVo.setSettlementCenterSubTaxMny(dcSubEntity.getSettlementCenterSubTaxMny() == null ? BigDecimal.ZERO:dcSubEntity.getSettlementCenterSubTaxMny());
                        totalOutput.add(dcSubEntity.getSettlementCenterSubMny());
                    }
                }
            }
            vo.setSubTotalMny(totalMny);
            vo.setSubTotalTaxMny(totalTaxMny);
            vo.setSubTotalTax(totalTax);
            vo.setSubTotalOutput(totalOutput);
            List<Map> subMap = BeanMapper.mapList(subVos, Map.class);
            for (Map map : subMap) {
                map.remove("createUserName");
            }
            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(subMap);
            subVos = BeanMapper.mapList(mapList, SettlementCenterBudgetSubVO.class);
            vo.setSubVOS(subVos);
        }
        if (measureEntities != null && measureEntities.size() >0) {
            List<SettlementCenterBudgetMeasureVO> measureVos = BeanMapper.mapList(measureEntities, SettlementCenterBudgetMeasureVO.class);
            BigDecimal totalMny = new BigDecimal(0);//无税金额
            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
            BigDecimal totalTax = new BigDecimal(0);//税额
            BigDecimal totalOutput = new BigDecimal(0);//统计产值
            for (SettlementCenterBudgetMeasureVO measureVo : measureVos) {
                totalMny = totalMny.add(measureVo.getMeasureMny()  == null ? BigDecimal.ZERO:measureVo.getMeasureMny());
                totalTaxMny = totalTaxMny.add(measureVo.getMeasureTaxMny() == null ? BigDecimal.ZERO:measureVo.getMeasureTaxMny());
                totalTax = totalTax.add(measureVo.getMeasureTax() == null ? BigDecimal.ZERO:measureVo.getMeasureTax());
                for (SettlementCenterBudgetMeasureEntity dcMeasureEntity : dcMeasureEntities) {
                    if (dcMeasureEntity.getParentId().equals(measureVo.getId())){
                        measureVo.setSettlementCenterMeasureMny(dcMeasureEntity.getSettlementCenterMeasureMny() == null ? BigDecimal.ZERO:dcMeasureEntity.getSettlementCenterMeasureMny());
                        measureVo.setSettlementCenterMeasureNum(dcMeasureEntity.getSettlementCenterMeasureNum() == null ? BigDecimal.ZERO:dcMeasureEntity.getSettlementCenterMeasureNum());
                        measureVo.setSettlementCenterMeasureTax(dcMeasureEntity.getSettlementCenterMeasureTax() == null ? BigDecimal.ZERO:dcMeasureEntity.getSettlementCenterMeasureTax());
                        measureVo.setSettlementCenterMeasureTaxMny(dcMeasureEntity.getSettlementCenterMeasureTaxMny() == null ? BigDecimal.ZERO:dcMeasureEntity.getSettlementCenterMeasureTaxMny());
                        totalOutput.add(dcMeasureEntity.getSettlementCenterMeasureMny());
                    }
                }
            }
            vo.setMeasureTotalMny(totalMny);
            vo.setMeasureTotalTaxMny(totalTaxMny);
            vo.setMeasureTotalTax(totalTax);
            vo.setMeasureTotalOutput(totalOutput);
            List<Map> measureMap = BeanMapper.mapList(measureVos, Map.class);
            for (Map map : measureMap) {
                map.remove("createUserName");
            }
            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(measureMap);
            measureVos = BeanMapper.mapList(mapList,SettlementCenterBudgetMeasureVO.class);
            vo.setMeasureVOS(measureVos);
        }
        if (otherEntities != null && otherEntities.size() >0) {
            List<SettlementCenterBudgetOtherVO> otherVos = BeanMapper.mapList(otherEntities, SettlementCenterBudgetOtherVO.class);
            BigDecimal totalMny = new BigDecimal(0);//无税金额
            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
            BigDecimal totalTax = new BigDecimal(0);//税额
            BigDecimal totalOutput = new BigDecimal(0);//统计产值
            for (SettlementCenterBudgetOtherVO otherVo : otherVos) {
                totalMny = totalMny.add(otherVo.getOtherMny() == null ? BigDecimal.ZERO:otherVo.getOtherMny());
                totalTaxMny = totalTaxMny.add(otherVo.getOtherTaxMny() == null ? BigDecimal.ZERO:otherVo.getOtherTaxMny());
                totalTax = totalTax.add(otherVo.getOtherTax() == null ? BigDecimal.ZERO:otherVo.getOtherTax());
                for (SettlementCenterBudgetOtherEntity dcOtherEntity : dcOtherEntities) {
                    if (dcOtherEntity.getParentId().equals(otherVo.getId())){
                        otherVo.setSettlementCenterOtherMny(dcOtherEntity.getSettlementCenterOtherMny() == null ? BigDecimal.ZERO:dcOtherEntity.getSettlementCenterOtherMny());
                        otherVo.setSettlementCenterOtherNum(dcOtherEntity.getSettlementCenterOtherNum() == null ? BigDecimal.ZERO:dcOtherEntity.getSettlementCenterOtherNum());
                        otherVo.setSettlementCenterOtherTax(dcOtherEntity.getSettlementCenterOtherTax() == null ? BigDecimal.ZERO:dcOtherEntity.getSettlementCenterOtherTax());
                        otherVo.setSettlementCenterOtherTaxMny(dcOtherEntity.getSettlementCenterOtherTaxMny() == null ? BigDecimal.ZERO:dcOtherEntity.getSettlementCenterOtherTaxMny());
                        totalOutput.add(dcOtherEntity.getSettlementCenterOtherMny());
                    }
                }
            }
            vo.setOtherTotalMny(totalMny);
            vo.setOtherTotalTaxMny(totalTaxMny);
            vo.setOtherTotalTax(totalTax);
            vo.setOtherTotalOutput(totalOutput);
            List<Map> otherMap = BeanMapper.mapList(otherVos, Map.class);
            for (Map map : otherMap) {
                map.remove("createUserName");
            }
            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(otherMap);
            otherVos = BeanMapper.mapList(mapList, SettlementCenterBudgetOtherVO.class);
            vo.setOtherVOS(otherVos);
        }
        if (feeEntities != null && feeEntities.size() >0) {
            List<SettlementCenterBudgetFeeVO> feeVos = BeanMapper.mapList(feeEntities, SettlementCenterBudgetFeeVO.class);
            BigDecimal totalMny = new BigDecimal(0);//无税金额
            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
            BigDecimal totalTax = new BigDecimal(0);//税额
            BigDecimal totalOutput = new BigDecimal(0);//统计产值
            for (SettlementCenterBudgetFeeVO feeVo : feeVos) {
                totalMny = totalMny.add(feeVo.getFeeMny() == null ? BigDecimal.ZERO:feeVo.getFeeMny());
                totalTaxMny = totalTaxMny.add(feeVo.getFeeTaxMny() == null ? BigDecimal.ZERO:feeVo.getFeeTaxMny());
                totalTax = totalTax.add(feeVo.getFeeTax() == null ? BigDecimal.ZERO:feeVo.getFeeTax());
                for (SettlementCenterBudgetFeeEntity dcFeeEntity : dcFeeEntities) {
                    if (dcFeeEntity.getParentId().equals(feeVo.getId())){
                        feeVo.setSettlementCenterFeeMny(dcFeeEntity.getSettlementCenterFeeMny() == null ? BigDecimal.ZERO:dcFeeEntity.getSettlementCenterFeeMny());
                        feeVo.setSettlementCenterFeeNum(dcFeeEntity.getSettlementCenterFeeNum() == null ? BigDecimal.ZERO:dcFeeEntity.getSettlementCenterFeeNum());
                        feeVo.setSettlementCenterFeeTax(dcFeeEntity.getSettlementCenterFeeTax() == null ? BigDecimal.ZERO:dcFeeEntity.getSettlementCenterFeeTax());
                        feeVo.setSettlementCenterFeeTaxMny(dcFeeEntity.getSettlementCenterFeeTaxMny() == null ? BigDecimal.ZERO:dcFeeEntity.getSettlementCenterFeeTaxMny());
                        totalOutput.add(dcFeeEntity.getSettlementCenterFeeMny());
                    }
                }
            }
            vo.setFeeTotalMny(totalMny);
            vo.setFeeTotalTaxMny(totalTaxMny);
            vo.setFeeTotalTax(totalTax);
            vo.setFeeTotalOutput(totalOutput);
            List<Map> feeMap = BeanMapper.mapList(feeVos, Map.class);
            for (Map map : feeMap) {
                map.remove("createUserName");
            }
            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(feeMap);
            feeVos = BeanMapper.mapList(mapList, SettlementCenterBudgetFeeVO.class);
            vo.setFeeVOS(feeVos);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterDcDrwgrpInfoVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SettlementCenterDcDrwgrpInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettlementCenterDcDrwgrpInfoVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SettlementCenterDcDrwgrpInfoEntity> page = service.queryPage(param,false);
        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettlementCenterDcDrwgrpInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterDcDrwgrpInfo-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSettlementCenterDcDrwgrpInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> refSettlementCenterDcDrwgrpInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementCenterDcDrwgrpInfoEntity> page = service.queryPage(param,false);
        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
