package com.ejianc.business.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

@Service("settlementCenterDcDrwgrpInfo") 
public class SettlementCenterDcDrwgrpInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private ISettlementCenterDcDrwgrpInfoService service;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		service.update(
				new UpdateWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
						.eq(SettlementCenterDcDrwgrpInfoEntity::getId,billId)
						.set(SettlementCenterDcDrwgrpInfoEntity::getSecondNodeTime,new Date())
						.set(SettlementCenterDcDrwgrpInfoEntity::getFlowState, SettleFlowStateEnum.THREE.getCode())
						.set(SettlementCenterDcDrwgrpInfoEntity::getFlowStateName,SettleFlowStateEnum.THREE.getName())
		);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		if ("node_a".equals(sign)){
			service.update(
					new UpdateWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
							.eq(SettlementCenterDcDrwgrpInfoEntity::getId,billId)
							.set(SettlementCenterDcDrwgrpInfoEntity::getThirdNodeTime,new Date())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowState, SettleFlowStateEnum.FOUR.getCode())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowStateName,SettleFlowStateEnum.FOUR.getName())
			);
		}else if ("node_b".equals(sign)){
			service.update(
					new UpdateWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
							.eq(SettlementCenterDcDrwgrpInfoEntity::getId,billId)
							.set(SettlementCenterDcDrwgrpInfoEntity::getFourthNodeTime,new Date())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowState, SettleFlowStateEnum.FIVE.getCode())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowStateName,SettleFlowStateEnum.FIVE.getName())
			);
		}else if ("node_c".equals(sign)){
			service.update(
					new UpdateWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
							.eq(SettlementCenterDcDrwgrpInfoEntity::getId,billId)
							.set(SettlementCenterDcDrwgrpInfoEntity::getFifthNodeTime,new Date())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowState, SettleFlowStateEnum.SIX.getCode())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowStateName,SettleFlowStateEnum.SIX.getName())
			);
		}else if ("node_d".equals(sign)){
			service.update(
					new UpdateWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
							.eq(SettlementCenterDcDrwgrpInfoEntity::getId,billId)
							.set(SettlementCenterDcDrwgrpInfoEntity::getSixthNodeTime,new Date())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowState, SettleFlowStateEnum.SEVEN.getCode())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowStateName,SettleFlowStateEnum.SEVEN.getName())
			);
		}else if ("node_e".equals(sign)){
			service.update(
					new UpdateWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
							.eq(SettlementCenterDcDrwgrpInfoEntity::getId,billId)
							.set(SettlementCenterDcDrwgrpInfoEntity::getSeventhNodeTime,new Date())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowState, SettleFlowStateEnum.EIGHT.getCode())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowStateName,SettleFlowStateEnum.EIGHT.getName())
			);
		}else if ("node_f".equals(sign)){
			service.update(
					new UpdateWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
							.eq(SettlementCenterDcDrwgrpInfoEntity::getId,billId)
							.set(SettlementCenterDcDrwgrpInfoEntity::getEighthNodeTime,new Date())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowState, SettleFlowStateEnum.NINE.getCode())
							.set(SettlementCenterDcDrwgrpInfoEntity::getFlowStateName,SettleFlowStateEnum.NINE.getName())
			);
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
