package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.vo.SettlementCenterAlertInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 预警信息表
 *
 * @author generator
 */
@Controller
@RequestMapping("settlementCenterAlertInfo")
public class SettlementCenterAlertInfoController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettlementCenterAlertInfoService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterAlertInfoVO> saveOrUpdate(@RequestBody SettlementCenterAlertInfoVO saveOrUpdateVO) {
        SettlementCenterAlertInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterAlertInfoEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SettlementCenterAlertInfoVO vo = BeanMapper.map(entity, SettlementCenterAlertInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCenterAlertInfoVO> queryDetail(Long id) {
        SettlementCenterAlertInfoEntity entity = service.selectById(id);
        SettlementCenterAlertInfoVO vo = BeanMapper.map(entity, SettlementCenterAlertInfoVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 预警消除功能
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterAlertInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettlementCenterAlertInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettlementCenterAlertInfoVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterAlertInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//
//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache = sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        } else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if (5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SettlementCenterAlertInfoEntity> page = service.queryPage(param, false);
        IPage<SettlementCenterAlertInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterAlertInfoVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettlementCenterAlertInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterAlertInfo-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettlementCenterAlertInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterAlertInfoVO>> refSettlementCenterAlertInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                               String condition,
                                                                                               String searchObject,
                                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementCenterAlertInfoEntity> page = service.queryPage(param, false);
        IPage<SettlementCenterAlertInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterAlertInfoVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 工作响应迟缓预警
     * 1.工作任务提交截止时间前24h,系统推送提醒。
     * 2.工作任务提交截止时间仍未提交,系统推送催交通知。
     * <p>
     * 统计人员id   统计人员name  卷册code   卷册name   期望完成时间  预警状态
     */
    @Scheduled(cron = "0 0 0 * * ?")
    public void getWarning() {
        // 所有需要预警的数据列表，每个对象有desired_time字段
        List<SettlementCenterDcDrwgrpInfoEntity> alertList = infoService.getAllEarlyWarning();
        //循环获取每条数据,进行处理
        for (SettlementCenterDcDrwgrpInfoEntity alert : alertList) {
            //获取desiredTime期望完成时间
            Date desiredTime = alert.getDesiredTime();
            // 将Date转换为LocalDateTime
            LocalDateTime localDateTime = desiredTime.toInstant()
                    .atZone(ZoneId.systemDefault())
                    .toLocalDateTime();
            LocalDateTime alertTime = localDateTime.minusHours(24);
            if (LocalDateTime.now().isAfter(alertTime)) {
                // 工作任务提交截止时间前24h,系统推送提醒
                service.saveLastAlert(alert);
            } else if (localDateTime.isBefore(LocalDateTime.now())) {
                //工作任务提交截止时间仍未提交,系统推送催交通知
                service.saveNowAlert(alert);
            }
        }
    }

    /**
     * 根据结算中心职员id获取自己的预警
     *
     * @param id
     * @return
     */
//    @RequestMapping(value = "/queryIsAlert", method = RequestMethod.GET)
//    @ResponseBody
//    public Integer queryIsAlert(Long id) {
//        //通过统计人员id从预警表获取数据
//        return service.selectByUserId(id);
//        //查看预警状态是否需要预警,返回预警类型(0,1)
//        //需要就返回0
//        //不需要返回1



    }

