package com.ejianc.business.settle.service.impl;

import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.mapper.SettlementCenterAlertInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 预警信息表
 *
 * @author generator
 */
@Service("settlementCenterAlertInfoService")
public class SettlementCenterAlertInfoServiceImpl extends BaseServiceImpl<SettlementCenterAlertInfoMapper, SettlementCenterAlertInfoEntity> implements ISettlementCenterAlertInfoService {

    @Autowired
    private SettlementCenterAlertInfoMapper mapper;

    @Override
    public void saveLastAlert(SettlementCenterDcDrwgrpInfoEntity alert) {
        SettlementCenterAlertInfoEntity entity = new SettlementCenterAlertInfoEntity();
        entity.setAlertLastTime(new Date());
        entity.setProjectId(alert.getProjectId());
        entity.setAlertType(0);
        entity.setSettlementCenterMajor(alert.getSettlementCenterMajor());
        entity.setDcDrwgrpInfoName(alert.getDcDrwgrpInfoName());
        entity.setProjectCode(alert.getProjectCode());
        entity.setProjectName(alert.getProjectName());
        entity.setThirdNodeUserId(alert.getThirdNodeUserId());
        entity.setThirdNodeUserName(alert.getThirdNodeUserName());
        this.saveOrUpdate(entity);
    }

    @Override
    public List<SettlementCenterAlertInfoEntity> selectByUserId(Long id) {
        return mapper.selectAlertList(id);
    }

    @Override
    public void saveNowAlert(SettlementCenterDcDrwgrpInfoEntity alert) {
        SettlementCenterAlertInfoEntity entity = new SettlementCenterAlertInfoEntity();
        entity.setAlertNowTime(new Date());
        entity.setProjectId(alert.getProjectId());
        entity.setAlertType(1);
        entity.setSettlementCenterMajor(alert.getSettlementCenterMajor());
        entity.setDcDrwgrpInfoName(alert.getDcDrwgrpInfoName());
        entity.setProjectCode(alert.getProjectCode());
        entity.setProjectName(alert.getProjectName());
        entity.setThirdNodeUserId(alert.getThirdNodeUserId());
        entity.setThirdNodeUserName(alert.getThirdNodeUserName());
        this.saveOrUpdate(entity);
    }


}
