package com.ejianc.business.settle.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.jacoco.agent.rt.internal_035b120.core.internal.flow.IFrame;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("projectStatistics")
public class ProjectStatisticsController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;
    @Autowired
    private IDefdocApi iDefdocApi;

    @RequestMapping(value = "/statisticalData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse statisticalData(Long projectId) {
        Map<String, Object> resultMap = new HashMap<>();
        CommonResponse<List<DefdocDetailVO>> defdoc = iDefdocApi.getDefDocByDefCode("settlement_center_drwgrp_type");
        Long defdocDetailId = defdoc.getData().stream().filter(a -> a.getName().equals("不需要统计")).map(DefdocDetailVO::getId).findFirst().orElse(null);
        if (defdocDetailId == null){
            return CommonResponse.error("自定义档案错误");
        }
        int needStatistCount = dcDrwgrpInfoService.count(
                new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDiscriminateState, defdocDetailId)
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectId)
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
        );

        int finishCount = dcDrwgrpInfoService.count(
                new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                        .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectId)
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
        );

        int allCount = dcDrwgrpInfoService.count(
                new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectId)
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
        );

        Map<String, BigDecimal> map = infoMapper.selectSumOutput(projectId);
        BigDecimal sumOutput = new BigDecimal(0);
        if (map != null){
            sumOutput = map.get("sumOutput");
        }

        resultMap.put("needStatistCount",needStatistCount);//需统计卷册份数
        resultMap.put("finishCount",finishCount);//已完成统计卷册份数
        //卷册统计完成率
        if (allCount != 0) {
            resultMap.put("finishRate", (finishCount + 0.00) / allCount);
        }else {
            resultMap.put("finishRate", 1);
        }
        resultMap.put("sumOutput",sumOutput);//累计完成统计产值
        return CommonResponse.success(resultMap);
    }

    /**
     * @Description 项目工程量统计一览表- 工作任务完成情况清单 -未完成
     * @Return
     */
    @RequestMapping(value = "/queryProjectJobUndoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoEntity>> queryProjectJobUndoneList(Long projectId, Integer pageNum, Integer pageSize) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNum);
        queryParam.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.NINE.getCode()));
        queryParam.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.TWO.getCode()));
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, projectId));
        IPage<SettlementCenterDcDrwgrpInfoEntity> page = dcDrwgrpInfoService.queryPage(queryParam);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Description 项目工程量统计一览表- 工作任务完成情况清单 -已完成
     * @Return
     */
    @RequestMapping(value = "/queryProjectJobDoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoEntity>> queryProjectJobDoneList(Long projectId, Integer pageNum, Integer pageSize) {



        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNum);
        queryParam.getParams().put("flowState",new Parameter(QueryParam.SQL, "(flow_state = 9 or flow_state = 2)"));
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, projectId));
        IPage<SettlementCenterDcDrwgrpInfoEntity> page = dcDrwgrpInfoService.queryPage(queryParam);


        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param
     * @Description 工作任务完成情况清单导出(未完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportUndone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportUndone(Long projectId, HttpServletResponse response, Integer pageNum, Integer pageSize) {
        Map<String, Object> beans = new HashMap<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.NINE.getCode()));
        queryParam.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.TWO.getCode()));
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, projectId));
        List<SettlementCenterDcDrwgrpInfoEntity> list = dcDrwgrpInfoService.queryList(queryParam);

        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 工作任务完成情况清单导出(已完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportDone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDone(Long projectId, HttpServletResponse response, Integer pageNum, Integer pageSize) {
        Map<String, Object> beans = new HashMap<>();

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("flowState",new Parameter(QueryParam.SQL, "(flow_state = 9 or flow_state = 2)"));
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, projectId));
        List<SettlementCenterDcDrwgrpInfoEntity> list = dcDrwgrpInfoService.queryList(queryParam);

        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }
}
