package com.ejianc.business.settle.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 专业工程量统计一览表
 *
 * @author generator
 */
@Controller
@RequestMapping("majorQuantitiesInfo")
public class MajorQuantitiesInfoController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;

    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;

    @Autowired
    private IOrgApi iOrgApi;


    /**
     * @Description 专业工程量统计一览表- 14个类型统计数据展示
     * @Return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse queryList(Long major,String orgId) {

        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(orgId)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        LambdaQueryWrapper<SettlementCenterDcDrwgrpInfoEntity> queryWrapper = new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                .eq(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, major);
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            queryWrapper = new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                    .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, major)
                    .in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId,commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            queryWrapper = new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                    .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, major)
                    .in(SettlementCenterDcDrwgrpInfoEntity::getOrgId,departmentIds);
        }
        Map<String, Object> resultMap = new HashMap<>();

        List<SettlementCenterDcDrwgrpInfoEntity> list = infoService.list(queryWrapper);
        BigDecimal totalOutputForYear = new BigDecimal(0);//本年累计完成统计产值
        BigDecimal totalOutputForLastMonth = new BigDecimal(0);//上月完成统计产值
        BigDecimal totalOutputForMonth = new BigDecimal(0);//月至今完成统计产值
        List<SettlementCenterDcDrwgrpInfoEntity> finishedForLastMonth = new ArrayList<>();//图纸完成率-上月完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForLastMonth = new ArrayList<>();//图纸完成率-计划上月完成
        List<SettlementCenterDcDrwgrpInfoEntity> finishForMonth = new ArrayList<>();//图纸完成率-本月至今完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForMonth = new ArrayList<>();//图纸完成率-本本月至今计划完成
        List<SettlementCenterDcDrwgrpInfoEntity> distributedForYear = new ArrayList<>();//本年已派发卷册
        List<SettlementCenterDcDrwgrpInfoEntity> finishedForYear = new ArrayList<>();//本年已完成

        Map<Integer, BigDecimal> outputEveryMonth = new HashMap<>();//所有有数据月份
        //数据筛选
        for (SettlementCenterDcDrwgrpInfoEntity entity : list) {
            //已完成统计
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                Date finishDate = entity.getEighthNodeTime();

                //本年完成统计
                if (DateUtil.year(finishDate) == DateUtil.thisYear()) {
                    totalOutputForYear = totalOutputForYear.add(entity.getStatisticalOutput());
                    Integer month = DateUtil.month(finishDate) + 1;
                    if (outputEveryMonth.get(month) == null) {
                        outputEveryMonth.put(month, entity.getStatisticalOutput());
                    } else {
                        outputEveryMonth.put(month, outputEveryMonth.get(month).add(entity.getStatisticalOutput()));
                    }
                }
                //本月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    totalOutputForMonth = totalOutputForMonth.add(entity.getStatisticalOutput());
                }
                //上月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    totalOutputForLastMonth = totalOutputForLastMonth.add(entity.getStatisticalOutput());
                }
            }

            //已完成卷册
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())
                    || entity.getFlowStateName().equals(SettleFlowStateEnum.TWO.getName())) {
                Date distributedDate = entity.getSecondNodeTime();//派发日期
                Date finishDate = null;
                if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                    finishDate = entity.getEighthNodeTime();
                } else {
                    finishDate = entity.getFifthNodeTime();
                }
                Date planFinishDate = entity.getDesiredTime();
                //本年已派发
                if (DateUtil.year(distributedDate) == DateUtil.thisYear()) {
                    distributedForYear.add(entity);
                }
                //本年已完成
                if (DateUtil.year(finishDate) == DateUtil.thisYear()) {
                    finishedForYear.add(entity);
                }

                //本月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    finishForMonth.add(entity);
                }
                //上月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    finishedForLastMonth.add(entity);
                }

                //本月计划完成
                if (DateUtil.beginOfMonth(planFinishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    planFinishForMonth.add(entity);
                }
                //上月计划完成
                if (DateUtil.beginOfMonth(planFinishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    planFinishForLastMonth.add(entity);
                }
            }
        }


        resultMap.put("totalOutputForYear", totalOutputForYear);//本年累计完成统计产值
        resultMap.put("totalOutputForLastMonth", totalOutputForLastMonth);//上月完成统计产值
        resultMap.put("totalOutputForMonth", totalOutputForMonth);//月至今完成统计产值


        // 已派发累计完成统计产值
        int distributedCount = distributedForYear.size();
        // 本年累计完成
        int finishedCount = finishedForYear.size();
        String ratio;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratio = finishedCount + "/" + distributedCount;
        } else {
            // 如已派发数量为0，设定默认值
            ratio = "0/" + finishedCount;
        }
        resultMap.put("yearCompletionRatio", ratio);


        // 上月完成
        int size = finishedForLastMonth.size();
        // 计划上月完成卷册份数
        int sizeLastMonth = planFinishForLastMonth.size();
        String ratioTwo;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratioTwo = size + "/" + sizeLastMonth;
        } else {
            // 如已派发数量为0，设定默认值
            ratioTwo = "0/" + size;
        }
        resultMap.put("lastMonthCompletionRatio", ratioTwo);

        // 本月至今
        int size2 = finishForMonth.size();
        // 计划上月完成卷册份数
        int sizeThisMonth = planFinishForMonth.size();
        String ratioThree;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratioThree = size2 + "/" + sizeThisMonth;
        } else {
            // 如已派发数量为0，设定默认值
            ratioThree = "0/" + size2;
        }
        resultMap.put("thisMonthCompletionRatio", ratioThree);


        //预警:本年,上月,本月
        int alertYear = 0;//预警数量本年数量
        int alertLastMonth = 0;//预警数量上月数量
        int alertThisMonth = 0;//预警数量本月数量


        List<SettlementCenterAlertInfoEntity> result = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            result = alertInfoService.selectByUserId(null, major,departmentIds,commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            result = alertInfoService.selectByUserId(null, major,departmentIds,commonOrgIds);
        }



        for (SettlementCenterAlertInfoEntity entity : result) {
            Date time = entity.getCreateTime();
            if (DateUtil.year(time) == DateUtil.thisYear()) {
                alertYear += 0;
            }
            //本月完成
            if (DateUtil.beginOfMonth(time).equals(DateUtil.beginOfMonth(new Date()))) {
                alertLastMonth += 0;
            }
            //上月完成
            if (DateUtil.beginOfMonth(time).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                alertThisMonth += 0;
            }

        }

        //预警
        resultMap.put("alertYear", alertYear);
        resultMap.put("alertLastMonth", alertLastMonth);
        resultMap.put("alertThisMonth", alertThisMonth);


        //完成率

        int size1 = finishedForYear.size();
        int size4 = finishForMonth.size();
        int size5 = finishedForLastMonth.size();
        int size3 = list.size();

        if (size3 == 0) {
            System.out.println("总任务数量为0，无法计算完成率！");
        } else {
            // 计算完成率，结果为0到1之间的小数
            double completionRate = (double) size1 / size3;

            // 如果你想以百分比形式展示，可以乘以100
            double completionRatePercentage = completionRate * 100;
            resultMap.put("rateYear", completionRatePercentage);  //本年完成率


            double completionRate2 = (double) size4 / size3;
            double completionRatePercentage2 = completionRate2 * 100;
            resultMap.put("rateThisMonth", completionRatePercentage2);//本月完成率


            double completionRate3 = (double) size5 / size3;
            double completionRatePercentage3 = completionRate3 * 100;
            resultMap.put("rateLastMonth", completionRatePercentage3);//上月完成率


            // 防止除数为0的情况
            if (completionRatePercentage3 == 0) {
                System.out.println("上月完成率为0，无法计算增幅！");
                resultMap.put("completeRate", null);//完成率上月增幅

            } else {
                // 计算增幅
                double increaseRate2 = ((double) (completionRatePercentage2 - completionRatePercentage3) / completionRatePercentage3) * 100;

                resultMap.put("completeRate", increaseRate2);//完成率上月增幅
            }
        }


        //上月增幅


        // 防止除数为0的情况
        if (alertLastMonth == 0) {
            System.out.println("上月预警数为0，无法计算增幅！");
            resultMap.put("alertRate", null);//预警上月增幅

        } else {
            // 计算增幅
            double increaseRate = ((double) (alertThisMonth - alertLastMonth) / alertLastMonth) * 100;

            resultMap.put("alertRate", increaseRate);//预警上月增幅

        }


        // 防止除数为0的情况
        if (totalOutputForLastMonth.equals(BigDecimal.ZERO)) {
            System.out.println("上月统计产值为0，无法计算增幅！");
            resultMap.put("outputRate", null);//统计产值上月增幅

        } else {
            // 计算增幅
            BigDecimal divide = (totalOutputForMonth.subtract(totalOutputForLastMonth)).divide(totalOutputForLastMonth,2, RoundingMode.HALF_DOWN);
            resultMap.put("outputRate", divide);//统计产值上月增幅
        }

        // 防止除数为0的情况
        if (size == 0) {
            System.out.println("上月卷册数为0，无法计算增幅！");
            resultMap.put("volumeRate", null);//卷册份数上月增幅
        } else {
            // 计算增幅
            double increaseRate = ((double) (size2 - size) / size) * 100;
            resultMap.put("volumeRate", increaseRate);//卷册份数上月增幅

        }


        //上月图纸完成计划率
        if (planFinishForLastMonth.size() == 0) {
        } else {
        }
        //本月至今图纸完成计划率
        if (planFinishForMonth.size() == 0) {
            resultMap.put("finishRateForMonth", 100);
        } else {
            resultMap.put("finishRateForMonth", (finishForMonth.size() + 0.00) / planFinishForMonth.size());
        }
        return CommonResponse.success(resultMap);
    }


    /**
     * @Description 专业工程量统计一览表- 工程量统计产值动态图
     * @Return
     */
    @RequestMapping(value = "/queryActionMap", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, BigDecimal>>> queryActionMap(Long thirdNodeUserId, Long major) {
        List<Map<String, BigDecimal>> result = infoMapper.selectActionMap(null, major);
        return CommonResponse.success("查询列表数据成功！", result);
    }


    /**
     * @Description 专业工程量统计一览表- 本年工作任务完成情况清单 -未完成
     * @Return
     */
    @RequestMapping(value = "/queryMajorJobUndoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryMajorJobUndoneList(@RequestBody QueryParam param) {
        Parameter orgParam = param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(orgId)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");//项目名称
        fuzzyFields.add("thirdNodeUserId");//统计人
        fuzzyFields.add("fourthNodeUserName");//责任人
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.TWO.getCode()));

        param.getParams().put("flowState", new Parameter(QueryParam.NE, SettleFlowStateEnum.NINE.getCode()));
        param.setPageSize(1);
        IPage<SettlementCenterDcDrwgrpInfoEntity> page = infoService.queryPage(param, false);

        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));


        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 专业工程量统计一览表- 本年工作任务完成情况清单 -已完成
     * @Return
     */
    @RequestMapping(value = "/queryMajorJobDoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryMajorJobDoneList(@RequestBody QueryParam param) {
        Parameter orgParam = param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(orgId)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");//项目名称
        fuzzyFields.add("thirdNodeUserId");//统计人
        fuzzyFields.add("fourthNodeUserName");//责任人
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("flowState",new Parameter(QueryParam.SQL, "(flow_state = 9 or flow_state = 2)"));
        param.setPageSize(1);
        IPage<SettlementCenterDcDrwgrpInfoEntity> page = infoService.queryPage(param, false);

        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));


        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param
     * @Description 本年工作任务完成情况清单导出(未完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportUndone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportUndone(Long major, HttpServletResponse response, @RequestBody QueryParam param) {
        Parameter orgParam = param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(orgId)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }
        Map<String, Object> beans = new HashMap<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("projectName");//项目名称
//        fuzzyFields.add("thirdNodeUserId");//统计人
//        fuzzyFields.add("fourthNodeUserName");//责任人
//      param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("flowState", new Parameter(QueryParam.NE, SettleFlowStateEnum.NINE.getCode()));
        param.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.TWO.getCode()));
//        param.setPageSize(1);
        List<SettlementCenterDcDrwgrpInfoEntity> list = infoService.queryList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            List<SettlementCenterDcDrwgrpInfoEntity> collect = list.stream()
                    .filter(entiy -> entiy != null && entiy.getSettlementCenterMajor() != null && entiy.getSettlementCenterMajor().equals(major))
                    .collect(Collectors.toList());
//            List<SettlementCenterDcDrwgrpInfoEntity> collect = list.stream().filter(entiy -> entiy.getSettlementCenterMajor().equals(major)).collect(Collectors.toList());

            beans.put("records", collect);
        }

        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 本年工作任务完成情况清单导出(已完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportDone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDone(Long major, HttpServletResponse response, @RequestBody QueryParam param) {
        Parameter orgParam = param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(orgId)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }
        Map<String, Object> beans = new HashMap<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("projectName");//项目名称
//        fuzzyFields.add("thirdNodeUserId");//统计人
//        fuzzyFields.add("fourthNodeUserName");//责任人
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("flowState",new Parameter(QueryParam.SQL, "(flow_state = 9 or flow_state = 2)"));
        param.setPageSize(1);
        List<SettlementCenterDcDrwgrpInfoEntity> list = infoService.queryList(param);
        List<SettlementCenterDcDrwgrpInfoEntity> collect = list.stream().filter(entiy -> entiy.getSettlementCenterMajor().equals(major)).collect(Collectors.toList());

        beans.put("records", collect);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }


    @RequestMapping(value = "/getRankingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse getRankingList(Long major,String orgId) {
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(orgId)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        Map<String, Object> resultMap = new HashMap<>();
        List<Map> rankingListForYear = infoService.getRankingListForYear(major,departmentIds,commonOrgIds);
        List<Map> rankingListForMonth = infoService.getRankingListForMonth(major,departmentIds,commonOrgIds);
        resultMap.put("rankingListForYear", rankingListForYear);
        resultMap.put("rankingListForMonth", rankingListForMonth);
        return CommonResponse.success(resultMap);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
