package com.ejianc.business.settle.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * 工程量统计总览
 */
@Controller
@RequestMapping("overview")
public class OverviewController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;

    @RequestMapping(value = "/statisticalData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse statisticalData(){
        Map<String, Object> resultMap = new HashMap<>();
        List<SettlementCenterDcDrwgrpInfoEntity> list = dcDrwgrpInfoService.list(
                new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDr,0)
        );
        BigDecimal totalOutputForYear = new BigDecimal(0);//本年累计完成统计产值
        BigDecimal totalOutputForLastMonth = new BigDecimal(0);//上月完成统计产值
        BigDecimal totalOutputForMonth = new BigDecimal(0);//月至今完成统计产值
        List<SettlementCenterDcDrwgrpInfoEntity> distributedForYear = new ArrayList<>();//本年已派发卷册
        List<SettlementCenterDcDrwgrpInfoEntity> finishedForYear = new ArrayList<>();//本年已完成
        List<SettlementCenterDcDrwgrpInfoEntity> finishedForLastMonth = new ArrayList<>();//上月完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForLastMonth = new ArrayList<>();//计划上月完成
        List<SettlementCenterDcDrwgrpInfoEntity> finishForMonth = new ArrayList<>();//本月至今完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForMonth = new ArrayList<>();//本月至今计划完成
        List<SettlementCenterDcDrwgrpInfoEntity> statisticalFinishForMonth = new ArrayList<>();//本月完成统计
        List<SettlementCenterDcDrwgrpInfoEntity> statisticalFinishForYear = new ArrayList<>();//本年完成统计


        Map<Integer,BigDecimal> outputEveryMonth = new HashMap<>();//所有有数据月份
        //数据筛选
        for (SettlementCenterDcDrwgrpInfoEntity entity : list) {
            //已完成统计
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())){
                Date finishDate = entity.getEighthNodeTime();

                //本年完成统计
                if (DateUtil.year(finishDate) == DateUtil.thisYear()){
                    totalOutputForYear = totalOutputForYear.add(entity.getStatisticalOutput());
                    statisticalFinishForYear.add(entity);
                    Integer month = DateUtil.month(finishDate) + 1;
                    if (outputEveryMonth.get(month) == null){
                        outputEveryMonth.put(month,entity.getStatisticalOutput());
                    }else {
                        outputEveryMonth.put(month,outputEveryMonth.get(month).add(entity.getStatisticalOutput()));
                    }
                }
                //本月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(new Date()))){
                    totalOutputForMonth = totalOutputForMonth.add(entity.getStatisticalOutput());
                    statisticalFinishForMonth.add(entity);
                }
                //上月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))){
                    totalOutputForLastMonth = totalOutputForLastMonth.add(entity.getStatisticalOutput());
                }
            }

            //已完成卷册
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())
                    || entity.getFlowStateName().equals(SettleFlowStateEnum.TWO.getName())){
                Date distributedDate = entity.getThirdNodeTime();//派发日期
                Date finishDate = null;
                if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())){
                    finishDate = entity.getEighthNodeTime();
                }else {
                    finishDate = entity.getFifthNodeTime();
                }
                Date planFinishDate = entity.getDesiredTime();

                //本年已完成
                if (DateUtil.year(finishDate) == DateUtil.thisYear()){
                    finishedForYear.add(entity);
                }

                //本月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(new Date()))){
                    finishForMonth.add(entity);
                }
                //上月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))){
                    finishedForLastMonth.add(entity);
                }

                //本月计划完成
                if (DateUtil.beginOfMonth(planFinishDate).equals(DateUtil.beginOfMonth(new Date()))){
                    planFinishForMonth.add(entity);
                }
                //上月计划完成
                if (DateUtil.beginOfMonth(planFinishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))){
                    planFinishForLastMonth.add(entity);
                }
            }

            Date distributedDate = entity.getThirdNodeTime();//派发日期
            if (distributedDate != null) {
                //本年已派发
                if (DateUtil.year(distributedDate) == DateUtil.thisYear()) {
                    distributedForYear.add(entity);
                }
            }

        }


        resultMap.put("totalOutputForYear",totalOutputForYear);//本年累计完成统计产值
        resultMap.put("totalOutputForLastMonth",totalOutputForLastMonth);//上月完成统计产值
        resultMap.put("totalOutputForMonth",totalOutputForMonth);//月至今完成统计产值
        resultMap.put("distributedForYearCount",distributedForYear.size());//本年已派发卷册
        resultMap.put("finishedForYearCount",finishedForYear.size());//本年已完成
        resultMap.put("finishedForLastMonthCount",finishedForLastMonth.size());//上月完成
        resultMap.put("planFinishForLastMonthCount",planFinishForLastMonth.size());//计划上月完成
        resultMap.put("finishForMonthCount",finishForMonth.size());//本月至今完成
        resultMap.put("planFinishForMonthCount",planFinishForMonth.size());//本月至今计划完成
        //上月图纸完成计划率
        if (planFinishForLastMonth.size() == 0) {
            resultMap.put("finishRateForLastMonth", 1);
        }else {
            resultMap.put("finishRateForLastMonth",(finishedForLastMonth.size()+0.00)/planFinishForLastMonth.size());
        }
        //本月至今图纸完成计划率
        if (planFinishForMonth.size() == 0) {
            resultMap.put("finishRateForMonth", 1);
        }else {
            resultMap.put("finishRateForMonth",(finishForMonth.size()+0.00)/planFinishForMonth.size());
        }
        resultMap.put("outputEveryMonth",outputEveryMonth);//工程量统计产值动态图

        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value = "/getRankingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse getRankingList() {
        Map<String, Object> resultMap = new HashMap<>();
        List<Map> rankingListForYear = dcDrwgrpInfoService.getRankingListForYear(null,null,null);
        List<Map> rankingListForMonth = dcDrwgrpInfoService.getRankingListForMonth(null,null,null);
        resultMap.put("rankingListForYear",rankingListForYear);
        resultMap.put("rankingListForMonth",rankingListForMonth);
        return CommonResponse.success(resultMap);
    }
}
