package com.ejianc.business.settle.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterUserProjectDetailEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterUserProjectDetailService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * 本人工程量统计一览表
 *
 * @author generator
 */
@Controller
@RequestMapping("personQuantitiesInfo")
public class PersonQuantitiesInfoController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;

    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;

    @Autowired
    private ISettlementCenterUserProjectDetailService projectDetailService;


    /**
     * @Description 本人工程量统计一览表- 14个类型统计数据展示
     * @Return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse queryList(Long thirdNodeUserId) {

        Map<String, Object> resultMap = new HashMap<>();
        List<SettlementCenterDcDrwgrpInfoEntity> list = infoService.list(
                new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                        .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                        .like(SettlementCenterDcDrwgrpInfoEntity::getThirdNodeUserId, thirdNodeUserId)
        );
        BigDecimal totalOutputForYear = new BigDecimal(0);//本年累计完成统计产值
        BigDecimal totalOutputForLastMonth = new BigDecimal(0);//上月完成统计产值
        BigDecimal totalOutputForMonth = new BigDecimal(0);//月至今完成统计产值
        List<SettlementCenterDcDrwgrpInfoEntity> finishedForLastMonth = new ArrayList<>();//图纸完成率-上月完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForLastMonth = new ArrayList<>();//图纸完成率-计划上月完成
        List<SettlementCenterDcDrwgrpInfoEntity> finishForMonth = new ArrayList<>();//图纸完成率-本月至今完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForMonth = new ArrayList<>();//图纸完成率-本本月至今计划完成
        List<SettlementCenterDcDrwgrpInfoEntity> distributedForYear = new ArrayList<>();//本年已派发卷册
        List<SettlementCenterDcDrwgrpInfoEntity> finishedForYear = new ArrayList<>();//本年已完成


        Map<Integer, BigDecimal> outputEveryMonth = new HashMap<>();//所有有数据月份
        //数据筛选
        for (SettlementCenterDcDrwgrpInfoEntity entity : list) {
            //已完成统计
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                List<SettlementCenterUserProjectDetailEntity> userProjectDetailEntities = projectDetailService.list(
                        new QueryWrapper<SettlementCenterUserProjectDetailEntity>().lambda()
                                .eq(SettlementCenterUserProjectDetailEntity::getDr, 0)
                                .eq(SettlementCenterUserProjectDetailEntity::getDcDrwgrpInfo, entity.getId())
                                .eq(SettlementCenterUserProjectDetailEntity::getUserId, thirdNodeUserId)
                );
                BigDecimal statisticalOutput = BigDecimal.ZERO;
                for (SettlementCenterUserProjectDetailEntity userProjectDetailEntity : userProjectDetailEntities) {
                    BigDecimal mny = userProjectDetailEntity.getSettlementCenterFeeTaxMny();
                    statisticalOutput.add(mny == null ? BigDecimal.ZERO : mny);
                }
                Date finishDate = entity.getEighthNodeTime();

                //本年完成统计
                if (DateUtil.year(finishDate) == DateUtil.thisYear()) {
                    totalOutputForYear = totalOutputForYear.add(entity.getStatisticalOutput());
                    Integer month = DateUtil.month(finishDate) + 1;
                    if (outputEveryMonth.get(month) == null) {
                        outputEveryMonth.put(month, statisticalOutput);
                    } else {
                        outputEveryMonth.put(month, outputEveryMonth.get(month).add(statisticalOutput));
                    }
                }
                //本月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    totalOutputForMonth = totalOutputForMonth.add(statisticalOutput);
                }
                //上月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    totalOutputForLastMonth = totalOutputForLastMonth.add(statisticalOutput);
                }
            }

            //已完成卷册
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())
                    || entity.getFlowStateName().equals(SettleFlowStateEnum.TWO.getName())) {
                Date distributedDate = entity.getSecondNodeTime();//派发日期
                Date finishDate = null;
                if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                    finishDate = entity.getEighthNodeTime();
                } else {
                    finishDate = entity.getFifthNodeTime();
                }
                Date planFinishDate = entity.getDesiredTime();
                //本年已派发
                if (DateUtil.year(distributedDate) == DateUtil.thisYear()) {
                    distributedForYear.add(entity);
                }
                //本年已完成
                if (DateUtil.year(finishDate) == DateUtil.thisYear()) {
                    finishedForYear.add(entity);
                }

                //本月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    finishForMonth.add(entity);
                }
                //上月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    finishedForLastMonth.add(entity);
                }

                //本月计划完成
                if (DateUtil.beginOfMonth(planFinishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    planFinishForMonth.add(entity);
                }
                //上月计划完成
                if (DateUtil.beginOfMonth(planFinishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    planFinishForLastMonth.add(entity);
                }
            }
        }


        resultMap.put("totalOutputForYear", totalOutputForYear);//本年累计完成统计产值
        resultMap.put("totalOutputForLastMonth", totalOutputForLastMonth);//上月完成统计产值
        resultMap.put("totalOutputForMonth", totalOutputForMonth);//月至今完成统计产值
        resultMap.put("rankYear", planFinishForMonth.size());//本年至今产值排名
        resultMap.put("rankLastMonth", planFinishForMonth.size());//上月产值排名
        resultMap.put("rankThisMonth", planFinishForMonth.size());//本月至今产值排名


        // 已派发累计完成统计产值
        int distributedCount = distributedForYear.size();
        // 本年累计完成
        int finishedCount = finishedForYear.size();
        String ratio;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratio = finishedCount + "/" + distributedCount;
        } else {
            // 如已派发数量为0，设定默认值
            ratio = "0/" + finishedCount;
        }
        resultMap.put("yearCompletionRatio", ratio);


        // 上月完成
        int size = finishedForLastMonth.size();
        // 计划上月完成卷册份数
        int sizeLastMonth = planFinishForLastMonth.size();
        String ratioTwo;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratioTwo = size + "/" + sizeLastMonth;
        } else {
            // 如已派发数量为0，设定默认值
            ratioTwo = "0/" + size;
        }
        resultMap.put("lastMonthCompletionRatio", ratioTwo);

        // 本月至今
        int size2 = finishForMonth.size();
        // 计划上月完成卷册份数
        int sizeThisMonth = planFinishForMonth.size();
        String ratioThree;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratioThree = size2 + "/" + sizeThisMonth;
        } else {
            // 如已派发数量为0，设定默认值
            ratioThree = "0/" + size2;
        }
        resultMap.put("thisMonthCompletionRatio", ratioThree);


        //预警:本年,上月,本月
        int alertYear = 0;//预警数量本年数量
        int alertLastMonth = 0;//预警数量上月数量
        int alertThisMonth = 0;//预警数量本月数量


        List<SettlementCenterAlertInfoEntity> result = alertInfoService.selectByUserId(thirdNodeUserId, null,null,null);
        for (SettlementCenterAlertInfoEntity entity : result) {
            Date time = entity.getCreateTime();
            if (DateUtil.year(time) == DateUtil.thisYear()) {
                alertYear += 0;
            }
            //本月完成
            if (DateUtil.beginOfMonth(time).equals(DateUtil.beginOfMonth(new Date()))) {
                alertLastMonth += 0;
            }
            //上月完成
            if (DateUtil.beginOfMonth(time).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                alertThisMonth += 0;
            }

        }
        resultMap.put("alertYear", alertYear);
        resultMap.put("alertLastMonth", alertLastMonth);
        resultMap.put("alertThisMonth", alertThisMonth);


        Object rankYear = infoMapper.selectRankYear(thirdNodeUserId);
        Object rankLastMonth = infoMapper.selectRankLastMonth(thirdNodeUserId);
        Object rankThisMonth = infoMapper.selectRankThisMinth(thirdNodeUserId);
        resultMap.put("rankYear", rankYear);
        resultMap.put("rankLastMonth", rankLastMonth);
        resultMap.put("rankThisMonth", rankThisMonth);


        //上月图纸完成计划率
        if (planFinishForLastMonth.size() == 0) {
            resultMap.put("finishRateForLastMonth", 100);
        } else {
            resultMap.put("finishRateForLastMonth", (finishedForLastMonth.size() + 0.00) / planFinishForLastMonth.size());
        }
        //本月至今图纸完成计划率
        if (planFinishForMonth.size() == 0) {
            resultMap.put("finishRateForMonth", 100);
        } else {
            resultMap.put("finishRateForMonth", (finishForMonth.size() + 0.00) / planFinishForMonth.size());
        }
        return CommonResponse.success(resultMap);
    }


    /**
     * @Description 本人工程量统计一览表- 工程量统计产值动态图
     * @Return
     */
    @RequestMapping(value = "/queryActionMap", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, BigDecimal>>> queryActionMap(Long thirdNodeUserId, Long major) {
        List<Map<String, BigDecimal>> result = infoMapper.selectActionMap(thirdNodeUserId, null);
        return CommonResponse.success("查询列表数据成功！", result);
    }


    /**
     * @Description 本人工程量统计一览表- 本年工作任务完成情况清单 -未完成
     * @Return
     */
    @RequestMapping(value = "/queryPersonJobUndoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoEntity>> queryPersonJobUndoneList(Long thirdNodeUserId, Integer pageNum, Integer pageSize) {

        if (pageNum == null) pageNum = 1; // 默认值
        if (pageSize == null) pageSize = 20;
        Page<SettlementCenterDcDrwgrpInfoEntity> page = new Page<>(pageNum, pageSize);

        // 调用Mapper方法执行分页查询
        List<SettlementCenterDcDrwgrpInfoEntity> data = infoMapper.selectByConditionUndoneThisYear(page, thirdNodeUserId);
        page.setTotal(data.size());
        page.setRecords(data);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Description 本人工程量统计一览表- 本年工作任务完成情况清单 -已完成
     * @Return
     */
    @RequestMapping(value = "/queryPersonJobDoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoEntity>> queryPersonJobDoneList(Long thirdNodeUserId, Integer pageNum, Integer pageSize) {


        if (pageNum == null) pageNum = 1; // 默认值
        if (pageSize == null) pageSize = 20;
        Page<SettlementCenterDcDrwgrpInfoEntity> page = new Page<>(pageNum, pageSize);

        // 调用Mapper方法执行分页查询
        List<SettlementCenterDcDrwgrpInfoEntity> data = infoMapper.selectByConditionDoneThisYear(page, thirdNodeUserId);
        page.setTotal(data.size());
        page.setRecords(data);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param
     * @Description 本年工作任务完成情况清单导出(未完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportUndone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportUndone(Long thirdNodeUserId, HttpServletResponse response, Integer pageNum, Integer pageSize) {
        Map<String, Object> beans = new HashMap<>();


        if (pageNum == null) pageNum = 1; // 默认值
        if (pageSize == null) pageSize = 20;
        Page<SettlementCenterDcDrwgrpInfoEntity> page = new Page<>(pageNum, pageSize);
        List<SettlementCenterDcDrwgrpInfoEntity> list = infoMapper.selectByConditionUndoneThisYear(page, thirdNodeUserId);

        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 本年工作任务完成情况清单导出(已完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportDone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDone(Long thirdNodeUserId, HttpServletResponse response, Integer pageNum, Integer pageSize) {
        Map<String, Object> beans = new HashMap<>();


        if (pageNum == null) pageNum = 1; // 默认值
        if (pageSize == null) pageSize = 20;
        Page<SettlementCenterDcDrwgrpInfoEntity> page = new Page<>(pageNum, pageSize);
        List<SettlementCenterDcDrwgrpInfoEntity> list = infoMapper.selectByConditionDoneThisYear(page, thirdNodeUserId);

        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

}
