package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.service.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算中心卷册信息表
 *
 * @author generator
 */
@Controller
@RequestMapping("settlementCenterDcDrwgrpInfo")
public class SettlementCenterDcDrwgrpInfoController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService service;
    @Autowired
    private ISettlementCenterBudgetFeeService feeService;
    @Autowired
    private ISettlementCenterBudgetMeasureService measureService;
    @Autowired
    private ISettlementCenterBudgetSubService subService;
    @Autowired
    private ISettlementCenterBudgetOtherService otherService;
    @Autowired
    private ISettlementCenterUserProjectDetailService userProjectDetailService;
    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdate(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        SettlementCenterDcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
        service.saveOrUpdate(entity, false);
        CommonResponse<SettlementCenterDcDrwgrpInfoVO> commonResponse = queryDetail(entity.getId());
        SettlementCenterDcDrwgrpInfoVO vo = commonResponse.getData();
//    	SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 卷册审批完成新增数据
     */
    @RequestMapping(value = "/saveOrUpdateDcDrwgrpInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdateDcDrwgrpInfo(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        SettlementCenterDcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class);
        SettlementCenterDcDrwgrpInfoEntity exist = service.getOne(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, saveOrUpdateVO.getDcDrwgrpInfoId())
        );
        if (exist != null) {
            exist.setFirstNodeTime(new Date());
            service.updateById(exist);
        } else {
            SettlementCenterDcDrwgrpInfoEntity notUpgrade = service.getOne(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoCode, saveOrUpdateVO.getDcDrwgrpInfoCode())
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getWhetherUpgrade, 0)
            );
            if (notUpgrade != null){
                entity.setWhetherUpgrade(1);
            }
            service.save(entity);
        }
        SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> queryDetail(Long id) {
        SettlementCenterDcDrwgrpInfoEntity entity = service.selectById(id);
        SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
        vo.setSubTotalMny(BigDecimal.ZERO);
        vo.setSubTotalTaxMny(BigDecimal.ZERO);
        vo.setSubTotalTax(BigDecimal.ZERO);
        vo.setSubTotalOutput(BigDecimal.ZERO);
        vo.setMeasureTotalMny(BigDecimal.ZERO);
        vo.setMeasureTotalTaxMny(BigDecimal.ZERO);
        vo.setMeasureTotalTax(BigDecimal.ZERO);
        vo.setMeasureTotalOutput(BigDecimal.ZERO);
        vo.setOtherTotalMny(BigDecimal.ZERO);
        vo.setOtherTotalTaxMny(BigDecimal.ZERO);
        vo.setOtherTotalTax(BigDecimal.ZERO);
        vo.setOtherTotalOutput(BigDecimal.ZERO);
        vo.setFeeTotalMny(BigDecimal.ZERO);
        vo.setFeeTotalTaxMny(BigDecimal.ZERO);
        vo.setFeeTotalTax(BigDecimal.ZERO);
        vo.setFeeTotalOutput(BigDecimal.ZERO);

        Long userid = InvocationInfoProxy.getUserid();
        logger.info("累计产值的用户id:"+userid);
        //累计产值数据
        List<SettlementCenterUserProjectDetailEntity> userProjectDetailEntities = userProjectDetailService.list(
                new QueryWrapper<SettlementCenterUserProjectDetailEntity>().lambda()
                        .eq(SettlementCenterUserProjectDetailEntity::getUserId, userid)
                        .eq(SettlementCenterUserProjectDetailEntity::getDr, 0)
        );
        //母版数据
        List<SettlementCenterBudgetSubEntity> subEntities = subService.list(
                new QueryWrapper<SettlementCenterBudgetSubEntity>().lambda()
                        .eq(SettlementCenterBudgetSubEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetSubEntity::getDr, 0)
                        .eq(SettlementCenterBudgetSubEntity::getDcDrwgrpInfo, 0)
                        .last(" order by CAST(detail_index AS SIGNED INTEGER) ")
        );
        List<SettlementCenterBudgetMeasureEntity> measureEntities = measureService.list(
                new QueryWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
                        .eq(SettlementCenterBudgetMeasureEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetMeasureEntity::getDr, 0)
                        .eq(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo, 0)
                        .last(" order by CAST(detail_index AS SIGNED INTEGER) ")
        );
        List<SettlementCenterBudgetOtherEntity> otherEntities = otherService.list(
                new QueryWrapper<SettlementCenterBudgetOtherEntity>().lambda()
                        .eq(SettlementCenterBudgetOtherEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetOtherEntity::getDr, 0)
                        .eq(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo, 0)
                        .last(" order by CAST(detail_index AS SIGNED INTEGER) ")
        );
        List<SettlementCenterBudgetFeeEntity> feeEntities = feeService.list(
                new QueryWrapper<SettlementCenterBudgetFeeEntity>().lambda()
                        .eq(SettlementCenterBudgetFeeEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetFeeEntity::getDr, 0)
                        .eq(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo, 0)
                        .last(" order by CAST(detail_index AS SIGNED INTEGER) ")
        );
        //图纸工程量数据
        List<SettlementCenterBudgetSubEntity> dcSubEntities = subService.list(
                new QueryWrapper<SettlementCenterBudgetSubEntity>().lambda()
                        .eq(SettlementCenterBudgetSubEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetSubEntity::getDr, 0)
                        .eq(SettlementCenterBudgetSubEntity::getDcDrwgrpInfo, entity.getId())
        );
        List<SettlementCenterBudgetMeasureEntity> dcMeasureEntities = measureService.list(
                new QueryWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
                        .eq(SettlementCenterBudgetMeasureEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetMeasureEntity::getDr, 0)
                        .eq(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo, entity.getId())
        );
        List<SettlementCenterBudgetOtherEntity> dcOtherEntities = otherService.list(
                new QueryWrapper<SettlementCenterBudgetOtherEntity>().lambda()
                        .eq(SettlementCenterBudgetOtherEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetOtherEntity::getDr, 0)
                        .eq(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo, entity.getId())
        );
        List<SettlementCenterBudgetFeeEntity> dcFeeEntities = feeService.list(
                new QueryWrapper<SettlementCenterBudgetFeeEntity>().lambda()
                        .eq(SettlementCenterBudgetFeeEntity::getBudgetId, entity.getBudgeId())
                        .eq(SettlementCenterBudgetFeeEntity::getDr, 0)
                        .eq(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo, entity.getId())
        );
        if (subEntities != null && subEntities.size() > 0) {
            List<SettlementCenterBudgetSubVO> subVos = BeanMapper.mapList(subEntities, SettlementCenterBudgetSubVO.class);
            BigDecimal totalMny = new BigDecimal(0);//无税金额
            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
            BigDecimal totalTax = new BigDecimal(0);//税额
            BigDecimal totalOutput = new BigDecimal(0);//统计产值
            for (SettlementCenterBudgetSubVO subVo : subVos) {

                BigDecimal settlementCenterMnyTotal = new BigDecimal(0); // 累计统计产值(无税)
                BigDecimal settlementCenterTaxMnyTotal = new BigDecimal(0); // 累计统计产值(含税)
                BigDecimal settlementCenterTaxTotal = new BigDecimal(0); // 累计统计产值税额
                BigDecimal settlementCenterNumTotal = new BigDecimal(0); // 累计统计工程量

                totalMny = totalMny.add(subVo.getSubMny() == null ? BigDecimal.ZERO : subVo.getSubMny());
                totalTaxMny = totalTaxMny.add(subVo.getSubTaxMny() == null ? BigDecimal.ZERO : subVo.getSubTaxMny());
                totalTax = totalTax.add(subVo.getSubTax() == null ? BigDecimal.ZERO : subVo.getSubTax());
                //把统计数据汇总到母版数据上
                for (SettlementCenterBudgetSubEntity dcSubEntity : dcSubEntities) {
                    if (dcSubEntity.getParentId().equals(subVo.getId())) {
                        subVo.setSettlementCenterSubMny(dcSubEntity.getSettlementCenterSubMny() == null ? BigDecimal.ZERO : dcSubEntity.getSettlementCenterSubMny());
                        subVo.setSettlementCenterSubNum(dcSubEntity.getSettlementCenterSubNum() == null ? BigDecimal.ZERO : dcSubEntity.getSettlementCenterSubNum());
                        subVo.setSettlementCenterSubTax(dcSubEntity.getSettlementCenterSubTax() == null ? BigDecimal.ZERO : dcSubEntity.getSettlementCenterSubTax());
                        subVo.setSettlementCenterSubTaxMny(dcSubEntity.getSettlementCenterSubTaxMny() == null ? BigDecimal.ZERO : dcSubEntity.getSettlementCenterSubTaxMny());
                        if (StringUtils.isNotEmpty(dcSubEntity.getSubMemo())){
                            subVo.setSubMemo(dcSubEntity.getSubMemo());
                        }
                        totalOutput = totalOutput.add(subVo.getSettlementCenterSubTaxMny());
                    }
                }

                //把累计产值数据汇总到母版数据上
                for (SettlementCenterUserProjectDetailEntity detailEntity : userProjectDetailEntities) {
                    if (subVo.getId().equals(detailEntity.getSourceId())){
                        settlementCenterMnyTotal = settlementCenterMnyTotal.add(detailEntity.getSettlementCenterFeeMny());
                        settlementCenterTaxMnyTotal = settlementCenterTaxMnyTotal.add(detailEntity.getSettlementCenterFeeTaxMny());
                        settlementCenterTaxTotal = settlementCenterTaxTotal.add(detailEntity.getSettlementCenterFeeTax());
                        settlementCenterNumTotal = settlementCenterNumTotal.add(detailEntity.getSettlementCenterFeeNum());
                    }
                }
                subVo.setSettlementCenterSubMnyTotal(settlementCenterMnyTotal);
                subVo.setSettlementCenterSubNumTotal(settlementCenterNumTotal);
                subVo.setSettlementCenterSubTaxTotal(settlementCenterTaxTotal);
                subVo.setSettlementCenterSubTaxMnyTotal(settlementCenterTaxMnyTotal);
            }
            vo.setSubTotalMny(totalMny);
            vo.setSubTotalTaxMny(totalTaxMny);
            vo.setSubTotalTax(totalTax);
            vo.setSubTotalOutput(totalOutput);
            List<Map> subMap = BeanMapper.mapList(subVos, Map.class);
            for (Map map : subMap) {
                map.remove("createUserName");
            }
            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(subMap);
            subVos = BeanMapper.mapList(mapList, SettlementCenterBudgetSubVO.class);
            vo.setSubVOS(subVos);
        }
        if (measureEntities != null && measureEntities.size() > 0) {
            List<SettlementCenterBudgetMeasureVO> measureVos = BeanMapper.mapList(measureEntities, SettlementCenterBudgetMeasureVO.class);
            BigDecimal totalMny = new BigDecimal(0);//无税金额
            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
            BigDecimal totalTax = new BigDecimal(0);//税额
            BigDecimal totalOutput = new BigDecimal(0);//统计产值
            for (SettlementCenterBudgetMeasureVO measureVo : measureVos) {

                BigDecimal settlementCenterMnyTotal = new BigDecimal(0); // 累计统计产值(无税)
                BigDecimal settlementCenterTaxMnyTotal = new BigDecimal(0); // 累计统计产值(含税)
                BigDecimal settlementCenterTaxTotal = new BigDecimal(0); // 累计统计产值税额
                BigDecimal settlementCenterNumTotal = new BigDecimal(0); // 累计统计工程量

                totalMny = totalMny.add(measureVo.getMeasureMny() == null ? BigDecimal.ZERO : measureVo.getMeasureMny());
                totalTaxMny = totalTaxMny.add(measureVo.getMeasureTaxMny() == null ? BigDecimal.ZERO : measureVo.getMeasureTaxMny());
                totalTax = totalTax.add(measureVo.getMeasureTax() == null ? BigDecimal.ZERO : measureVo.getMeasureTax());
                //把统计数据汇总到母版数据上
                for (SettlementCenterBudgetMeasureEntity dcMeasureEntity : dcMeasureEntities) {
                    if (dcMeasureEntity.getParentId().equals(measureVo.getId())) {
                        measureVo.setSettlementCenterMeasureMny(dcMeasureEntity.getSettlementCenterMeasureMny() == null ? BigDecimal.ZERO : dcMeasureEntity.getSettlementCenterMeasureMny());
                        measureVo.setSettlementCenterMeasureNum(dcMeasureEntity.getSettlementCenterMeasureNum() == null ? BigDecimal.ZERO : dcMeasureEntity.getSettlementCenterMeasureNum());
                        measureVo.setSettlementCenterMeasureTax(dcMeasureEntity.getSettlementCenterMeasureTax() == null ? BigDecimal.ZERO : dcMeasureEntity.getSettlementCenterMeasureTax());
                        measureVo.setSettlementCenterMeasureTaxMny(dcMeasureEntity.getSettlementCenterMeasureTaxMny() == null ? BigDecimal.ZERO : dcMeasureEntity.getSettlementCenterMeasureTaxMny());
                        if (StringUtils.isNotEmpty(dcMeasureEntity.getMeasureMemo())){
                            measureVo.setMeasureMemo(dcMeasureEntity.getMeasureMemo());
                        }
                        totalOutput = totalOutput.add(measureVo.getSettlementCenterMeasureTaxMny());
                    }
                }

                //把累计产值数据汇总到母版数据上
                for (SettlementCenterUserProjectDetailEntity detailEntity : userProjectDetailEntities) {
                    if (measureVo.getId().equals(detailEntity.getSourceId())){
                        settlementCenterMnyTotal = settlementCenterMnyTotal.add(detailEntity.getSettlementCenterFeeMny());
                        settlementCenterTaxMnyTotal = settlementCenterTaxMnyTotal.add(detailEntity.getSettlementCenterFeeTaxMny());
                        settlementCenterTaxTotal = settlementCenterTaxTotal.add(detailEntity.getSettlementCenterFeeTax());
                        settlementCenterNumTotal = settlementCenterNumTotal.add(detailEntity.getSettlementCenterFeeNum());
                    }
                }
                measureVo.setSettlementCenterMeasureMnyTotal(settlementCenterMnyTotal);
                measureVo.setSettlementCenterMeasureNumTotal(settlementCenterNumTotal);
                measureVo.setSettlementCenterMeasureTaxTotal(settlementCenterTaxTotal);
                measureVo.setSettlementCenterMeasureTaxMnyTotal(settlementCenterTaxMnyTotal);
            }
            vo.setMeasureTotalMny(totalMny);
            vo.setMeasureTotalTaxMny(totalTaxMny);
            vo.setMeasureTotalTax(totalTax);
            vo.setMeasureTotalOutput(totalOutput);
            List<Map> measureMap = BeanMapper.mapList(measureVos, Map.class);
            for (Map map : measureMap) {
                map.remove("createUserName");
            }
            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(measureMap);
            measureVos = BeanMapper.mapList(mapList, SettlementCenterBudgetMeasureVO.class);
            vo.setMeasureVOS(measureVos);
        }
        if (otherEntities != null && otherEntities.size() > 0) {
            List<SettlementCenterBudgetOtherVO> otherVos = BeanMapper.mapList(otherEntities, SettlementCenterBudgetOtherVO.class);
            BigDecimal totalMny = new BigDecimal(0);//无税金额
            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
            BigDecimal totalTax = new BigDecimal(0);//税额
            BigDecimal totalOutput = new BigDecimal(0);//统计产值
            for (SettlementCenterBudgetOtherVO otherVo : otherVos) {

                BigDecimal settlementCenterMnyTotal = new BigDecimal(0); // 累计统计产值(无税)
                BigDecimal settlementCenterTaxMnyTotal = new BigDecimal(0); // 累计统计产值(含税)
                BigDecimal settlementCenterTaxTotal = new BigDecimal(0); // 累计统计产值税额
                BigDecimal settlementCenterNumTotal = new BigDecimal(0); // 累计统计工程量

                totalMny = totalMny.add(otherVo.getOtherMny() == null ? BigDecimal.ZERO : otherVo.getOtherMny());
                totalTaxMny = totalTaxMny.add(otherVo.getOtherTaxMny() == null ? BigDecimal.ZERO : otherVo.getOtherTaxMny());
                totalTax = totalTax.add(otherVo.getOtherTax() == null ? BigDecimal.ZERO : otherVo.getOtherTax());
                //把统计数据汇总到母版数据上
                for (SettlementCenterBudgetOtherEntity dcOtherEntity : dcOtherEntities) {
                    if (dcOtherEntity.getParentId().equals(otherVo.getId())) {
                        otherVo.setSettlementCenterOtherMny(dcOtherEntity.getSettlementCenterOtherMny() == null ? BigDecimal.ZERO : dcOtherEntity.getSettlementCenterOtherMny());
                        otherVo.setSettlementCenterOtherNum(dcOtherEntity.getSettlementCenterOtherNum() == null ? BigDecimal.ZERO : dcOtherEntity.getSettlementCenterOtherNum());
                        otherVo.setSettlementCenterOtherTax(dcOtherEntity.getSettlementCenterOtherTax() == null ? BigDecimal.ZERO : dcOtherEntity.getSettlementCenterOtherTax());
                        otherVo.setSettlementCenterOtherTaxMny(dcOtherEntity.getSettlementCenterOtherTaxMny() == null ? BigDecimal.ZERO : dcOtherEntity.getSettlementCenterOtherTaxMny());
                        if (StringUtils.isNotEmpty(dcOtherEntity.getOtherMemo())){
                            otherVo.setOtherMemo(dcOtherEntity.getOtherMemo());
                        }
                        totalOutput = totalOutput.add(otherVo.getSettlementCenterOtherTaxMny());
                    }
                }

                //把累计产值数据汇总到母版数据上
                for (SettlementCenterUserProjectDetailEntity detailEntity : userProjectDetailEntities) {
                    if (otherVo.getId().equals(detailEntity.getSourceId())){
                        settlementCenterMnyTotal = settlementCenterMnyTotal.add(detailEntity.getSettlementCenterFeeMny());
                        settlementCenterTaxMnyTotal = settlementCenterTaxMnyTotal.add(detailEntity.getSettlementCenterFeeTaxMny());
                        settlementCenterTaxTotal = settlementCenterTaxTotal.add(detailEntity.getSettlementCenterFeeTax());
                        settlementCenterNumTotal = settlementCenterNumTotal.add(detailEntity.getSettlementCenterFeeNum());
                    }
                }
                otherVo.setSettlementCenterOtherMnyTotal(settlementCenterMnyTotal);
                otherVo.setSettlementCenterOtherNumTotal(settlementCenterNumTotal);
                otherVo.setSettlementCenterOtherTaxTotal(settlementCenterTaxTotal);
                otherVo.setSettlementCenterOtherTaxMnyTotal(settlementCenterTaxMnyTotal);
            }
            vo.setOtherTotalMny(totalMny);
            vo.setOtherTotalTaxMny(totalTaxMny);
            vo.setOtherTotalTax(totalTax);
            vo.setOtherTotalOutput(totalOutput);
            List<Map> otherMap = BeanMapper.mapList(otherVos, Map.class);
            for (Map map : otherMap) {
                map.remove("createUserName");
            }
            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(otherMap);
            otherVos = BeanMapper.mapList(mapList, SettlementCenterBudgetOtherVO.class);
            vo.setOtherVOS(otherVos);
        }
        if (feeEntities != null && feeEntities.size() > 0) {
            List<SettlementCenterBudgetFeeVO> feeVos = BeanMapper.mapList(feeEntities, SettlementCenterBudgetFeeVO.class);
            BigDecimal totalMny = new BigDecimal(0);//无税金额
            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
            BigDecimal totalTax = new BigDecimal(0);//税额
            BigDecimal totalOutput = new BigDecimal(0);//统计产值
            for (SettlementCenterBudgetFeeVO feeVo : feeVos) {

                BigDecimal settlementCenterMnyTotal = new BigDecimal(0); // 累计统计产值(无税)
                BigDecimal settlementCenterTaxMnyTotal = new BigDecimal(0); // 累计统计产值(含税)
                BigDecimal settlementCenterTaxTotal = new BigDecimal(0); // 累计统计产值税额
                BigDecimal settlementCenterNumTotal = new BigDecimal(0); // 累计统计工程量

                totalMny = totalMny.add(feeVo.getFeeMny() == null ? BigDecimal.ZERO : feeVo.getFeeMny());
                totalTaxMny = totalTaxMny.add(feeVo.getFeeTaxMny() == null ? BigDecimal.ZERO : feeVo.getFeeTaxMny());
                totalTax = totalTax.add(feeVo.getFeeTax() == null ? BigDecimal.ZERO : feeVo.getFeeTax());
                //把统计数据汇总到母版数据上
                for (SettlementCenterBudgetFeeEntity dcFeeEntity : dcFeeEntities) {
                    if (dcFeeEntity.getParentId().equals(feeVo.getId())) {
                        feeVo.setSettlementCenterFeeMny(dcFeeEntity.getSettlementCenterFeeMny() == null ? BigDecimal.ZERO : dcFeeEntity.getSettlementCenterFeeMny());
                        feeVo.setSettlementCenterFeeNum(dcFeeEntity.getSettlementCenterFeeNum() == null ? BigDecimal.ZERO : dcFeeEntity.getSettlementCenterFeeNum());
                        feeVo.setSettlementCenterFeeTax(dcFeeEntity.getSettlementCenterFeeTax() == null ? BigDecimal.ZERO : dcFeeEntity.getSettlementCenterFeeTax());
                        feeVo.setSettlementCenterFeeTaxMny(dcFeeEntity.getSettlementCenterFeeTaxMny() == null ? BigDecimal.ZERO : dcFeeEntity.getSettlementCenterFeeTaxMny());
                        if (StringUtils.isNotEmpty(dcFeeEntity.getFeeMemo())){
                            feeVo.setFeeMemo(dcFeeEntity.getFeeMemo());
                        }
                        totalOutput = totalOutput.add(feeVo.getSettlementCenterFeeTaxMny());
                    }
                }

                //把累计产值数据汇总到母版数据上
                for (SettlementCenterUserProjectDetailEntity detailEntity : userProjectDetailEntities) {
                    if (feeVo.getId().equals(detailEntity.getSourceId())){
                        settlementCenterMnyTotal = settlementCenterMnyTotal.add(detailEntity.getSettlementCenterFeeMny());
                        settlementCenterTaxMnyTotal = settlementCenterTaxMnyTotal.add(detailEntity.getSettlementCenterFeeTaxMny());
                        settlementCenterTaxTotal = settlementCenterTaxTotal.add(detailEntity.getSettlementCenterFeeTax());
                        settlementCenterNumTotal = settlementCenterNumTotal.add(detailEntity.getSettlementCenterFeeNum());
                    }
                }
                feeVo.setSettlementCenterFeeMnyTotal(settlementCenterMnyTotal);
                feeVo.setSettlementCenterFeeNumTotal(settlementCenterNumTotal);
                feeVo.setSettlementCenterFeeTaxTotal(settlementCenterTaxTotal);
                feeVo.setSettlementCenterFeeTaxMnyTotal(settlementCenterTaxMnyTotal);
            }
            vo.setFeeTotalMny(totalMny);
            vo.setFeeTotalTaxMny(totalTaxMny);
            vo.setFeeTotalTax(totalTax);
            vo.setFeeTotalOutput(totalOutput);
            List<Map> feeMap = BeanMapper.mapList(feeVos, Map.class);
            for (Map map : feeMap) {
                map.remove("createUserName");
            }
            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(feeMap);
            feeVos = BeanMapper.mapList(mapList, SettlementCenterBudgetFeeVO.class);
            vo.setFeeVOS(feeVos);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterDcDrwgrpInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettlementCenterDcDrwgrpInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettlementCenterDcDrwgrpInfoVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dcDrwgrpInfoCode");
//        fuzzyFields.add("firstNodeUserName");
//        fuzzyFields.add("secondNodeUserName");
        fuzzyFields.add("thirdNodeUserName");//统计人
//        fuzzyFields.add("fourthNodeUserName");
//        fuzzyFields.add("fifthNodeUserName");
//        fuzzyFields.add("sixthNodeUserName");
//        fuzzyFields.add("seventhNodeUserName");
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<RoleVO>> roles = roleApi.queryRoleByNameAndCode("结算中心综合管理员", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && roles.getData().size() > 0) {
            RoleVO roleVO = roles.getData().get(0);
            CommonResponse<List<RoleVO>> userRoles = roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && userRoles.getData().size() > 0) {
                for (RoleVO role : userRoles.getData()) {
                    if (role.getId().equals(roleVO.getId())) {
                        flag = true;
                    }
                }
            }
        }

        if (!flag) {
            param.getParams().put("thirdNodeUserId",
                    new Parameter(
                            QueryParam.SQL,
                            "(" +
                                    "first_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "second_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') " +
                                    ")")
            );
        }

        if (param.getParams().get("orgId") != null) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//            String authOrgIds = userContextCache.getAuthOrgIds();
            String authOrgIds = param.getParams().get("orgId").getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }


        IPage<SettlementCenterDcDrwgrpInfoEntity> page = service.queryPage(param, false);
        long total = page.getTotal();
        param.getParams().put("flowState", new Parameter(QueryParam.EQ, SettleFlowStateEnum.NINE.getCode()));
        param.setPageSize(1);
        IPage<SettlementCenterDcDrwgrpInfoEntity> finishPage = service.queryPage(param, false);
        long finishTotal = finishPage.getTotal();

        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        for (SettlementCenterDcDrwgrpInfoVO record : pageData.getRecords()) {
            record.setTotal(total);
            record.setFinishTotal(finishTotal);
            if (total != 0) {
                record.setPercentage((finishTotal + 0.00) / total);
            } else {
                record.setPercentage(100.00);
            }
        }

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dcDrwgrpInfoCode");
//        fuzzyFields.add("firstNodeUserName");
//        fuzzyFields.add("secondNodeUserName");
        fuzzyFields.add("thirdNodeUserName");//统计人
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<RoleVO>> roles = roleApi.queryRoleByNameAndCode("结算中心综合管理员", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && roles.getData().size() > 0) {
            RoleVO roleVO = roles.getData().get(0);
            CommonResponse<List<RoleVO>> userRoles = roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && userRoles.getData().size() > 0) {
                for (RoleVO role : userRoles.getData()) {
                    if (role.getId().equals(roleVO.getId())) {
                        flag = true;
                    }
                }
            }
        }

        if (!flag) {
            param.getParams().put("thirdNodeUserId",
                    new Parameter(
                            QueryParam.SQL,
                            "(" +
                                    "first_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "second_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') " +
                                    ")")
            );
        }
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().get("orgId") != null) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//            String authOrgIds = userContextCache.getAuthOrgIds();
            String authOrgIds = param.getParams().get("orgId").getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        List<SettlementCenterDcDrwgrpInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterDcDrwgrpInfo-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettlementCenterDcDrwgrpInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> refSettlementCenterDcDrwgrpInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                                     String condition,
                                                                                                     String searchObject,
                                                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementCenterDcDrwgrpInfoEntity> page = service.queryPage(param, false);
        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/deleteForDrwgrp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteForDrwgrp(List<Long> dcDrwgrpId) {
        List<SettlementCenterDcDrwgrpInfoEntity> list = service.list(
                new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                        .in(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, dcDrwgrpId)
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
        );
        List<Long> idList = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        service.removeByIds(idList);
        userProjectDetailService.remove(
                new UpdateWrapper<SettlementCenterUserProjectDetailEntity>().lambda()
                        .in(SettlementCenterUserProjectDetailEntity::getDcDrwgrpInfo,idList)
        );
        feeService.remove(
                new UpdateWrapper<SettlementCenterBudgetFeeEntity>().lambda()
                        .in(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo,idList)
        );
        measureService.remove(
                new UpdateWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
                        .in(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo,idList)
        );
        otherService.remove(
                new UpdateWrapper<SettlementCenterBudgetOtherEntity>().lambda()
                        .in(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo,idList)
        );
        subService.remove(
                new UpdateWrapper<SettlementCenterBudgetSubEntity>().lambda()
                        .in(SettlementCenterBudgetSubEntity::getDcDrwgrpInfo,idList)
        );

        return CommonResponse.success("删除成功！");
    }
}
