/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.bean.SettlementCenterOutputDetailEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterOutputDetailService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"majorQuantitiesInfo"})
public class MajorQuantitiesInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;
    @Autowired
    private ISettlementCenterOutputDetailService detailService;
    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse queryList(Long major, String orgId) {
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)orgId) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).like(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, (Object)major);
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).like(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, (Object)major)).in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId, commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).like(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, (Object)major)).in(SettlementCenterDcDrwgrpInfoEntity::getOrgId, departmentIds);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List list = this.infoService.list((Wrapper)queryWrapper);
        BigDecimal totalOutputForYear = new BigDecimal(0);
        BigDecimal totalOutputAll = new BigDecimal(0);
        BigDecimal totalOutputForLastMonth = new BigDecimal(0);
        BigDecimal totalOutputForMonth = new BigDecimal(0);
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishedForLastMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> planFinishForLastMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishForMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> planFinishForMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> planFinishForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> distributedForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishedForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        List detailEntities = new ArrayList();
        if (list.size() > 0) {
            List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            detailEntities = this.detailService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterOutputDetailEntity::getSettlementCenterMajor, (Object)major)).in(SettlementCenterOutputDetailEntity::getPid, idList));
        }
        HashMap<Integer, BigDecimal> outputEveryMonth = new HashMap<Integer, BigDecimal>();
        for (SettlementCenterDcDrwgrpInfoEntity entity : list) {
            Date finishDate;
            BigDecimal statisticalOutput = new BigDecimal(0);
            for (SettlementCenterOutputDetailEntity detailEntity : detailEntities) {
                if (!detailEntity.getPid().equals(entity.getId())) continue;
                statisticalOutput = statisticalOutput.add(detailEntity.getStatisticalOutput());
            }
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                finishDate = entity.getEighthNodeTime();
                totalOutputAll = totalOutputAll.add(statisticalOutput);
                if (DateUtil.year((Date)finishDate) == DateUtil.thisYear()) {
                    totalOutputForYear = totalOutputForYear.add(statisticalOutput);
                    Integer month = DateUtil.month((Date)finishDate) + 1;
                    if (outputEveryMonth.get(month) == null) {
                        outputEveryMonth.put(month, statisticalOutput);
                    } else {
                        outputEveryMonth.put(month, ((BigDecimal)outputEveryMonth.get(month)).add(statisticalOutput));
                    }
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                    totalOutputForMonth = totalOutputForMonth.add(statisticalOutput);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                    totalOutputForLastMonth = totalOutputForLastMonth.add(statisticalOutput);
                }
            }
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                finishDate = null;
                finishDate = entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName()) ? entity.getEighthNodeTime() : entity.getFifthNodeTime();
                if (DateUtil.year((Date)finishDate) == DateUtil.thisYear()) {
                    finishedForYear.add(entity);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                    finishForMonth.add(entity);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                    finishedForLastMonth.add(entity);
                }
            }
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.TWO.getName())) continue;
            Date planFinishDate = entity.getDesiredTime();
            Date distributedDate = entity.getSecondNodeTime();
            if (planFinishDate != null && DateUtil.beginOfMonth((Date)planFinishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                planFinishForMonth.add(entity);
            }
            if (planFinishDate != null && DateUtil.beginOfMonth((Date)planFinishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                planFinishForLastMonth.add(entity);
            }
            if (planFinishDate != null && DateUtil.year((Date)planFinishDate) == DateUtil.year((Date)DateUtil.lastMonth())) {
                planFinishForYear.add(entity);
            }
            if (distributedDate == null || DateUtil.year((Date)distributedDate) != DateUtil.thisYear()) continue;
            distributedForYear.add(entity);
        }
        resultMap.put("totalOutputForYear", totalOutputForYear);
        resultMap.put("totalOutputAll", totalOutputAll);
        resultMap.put("totalOutputForLastMonth", totalOutputForLastMonth);
        resultMap.put("totalOutputForMonth", totalOutputForMonth);
        int distributedCount = distributedForYear.size();
        int finishedCount = finishedForYear.size();
        String ratio = distributedCount > 0 ? finishedCount + "/" + distributedCount : "0/" + distributedCount;
        resultMap.put("yearCompletionRatio", ratio);
        int size = finishedForLastMonth.size();
        int sizeLastMonth = planFinishForLastMonth.size();
        String ratioTwo = distributedCount > 0 ? size + "/" + sizeLastMonth : "0/" + sizeLastMonth;
        resultMap.put("lastMonthCompletionRatio", ratioTwo);
        int size2 = finishForMonth.size();
        int sizeThisMonth = planFinishForMonth.size();
        String ratioThree = distributedCount > 0 ? size2 + "/" + sizeThisMonth : "0/" + sizeThisMonth;
        resultMap.put("thisMonthCompletionRatio", ratioThree);
        int alertYear = 0;
        int alertLastMonth = 0;
        int alertThisMonth = 0;
        List<Object> result = new ArrayList();
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            result = this.alertInfoService.selectByUserId(null, major, departmentIds, commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            result = this.alertInfoService.selectByUserId(null, major, departmentIds, commonOrgIds);
        }
        for (SettlementCenterAlertInfoEntity entity : result) {
            Date time = entity.getCreateTime();
            if (DateUtil.year((Date)time) == DateUtil.thisYear()) {
                alertYear += 0;
            }
            if (DateUtil.beginOfMonth((Date)time).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                alertLastMonth += 0;
            }
            if (!DateUtil.beginOfMonth((Date)time).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) continue;
            alertThisMonth += 0;
        }
        resultMap.put("alertYear", alertYear);
        resultMap.put("alertLastMonth", alertLastMonth);
        resultMap.put("alertThisMonth", alertThisMonth);
        int size1 = finishedForYear.size();
        int size4 = finishForMonth.size();
        int size5 = finishedForLastMonth.size();
        int size3 = planFinishForMonth.size();
        int size6 = planFinishForLastMonth.size();
        int size7 = planFinishForYear.size();
        if (size3 == 0) {
            System.out.println("\u603b\u4efb\u52a1\u6570\u91cf\u4e3a0\uff0c\u65e0\u6cd5\u8ba1\u7b97\u5b8c\u6210\u7387\uff01");
        } else {
            if (size7 != 0) {
                double completionRate = (double)size1 / (double)size7;
                double completionRatePercentage = completionRate * 100.0;
                resultMap.put("rateYear", completionRatePercentage);
            }
            if (size3 != 0) {
                double completionRate2 = (double)size4 / (double)size3;
                double completionRatePercentage2 = completionRate2 * 100.0;
                resultMap.put("rateThisMonth", completionRatePercentage2);
            }
            if (size6 != 0) {
                double completionRate3 = (double)size5 / (double)size6;
                double completionRatePercentage3 = completionRate3 * 100.0;
                resultMap.put("rateLastMonth", completionRatePercentage3);
            }
        }
        if (alertLastMonth == 0) {
            System.out.println("\u4e0a\u6708\u9884\u8b66\u6570\u4e3a0\uff0c\u65e0\u6cd5\u8ba1\u7b97\u589e\u5e45\uff01");
            resultMap.put("alertRate", null);
        } else {
            double increaseRate = (double)(alertThisMonth - alertLastMonth) / (double)alertLastMonth * 100.0;
            resultMap.put("alertRate", increaseRate);
        }
        if (totalOutputForLastMonth.equals(BigDecimal.ZERO)) {
            System.out.println("\u4e0a\u6708\u7edf\u8ba1\u4ea7\u503c\u4e3a0\uff0c\u65e0\u6cd5\u8ba1\u7b97\u589e\u5e45\uff01");
            resultMap.put("outputRate", null);
        } else {
            BigDecimal divide = totalOutputForMonth.subtract(totalOutputForLastMonth).divide(totalOutputForLastMonth, 2, RoundingMode.HALF_DOWN);
            resultMap.put("outputRate", divide);
        }
        if (size == 0) {
            System.out.println("\u4e0a\u6708\u5377\u518c\u6570\u4e3a0\uff0c\u65e0\u6cd5\u8ba1\u7b97\u589e\u5e45\uff01");
            resultMap.put("volumeRate", null);
        } else {
            double increaseRate = (double)(size2 - size) / (double)size * 100.0;
            resultMap.put("volumeRate", increaseRate);
        }
        if (planFinishForLastMonth.size() == 0) {
            // empty if block
        }
        if (planFinishForMonth.size() == 0) {
            resultMap.put("finishRateForMonth", 100);
        } else {
            resultMap.put("finishRateForMonth", ((double)finishForMonth.size() + 0.0) / (double)planFinishForMonth.size());
        }
        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value={"/queryActionMap"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, BigDecimal>>> queryActionMap(Long thirdNodeUserId, Long major) {
        List<Map<String, BigDecimal>> result = this.infoMapper.selectActionMap(null, major);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/queryMajorJobUndoneList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryMajorJobUndoneList(@RequestBody QueryParam param) {
        Parameter orgParam = (Parameter)param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)orgId) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("thirdNodeUserId");
        fuzzyFields.add("fourthNodeUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("flowState", new Parameter("not_in", Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode(), SettleFlowStateEnum.ONE.getCode(), SettleFlowStateEnum.THREE.getCode())));
        param.getParams().put("eighth_node_time", new Parameter("sql", (Object)"((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        IPage page = this.infoService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMajorJobDoneList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryMajorJobDoneList(@RequestBody QueryParam param) {
        Parameter orgParam = (Parameter)param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)orgId) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("thirdNodeUserId");
        fuzzyFields.add("fourthNodeUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("flowState", new Parameter("sql", (Object)"(flow_state = 9 or flow_state = 2)"));
        param.getParams().put("eighth_node_time", new Parameter("sql", (Object)"((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        IPage page = this.infoService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExportUndone"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportUndone(Long major, HttpServletResponse response, @RequestBody QueryParam param) {
        Parameter orgParam = (Parameter)param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)orgId) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        HashMap beans = new HashMap();
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("flowState", new Parameter("not_in", Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode())));
        param.getParams().put("eighth_node_time", new Parameter("sql", (Object)"((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        List list = this.infoService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List collect = list.stream().filter(entiy -> entiy != null && entiy.getSettlementCenterMajor() != null && entiy.getSettlementCenterMajor().contains(major.toString())).collect(Collectors.toList());
            beans.put("records", collect);
        }
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportDone"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDone(Long major, HttpServletResponse response, @RequestBody QueryParam param) {
        Parameter orgParam = (Parameter)param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)orgId) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        HashMap beans = new HashMap();
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("flowState", new Parameter("sql", (Object)"(flow_state = 9 or flow_state = 2)"));
        param.getParams().put("eighth_node_time", new Parameter("sql", (Object)"((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        param.setPageSize(1);
        List list = this.infoService.queryList(param);
        List collect = list.stream().filter(entiy -> entiy.getSettlementCenterMajor().contains(major.toString())).collect(Collectors.toList());
        beans.put("records", collect);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getRankingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse getRankingList(Long major, String orgId) {
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)orgId) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        HashMap<String, List<Map>> resultMap = new HashMap<String, List<Map>>();
        List<Map> rankingListForYear = this.infoService.getRankingListForYear(major, departmentIds, commonOrgIds);
        List<Map> rankingListForMonth = this.infoService.getRankingListForMonth(major, departmentIds, commonOrgIds);
        resultMap.put("rankingListForYear", rankingListForYear);
        resultMap.put("rankingListForMonth", rankingListForMonth);
        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value={"/queryMajorLedgerList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryMajorLedgerList(Long majorId, Integer pageNum, Integer pageSize, String orgId) {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)orgId) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        int pageStart = pageSize * (pageNum - 1);
        List<Object> majorStatisticsLedgerList = new ArrayList();
        int total = 0;
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            if (commonOrgIds.size() > 0) {
                majorStatisticsLedgerList = this.infoService.getMajorStatisticsLedgerList(majorId, null, commonOrgIds, pageStart, pageSize);
                total = this.infoService.countMajorStatisticsLedgerList(majorId, null, commonOrgIds);
            } else {
                majorStatisticsLedgerList = this.infoService.getMajorStatisticsLedgerList(majorId, departmentIds, null, pageStart, pageSize);
                total = this.infoService.countMajorStatisticsLedgerList(majorId, departmentIds, null);
            }
        } else {
            majorStatisticsLedgerList = this.infoService.getMajorStatisticsLedgerList(majorId, null, null, pageStart, pageSize);
            total = this.infoService.countMajorStatisticsLedgerList(majorId, null, null);
        }
        resultMap.put("records", (Serializable)((Object)majorStatisticsLedgerList));
        resultMap.put("pages", Integer.valueOf(total % pageSize > 0 ? total / pageSize + 1 : total / pageSize));
        resultMap.put("size", pageSize);
        resultMap.put("total", Integer.valueOf(total));
        resultMap.put("current", pageNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", resultMap);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

