/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.enums.SettleDrawTypeEnum;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectStatistics"})
public class ProjectStatisticsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/statisticalData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse statisticalData(Long projectId) {
        String orgId = "" + InvocationInfoProxy.getOrgId();
        List orgVOList = (List)this.getRespData(this.iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        if (commonOrgIds.size() == 0 && projectId == null) {
            BigDecimal sumOutput = new BigDecimal(0);
            resultMap.put("needStatistCount", 0);
            resultMap.put("finishCount", 0);
            resultMap.put("finishRate", 1);
            resultMap.put("sumOutput", sumOutput);
            resultMap.put("monthOutput", new BigDecimal(0));
            resultMap.put("yearOutput", new BigDecimal(0));
            resultMap.put("contractMny", new BigDecimal(0));
            resultMap.put("allCount", new BigDecimal(0));
            return CommonResponse.success(resultMap);
        }
        CommonResponse defdoc = this.iDefdocApi.getDefDocByDefCode("settlement_center_drwgrp_type");
        Long defdocDetailId = ((List)defdoc.getData()).stream().filter(a -> a.getName().equals(SettleDrawTypeEnum.N.getName())).map(BaseVO::getId).findFirst().orElse(null);
        if (defdocDetailId == null) {
            return CommonResponse.error((String)"\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef");
        }
        int needStatistCount = 0;
        int finishCount = 0;
        int allCount = 0;
        boolean unDoneCount = false;
        BigDecimal sumOutput = new BigDecimal(0);
        BigDecimal monthOutput = new BigDecimal(0);
        BigDecimal yearOutput = new BigDecimal(0);
        BigDecimal contractMny = new BigDecimal(0);
        if (projectId == null) {
            needStatistCount = this.dcDrwgrpInfoService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterDcDrwgrpInfoEntity::getDiscriminateState, (Object)defdocDetailId)).eq(BaseEntity::getDr, (Object)0)).in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId, commonOrgIds));
            finishCount = this.dcDrwgrpInfoService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))).eq(BaseEntity::getDr, (Object)0)).in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId, commonOrgIds));
            allCount = this.dcDrwgrpInfoService.count((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId, commonOrgIds));
            Map<String, BigDecimal> map = this.infoMapper.selectSumOutput(projectId, commonOrgIds);
            if (map != null) {
                sumOutput = map.get("sumOutput");
                yearOutput = map.get("yearOutput");
                monthOutput = map.get("monthOutput");
            }
            Map<String, BigDecimal> queryContractMny = this.infoMapper.queryContractMny(projectId, commonOrgIds);
            this.logger.info("\u67e5\u8be2\u7684\u5408\u540c\u91d1\u989d\u6570\u636e\u4e3a:" + (queryContractMny == null ? "null" : JSON.toJSONString(queryContractMny)));
            if (queryContractMny != null) {
                contractMny = queryContractMny.get("contractMny");
            }
        } else {
            needStatistCount = this.dcDrwgrpInfoService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterDcDrwgrpInfoEntity::getDiscriminateState, (Object)defdocDetailId)).eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, (Object)projectId));
            finishCount = this.dcDrwgrpInfoService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))).eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, (Object)projectId));
            allCount = this.dcDrwgrpInfoService.count((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, (Object)projectId));
            Map<String, BigDecimal> map = this.infoMapper.selectSumOutput(projectId, null);
            if (map != null) {
                sumOutput = map.get("sumOutput");
                monthOutput = map.get("monthOutput");
                yearOutput = map.get("yearOutput");
            }
            Map<String, BigDecimal> queryContractMny = this.infoMapper.queryContractMny(projectId, null);
            this.logger.info("\u67e5\u8be2\u7684\u5408\u540c\u91d1\u989d\u6570\u636e\u4e3a:" + (queryContractMny == null ? "null" : JSON.toJSONString(queryContractMny)));
            if (queryContractMny != null) {
                contractMny = queryContractMny.get("contractMny");
            }
        }
        resultMap.put("needStatistCount", needStatistCount);
        resultMap.put("finishCount", finishCount);
        resultMap.put("allCount", allCount);
        if (allCount != 0) {
            resultMap.put("finishRate", ((double)finishCount + 0.0) / (double)allCount);
        } else {
            resultMap.put("finishRate", 1);
        }
        resultMap.put("contractMny", contractMny);
        resultMap.put("sumOutput", sumOutput);
        resultMap.put("monthOutput", monthOutput);
        resultMap.put("yearOutput", yearOutput);
        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value={"/queryProjectJobUndoneList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoEntity>> queryProjectJobUndoneList(Long projectId, Integer pageNum, Integer pageSize) {
        String orgId = "" + InvocationInfoProxy.getOrgId();
        List orgVOList = (List)this.getRespData(this.iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNum.intValue());
        queryParam.getParams().put("flowState", new Parameter("ne", (Object)SettleFlowStateEnum.NINE.getCode()));
        queryParam.getParams().put("flowState", new Parameter("ne", (Object)SettleFlowStateEnum.TWO.getCode()));
        if (projectId != null) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (commonOrgIds.size() > 0) {
            queryParam.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else {
            queryParam.getParams().put("parentOrgId", new Parameter("eq", (Object)0));
        }
        IPage page = this.dcDrwgrpInfoService.queryPage(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryProjectJobDoneList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoEntity>> queryProjectJobDoneList(Long projectId, Integer pageNum, Integer pageSize) {
        String orgId = "" + InvocationInfoProxy.getOrgId();
        List orgVOList = (List)this.getRespData(this.iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNum.intValue());
        queryParam.getParams().put("flowState", new Parameter("sql", (Object)"(flow_state = 9 or flow_state = 2)"));
        if (projectId != null) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (commonOrgIds.size() > 0) {
            queryParam.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else {
            queryParam.getParams().put("parentOrgId", new Parameter("eq", (Object)0));
        }
        IPage page = this.dcDrwgrpInfoService.queryPage(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelExportUndone"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportUndone(Long projectId, HttpServletResponse response, Integer pageNum, Integer pageSize) {
        String orgId = "" + InvocationInfoProxy.getOrgId();
        List orgVOList = (List)this.getRespData(this.iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("flowState", new Parameter("ne", (Object)SettleFlowStateEnum.NINE.getCode()));
        queryParam.getParams().put("flowState", new Parameter("ne", (Object)SettleFlowStateEnum.TWO.getCode()));
        if (projectId != null) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (commonOrgIds.size() > 0) {
            queryParam.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else {
            queryParam.getParams().put("parentOrgId", new Parameter("eq", (Object)0));
        }
        List list = this.dcDrwgrpInfoService.queryList(queryParam);
        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportDone"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDone(Long projectId, HttpServletResponse response, Integer pageNum, Integer pageSize) {
        String orgId = "" + InvocationInfoProxy.getOrgId();
        List orgVOList = (List)this.getRespData(this.iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("flowState", new Parameter("sql", (Object)"(flow_state = 9 or flow_state = 2)"));
        if (projectId != null) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (commonOrgIds.size() > 0) {
            queryParam.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else {
            queryParam.getParams().put("parentOrgId", new Parameter("eq", (Object)0));
        }
        List list = this.dcDrwgrpInfoService.queryList(queryParam);
        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/queryProjectLedgerList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryProjectLedgerList(Long projectId, Integer pageNum, Integer pageSize) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String orgId = "" + InvocationInfoProxy.getOrgId();
        List orgVOList = (List)this.getRespData(this.iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        int pageStart = pageSize * (pageNum - 1);
        List<Object> projectStatisticsLedgerList = new ArrayList();
        int total = 0;
        if (projectId != null) {
            projectStatisticsLedgerList = this.dcDrwgrpInfoService.getProjectStatisticsLedgerList(projectId, null, null, pageStart, pageSize);
            total = this.dcDrwgrpInfoService.countProjectStatisticsLedgerList(projectId, null, null);
        } else if (commonOrgIds.size() > 0) {
            projectStatisticsLedgerList = this.dcDrwgrpInfoService.getProjectStatisticsLedgerList(projectId, null, commonOrgIds, pageStart, pageSize);
            total = this.dcDrwgrpInfoService.countProjectStatisticsLedgerList(projectId, null, commonOrgIds);
        } else {
            projectStatisticsLedgerList = this.dcDrwgrpInfoService.getProjectStatisticsLedgerList(projectId, null, Arrays.asList(0L), pageStart, pageSize);
            total = this.dcDrwgrpInfoService.countProjectStatisticsLedgerList(projectId, null, Arrays.asList(0L));
        }
        HashMap<Long, BigDecimal> map1 = new HashMap<Long, BigDecimal>();
        for (Map map : projectStatisticsLedgerList) {
            long project_id = Long.parseLong(map.get("project_id").toString());
            BigDecimal bigDecimal = (BigDecimal)map1.get(project_id);
            if (bigDecimal == null) {
                Map<String, BigDecimal> map2 = this.infoMapper.selectSumOutput(project_id, null);
                if (map2 == null) continue;
                BigDecimal contractMny = map2.get("contractMny");
                if (contractMny == null) {
                    map1.put(project_id, contractMny);
                    map.put("contract_mny", contractMny);
                    continue;
                }
                map1.put(project_id, BigDecimal.ZERO);
                map.put("contract_mny", BigDecimal.ZERO);
                continue;
            }
            map.put("contract_mny", bigDecimal);
        }
        resultMap.put("records", projectStatisticsLedgerList);
        resultMap.put("pages", total % pageSize > 0 ? total / pageSize + 1 : total / pageSize);
        resultMap.put("size", pageSize);
        resultMap.put("total", total);
        resultMap.put("current", pageNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", resultMap);
    }

    @RequestMapping(value={"/queryAllProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryProjectLedgerList() {
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        List<Object> allProject = new ArrayList();
        allProject = commonOrgIds.size() > 0 ? this.dcDrwgrpInfoService.queryAllProject(null, commonOrgIds) : this.dcDrwgrpInfoService.queryAllProject(departmentIds, null);
        if (allProject == null) {
            allProject = new ArrayList();
        }
        return CommonResponse.success(allProject);
    }
}

