/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.bean.SettlementCenterOutputDetailEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterOutputDetailService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settlementCenterDcDrwgrpInfo"})
public class SettlementCenterDcDrwgrpInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService service;
    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;
    @Autowired
    private ISettlementCenterOutputDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdate(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        SettlementCenterDcDrwgrpInfoEntity entity = (SettlementCenterDcDrwgrpInfoEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CommonResponse<SettlementCenterDcDrwgrpInfoVO> commonResponse = this.queryDetail(entity.getId());
        SettlementCenterDcDrwgrpInfoVO vo = (SettlementCenterDcDrwgrpInfoVO)commonResponse.getData();
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateDcDrwgrpInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdateDcDrwgrpInfo(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        SettlementCenterDcDrwgrpInfoEntity entity = (SettlementCenterDcDrwgrpInfoEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class));
        SettlementCenterDcDrwgrpInfoEntity exist = (SettlementCenterDcDrwgrpInfoEntity)((Object)this.service.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, (Object)saveOrUpdateVO.getDcDrwgrpInfoId())));
        if (exist != null) {
            exist.setFirstNodeTime(new Date());
            exist.setOrgId(entity.getOrgId());
            exist.setOrgCode(entity.getOrgCode());
            exist.setOrgName(entity.getOrgName());
            exist.setParentOrgId(entity.getParentOrgId());
            exist.setParentOrgCode(entity.getParentOrgCode());
            exist.setParentOrgName(entity.getParentOrgName());
            exist.setProjectId(entity.getProjectId());
            exist.setProjectCode(entity.getProjectCode());
            exist.setProjectName(entity.getProjectName());
            exist.setDcDrwgrpInfoCode(entity.getDcDrwgrpInfoCode());
            exist.setDcDrwgrpInfoName(entity.getDcDrwgrpInfoName());
            this.service.updateById((Object)exist);
        } else {
            SettlementCenterDcDrwgrpInfoEntity notUpgrade = (SettlementCenterDcDrwgrpInfoEntity)((Object)this.service.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoCode, (Object)saveOrUpdateVO.getDcDrwgrpInfoCode())).eq(SettlementCenterDcDrwgrpInfoEntity::getWhetherUpgrade, (Object)0)));
            if (notUpgrade != null) {
                entity.setWhetherUpgrade(1);
            }
            this.service.save((Object)entity);
        }
        SettlementCenterDcDrwgrpInfoVO vo = (SettlementCenterDcDrwgrpInfoVO)BeanMapper.map((Object)((Object)entity), SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> queryDetail(Long id) {
        SettlementCenterDcDrwgrpInfoEntity drwgrpInfoEntity = (SettlementCenterDcDrwgrpInfoEntity)((Object)this.service.selectById(id));
        SettlementCenterDcDrwgrpInfoVO vo = (SettlementCenterDcDrwgrpInfoVO)BeanMapper.map((Object)((Object)drwgrpInfoEntity), SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterDcDrwgrpInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettlementCenterDcDrwgrpInfoVO settlementCenterDcDrwgrpInfoVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dcDrwgrpInfoCode");
        fuzzyFields.add("dcDrwgrpInfoName");
        fuzzyFields.add("thirdNodeUserName");
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse roles = this.roleApi.queryRoleByNameAndCode("\u7ed3\u7b97\u4e2d\u5fc3\u7efc\u5408\u7ba1\u7406\u5458", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && ((List)roles.getData()).size() > 0) {
            RoleVO roleVO = (RoleVO)((List)roles.getData()).get(0);
            CommonResponse userRoles = this.roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && ((List)userRoles.getData()).size() > 0) {
                for (RoleVO role : (List)userRoles.getData()) {
                    if (!role.getId().equals(roleVO.getId())) continue;
                    flag = true;
                }
            }
        }
        if (!flag) {
            param.getParams().put("thirdNodeUserId", new Parameter("sql", (Object)("(first_node_user_id like CONCAT('%','" + userid.toString() + "','%') or second_node_user_id like CONCAT('%','" + userid.toString() + "','%') or third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') )")));
        }
        if (param.getParams().get("orgId") != null) {
            String authOrgIds = ((Parameter)param.getParams().get("orgId")).getValue().toString();
            param.getParams().remove("orgId");
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        long total = page.getTotal();
        param.getParams().put("flowState", new Parameter("eq", (Object)SettleFlowStateEnum.NINE.getCode()));
        param.setPageSize(1);
        IPage finishPage = this.service.queryPage(param, false);
        long finishTotal = finishPage.getTotal();
        param.getParams().put("flowState", new Parameter("in", Arrays.asList(SettleFlowStateEnum.SIX.getCode(), SettleFlowStateEnum.SEVEN.getCode(), SettleFlowStateEnum.EIGHT.getCode(), SettleFlowStateEnum.NINE.getCode())));
        IPage needPage = this.service.queryPage(param, false);
        long needTotal = needPage.getTotal();
        int alterTotal = this.alertInfoService.count((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterAlertInfoEntity::getThirdNodeUserId, (Object)userid)).eq(SettlementCenterAlertInfoEntity::getClearFlag, (Object)0));
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        for (SettlementCenterDcDrwgrpInfoVO record : pageData.getRecords()) {
            record.setTotal(Long.valueOf(total));
            record.setFinishTotal(Long.valueOf(finishTotal));
            record.setNeedTotal(Long.valueOf(needTotal));
            record.setAlterTotal(Integer.valueOf(alterTotal));
            if (total != 0L) {
                record.setPercentage(Double.valueOf(((double)finishTotal + 0.0) / (double)total));
                continue;
            }
            record.setPercentage(Double.valueOf(100.0));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dcDrwgrpInfoCode");
        fuzzyFields.add("thirdNodeUserName");
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse roles = this.roleApi.queryRoleByNameAndCode("\u7ed3\u7b97\u4e2d\u5fc3\u7efc\u5408\u7ba1\u7406\u5458", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && ((List)roles.getData()).size() > 0) {
            RoleVO roleVO = (RoleVO)((List)roles.getData()).get(0);
            CommonResponse userRoles = this.roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && ((List)userRoles.getData()).size() > 0) {
                for (RoleVO role : (List)userRoles.getData()) {
                    if (!role.getId().equals(roleVO.getId())) continue;
                    flag = true;
                }
            }
        }
        if (!flag) {
            param.getParams().put("thirdNodeUserId", new Parameter("sql", (Object)("(first_node_user_id like CONCAT('%','" + userid.toString() + "','%') or second_node_user_id like CONCAT('%','" + userid.toString() + "','%') or third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') )")));
        }
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().get("orgId") != null) {
            String authOrgIds = ((Parameter)param.getParams().get("orgId")).getValue().toString();
            param.getParams().remove("orgId");
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterDcDrwgrpInfo-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettlementCenterDcDrwgrpInfoData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> refSettlementCenterDcDrwgrpInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            this.logger.info("refSettlementCenterDcDrwgrpInfoData-condition:" + condition);
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (StringUtils.isNotBlank((CharSequence)_con.getString("projectId"))) {
                param.getParams().put("projectId", new Parameter("eq", (Object)Long.parseLong(_con.getString("projectId"))));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("contractId"))) {
                param.getParams().put("contractId", new Parameter("eq", (Object)Long.parseLong(_con.getString("contractId"))));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("flowState"))) {
                param.getParams().put("flowState", new Parameter("in", Arrays.asList(_con.getString("flowState").split(","))));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("major"))) {
                String[] majors;
                for (String major : majors = _con.getString("major").split(",")) {
                    param.getParams().put("settlementCenterMajor", new Parameter("like", (Object)major));
                }
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/deleteForDrwgrp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteForDrwgrp(@RequestBody List<Long> dcDrwgrpId) {
        List list = this.service.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, dcDrwgrpId)).eq(BaseEntity::getDr, (Object)0));
        List idList = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        this.service.removeByIds(idList);
        this.detailService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SettlementCenterOutputDetailEntity::getPid, idList)).eq(BaseEntity::getDr, (Object)0));
        this.alertInfoService.remove((Wrapper)new QueryWrapper().lambda().in(SettlementCenterAlertInfoEntity::getInfoId, idList));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

