/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailEntity;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailVO;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanEntity;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanVO;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDrawPlanService;
import com.ejianc.business.ztpc.billcode.api.IDcDrwgrpInfoApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settlementCenterDrawPlan"})
public class SettlementCenterDrawPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISettlementCenterDrawPlanService service;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private IDcDrwgrpInfoApi dcDrwgrpInfoApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementCenterDrawPlanVO> saveOrUpdate(@RequestBody SettlementCenterDrawPlanVO saveOrUpdateVO) {
        SettlementCenterDrawPlanEntity entity = (SettlementCenterDrawPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementCenterDrawPlanEntity.class));
        HashMap<String, Integer> numMap = new HashMap<String, Integer>();
        for (SettlementCenterDrawPlanDetailEntity detailEntity : entity.getSettlementCenterDrawPlanDetailList()) {
            if ("del".equals(detailEntity.getRowState())) continue;
            Integer i = (Integer)numMap.get(detailEntity.getDrwgrpCode());
            if (i != null && i > 0) {
                return CommonResponse.error((String)(detailEntity.getDrwgrpCode() + "\u5377\u518c\u7f16\u7801\u91cd\u590d"));
            }
            numMap.put(detailEntity.getDrwgrpCode(), 1);
            detailEntity.setOrgId(entity.getOrgId());
            detailEntity.setOrgCode(entity.getOrgCode());
            detailEntity.setOrgName(entity.getOrgName());
            detailEntity.setParentOrgId(entity.getParentOrgId());
            detailEntity.setParentOrgCode(entity.getParentOrgCode());
            detailEntity.setParentOrgName(entity.getParentOrgName());
            detailEntity.setProjectId(entity.getProjectId());
            detailEntity.setProjectCode(entity.getProjectCode());
            detailEntity.setProjectName(entity.getProjectName());
            detailEntity.setSettlementCenterMajor(entity.getSettlementCenterMajor());
            detailEntity.setSettlementCenterMajorName(entity.getSettlementCenterMajorName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        SettlementCenterDrawPlanVO vo = (SettlementCenterDrawPlanVO)BeanMapper.map((Object)((Object)entity), SettlementCenterDrawPlanVO.class);
        CommonResponse<SettlementCenterDrawPlanVO> planVOCommonResponse = this.queryDetail(entity.getId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)planVOCommonResponse.getData());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementCenterDrawPlanVO> queryDetail(Long id) {
        SettlementCenterDrawPlanEntity entity = (SettlementCenterDrawPlanEntity)((Object)this.service.selectById(id));
        SettlementCenterDrawPlanVO vo = (SettlementCenterDrawPlanVO)BeanMapper.map((Object)((Object)entity), SettlementCenterDrawPlanVO.class);
        List detailList = vo.getSettlementCenterDrawPlanDetailList();
        if (detailList != null && detailList.size() > 0) {
            for (SettlementCenterDrawPlanDetailVO detailVO : detailList) {
                List list = this.dcDrwgrpInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, (Object)vo.getProjectId())).like(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoCode, (Object)detailVO.getDrwgrpCode()));
                if (list != null && list.size() > 0) {
                    detailVO.setSettleFlag(Boolean.valueOf(true));
                } else {
                    detailVO.setSettleFlag(Boolean.valueOf(false));
                }
                CommonResponse listCommonResponse = this.dcDrwgrpInfoApi.queryListByProjectAndCodes(vo.getProjectId(), Arrays.asList(detailVO.getDrwgrpCode()));
                if (listCommonResponse.isSuccess() && listCommonResponse.getData() != null && ((List)listCommonResponse.getData()).size() > 0) {
                    detailVO.setDrawFlag(Boolean.valueOf(true));
                    continue;
                }
                detailVO.setDrawFlag(Boolean.valueOf(false));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterDrawPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettlementCenterDrawPlanVO settlementCenterDrawPlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDrawPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("systemName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDrawPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterDrawPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettlementCenterDrawPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDrawPlanVO>> refSettlementCenterDrawPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            String majorId;
            JSONObject _con = JSONObject.parseObject((String)condition);
            String projectId = _con.getString("projectId");
            if (StringUtils.isNotEmpty((CharSequence)projectId)) {
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (StringUtils.isNotEmpty((CharSequence)(majorId = _con.getString("majorId")))) {
                param.getParams().put("projectMajorId", new Parameter("eq", (Object)majorId));
            }
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", null);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDrawPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pullSettlementCenterDcDrwgrpInfoByPlan"})
    @ResponseBody
    public CommonResponse pullSettlementCenterDcDrwgrpInfoByPlan(Long planId) {
        SettlementCenterDrawPlanEntity entity = (SettlementCenterDrawPlanEntity)((Object)this.service.selectById(planId));
        SettlementCenterDrawPlanVO vo = (SettlementCenterDrawPlanVO)BeanMapper.map((Object)((Object)entity), SettlementCenterDrawPlanVO.class);
        List detailList = vo.getSettlementCenterDrawPlanDetailList();
        List codesList = detailList.stream().map(SettlementCenterDrawPlanDetailVO::getDrwgrpCode).collect(Collectors.toList());
        CommonResponse listCommonResponse = this.dcDrwgrpInfoApi.pushSettlementCenterByProjectAndCodes(vo.getProjectId(), planId, codesList);
        this.logger.info("\u56fe\u7eb8\u5e93\u5339\u914d\u6570\u636e:" + JSON.toJSONString((Object)listCommonResponse));
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryDetailForDrwgrp"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementCenterDrawPlanVO> queryDetailForDrwgrp(Long id) {
        SettlementCenterDrawPlanEntity settlementCenterDrawPlanEntity = (SettlementCenterDrawPlanEntity)((Object)this.service.selectById(id));
        SettlementCenterDrawPlanVO vo = (SettlementCenterDrawPlanVO)BeanMapper.map((Object)((Object)settlementCenterDrawPlanEntity), SettlementCenterDrawPlanVO.class);
        return CommonResponse.success((Object)vo);
    }
}

