package com.ejianc.business.settle.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.bean.SettlementCenterOutputDetailEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.mapper.SettlementCenterProjectDrwgrpNumMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterOutputDetailService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 专业工程量统计一览表
 *
 * @author generator
 */
@Controller
@RequestMapping("majorQuantitiesInfo")
public class MajorQuantitiesInfoController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;
    @Autowired
    private ISettlementCenterOutputDetailService detailService;

    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;
    @Autowired
    private SettlementCenterProjectDrwgrpNumMapper numMapper;

    @Autowired
    private IOrgApi iOrgApi;


    /**
     * @Description 专业工程量统计一览表- 14个类型统计数据展示
     * @Return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse queryList(Long major,String orgId) {

        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(orgId)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        long num = 0L;//总卷册数
        LambdaQueryWrapper<SettlementCenterDcDrwgrpInfoEntity> queryWrapper = new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
//                .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                .like(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, major);
        num = numMapper.queryTotalNum(null, departmentIds, commonOrgIds, major);
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            queryWrapper = new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
//                    .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                    .like(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, major)
                    .in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId,commonOrgIds);
            num = numMapper.queryTotalNum(null,null,commonOrgIds,major);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            queryWrapper = new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
//                    .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                    .like(SettlementCenterDcDrwgrpInfoEntity::getSettlementCenterMajor, major)
                    .in(SettlementCenterDcDrwgrpInfoEntity::getOrgId,departmentIds);
            num = numMapper.queryTotalNum(null,departmentIds,null,major);
        }
        Map<String, Object> resultMap = new HashMap<>();

        List<SettlementCenterDcDrwgrpInfoEntity> list = infoService.list(queryWrapper);
        BigDecimal totalOutputForYear = new BigDecimal(0);//本年累计完成统计产值
        BigDecimal totalOutputAll = new BigDecimal(0);//本年累计完成统计产值
        BigDecimal totalOutputForLastMonth = new BigDecimal(0);//上月完成统计产值
        BigDecimal totalOutputForMonth = new BigDecimal(0);//月至今完成统计产值
        List<SettlementCenterDcDrwgrpInfoEntity> finishedForLastMonth = new ArrayList<>();//图纸完成率-上月完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForLastMonth = new ArrayList<>();//图纸完成率-计划上月完成
        List<SettlementCenterDcDrwgrpInfoEntity> finishForMonth = new ArrayList<>();//图纸完成率-本月至今完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForMonth = new ArrayList<>();//图纸完成率-本本月至今计划完成
        List<SettlementCenterDcDrwgrpInfoEntity> planFinishForYear = new ArrayList<>();//图纸完成率-本本月至今计划完成
        List<SettlementCenterDcDrwgrpInfoEntity> distributedForYear = new ArrayList<>();//本年已派发卷册
        List<SettlementCenterDcDrwgrpInfoEntity> distributedForMonth = new ArrayList<>();//本月已派发卷册
        List<SettlementCenterDcDrwgrpInfoEntity> finishedForYear = new ArrayList<>();//本年已完成

        List<SettlementCenterOutputDetailEntity> detailEntities = new ArrayList<>();
        if (list.size() > 0 ){
            List<Long> idList = list.stream().map(SettlementCenterDcDrwgrpInfoEntity::getId).collect(Collectors.toList());
            detailEntities = detailService.list(
                    new QueryWrapper<SettlementCenterOutputDetailEntity>().lambda()
                            .eq(SettlementCenterOutputDetailEntity::getSettlementCenterMajor, major)
                            .in(SettlementCenterOutputDetailEntity::getPid, idList)
            );
        }

        Map<Integer, BigDecimal> outputEveryMonth = new HashMap<>();//所有有数据月份
        //数据筛选
        for (SettlementCenterDcDrwgrpInfoEntity entity : list) {
            BigDecimal statisticalOutput = new BigDecimal(0);
            for (SettlementCenterOutputDetailEntity detailEntity : detailEntities) {
                if (detailEntity.getPid().equals(entity.getId())){
                    statisticalOutput = statisticalOutput.add(detailEntity.getStatisticalOutput());
                }
            }
            //已完成统计
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                Date finishDate = entity.getEighthNodeTime();

                totalOutputAll = totalOutputAll.add(statisticalOutput);
                //本年完成统计
                if (DateUtil.year(finishDate) == DateUtil.thisYear()) {
                    totalOutputForYear = totalOutputForYear.add(statisticalOutput);
                    Integer month = DateUtil.month(finishDate) + 1;
                    if (outputEveryMonth.get(month) == null) {
                        outputEveryMonth.put(month, statisticalOutput);
                    } else {
                        outputEveryMonth.put(month, outputEveryMonth.get(month).add(statisticalOutput));
                    }
                }
                //本月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    totalOutputForMonth = totalOutputForMonth.add(statisticalOutput);
                }
                //上月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    totalOutputForLastMonth = totalOutputForLastMonth.add(statisticalOutput);
                }
            }

            //已完成卷册
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName()) || entity.getFlowStateName().equals(SettleFlowStateEnum.TWO.getName())) {

                Date finishDate = null;
                if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                    finishDate = entity.getEighthNodeTime();
                } else {
                    finishDate = entity.getFifthNodeTime();
                }


                //本年已完成
                if (DateUtil.year(finishDate) == DateUtil.thisYear()) {
                    finishedForYear.add(entity);
                }

                //本月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    finishForMonth.add(entity);
                }
                //上月完成
                if (DateUtil.beginOfMonth(finishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    finishedForLastMonth.add(entity);
                }


            }


                Date planFinishDate = entity.getDesiredTime();
                Date distributedDate = entity.getSecondNodeTime();//派发日期
                //本月计划完成
                if (planFinishDate != null && DateUtil.beginOfMonth(planFinishDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    planFinishForMonth.add(entity);
                }
                //上月计划完成
                if (planFinishDate != null && DateUtil.beginOfMonth(planFinishDate).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                    planFinishForLastMonth.add(entity);
                }
                //本年计划完成
                if (planFinishDate != null && DateUtil.year(planFinishDate) == (DateUtil.year(DateUtil.lastMonth()))) {
                    planFinishForYear.add(entity);
                }
                //本年已派发
                if (distributedDate != null && DateUtil.year(distributedDate) == DateUtil.thisYear()) {
                    distributedForYear.add(entity);
                }

                //本月已派发
                if (distributedDate != null && DateUtil.beginOfMonth(distributedDate).equals(DateUtil.beginOfMonth(new Date()))) {
                    distributedForMonth.add(entity);
                }

        }


        resultMap.put("totalOutputForYear", totalOutputForYear);//本年累计完成统计产值
        resultMap.put("totalOutputAll", totalOutputAll);//至今累计完成统计产值
        resultMap.put("totalOutputForLastMonth", totalOutputForLastMonth);//上月完成统计产值
        resultMap.put("totalOutputForMonth", totalOutputForMonth);//月至今完成统计产值


        // 已派发累计完成统计产值
//        int distributedCount = distributedForYear.size();
        // 专业到图数
        int distributedCount = list.size();
        // 本年累计完成
        int finishedCount = finishedForYear.size();
        String ratio;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratio = finishedCount + "/" + distributedCount;
        } else {
            // 如已派发数量为0，设定默认值
            ratio = "0/" + distributedCount;
        }
        resultMap.put("yearCompletionRatio", ratio);


        // 上月完成
        int size = finishedForLastMonth.size();
        // 计划上月完成卷册份数
        int sizeLastMonth = planFinishForLastMonth.size();
        String ratioTwo;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratioTwo = size + "/" + sizeLastMonth;
        } else {
            // 如已派发数量为0，设定默认值
            ratioTwo = "0/" + sizeLastMonth;
        }
        resultMap.put("lastMonthCompletionRatio", ratioTwo);

        // 本月至今
        int size2 = finishForMonth.size();
        // 本月派发卷册份数
//        int sizeThisMonth = distributedForMonth.size();
        // 专业到图数
        int sizeThisMonth = list.size();
        String ratioThree;
        if (distributedCount > 0) {
            // 避免除以零的错误
            ratioThree = size2 + "/" + sizeThisMonth;
        } else {
            // 如已派发数量为0，设定默认值
            ratioThree = "0/" + sizeThisMonth;
        }
        resultMap.put("thisMonthCompletionRatio", ratioThree);


        //预警:本年,上月,本月
        int alertYear = 0;//预警数量本年数量
        int alertLastMonth = 0;//预警数量上月数量
        int alertThisMonth = 0;//预警数量本月数量


        List<SettlementCenterAlertInfoEntity> result = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            result = alertInfoService.selectByUserId(null, major,departmentIds,commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            result = alertInfoService.selectByUserId(null, major,departmentIds,commonOrgIds);
        }



        for (SettlementCenterAlertInfoEntity entity : result) {
            Date time = entity.getCreateTime();
            if (DateUtil.year(time) == DateUtil.thisYear()) {
                alertYear += 0;
            }
            //本月完成
            if (DateUtil.beginOfMonth(time).equals(DateUtil.beginOfMonth(new Date()))) {
                alertLastMonth += 0;
            }
            //上月完成
            if (DateUtil.beginOfMonth(time).equals(DateUtil.beginOfMonth(DateUtil.lastMonth()))) {
                alertThisMonth += 0;
            }

        }

        //预警
        resultMap.put("alertYear", alertYear);
        resultMap.put("alertLastMonth", alertLastMonth);
        resultMap.put("alertThisMonth", alertThisMonth);


        //完成率

        int size1 = finishedForYear.size();
        int size4 = finishForMonth.size();
        int size5 = finishedForLastMonth.size();
//        int size3 = distributedForMonth.size();
        int size3 = list.size();
        int size6 = planFinishForLastMonth.size();
//        int size7 = distributedForYear.size();
        int size7 = list.size();



            if (size7 != 0) {
                // 计算完成率，结果为0到1之间的小数
                double completionRate = (double) size1 / size7;

                // 如果你想以百分比形式展示，可以乘以100
                double completionRatePercentage = completionRate * 100;
                resultMap.put("rateYear", completionRatePercentage);  //本年完成率
            }

            if (size3 != 0) {
                double completionRate2 = (double) size4 / size3;
                double completionRatePercentage2 = completionRate2 * 100;
                resultMap.put("rateThisMonth", completionRatePercentage2);//本月完成率
            }

            if (size6 != 0) {
                double completionRate3 = (double) size5 / size6;
                double completionRatePercentage3 = completionRate3 * 100;
                resultMap.put("rateLastMonth", completionRatePercentage3);//上月完成率
            }


//            // 防止除数为0的情况
//            if (completionRatePercentage3 == 0) {
//                System.out.println("上月完成率为0，无法计算增幅！");
//                resultMap.put("completeRate", null);//完成率上月增幅
//
//            } else {
//                // 计算增幅
//                double increaseRate2 = ((double) (completionRatePercentage2 - completionRatePercentage3) / completionRatePercentage3) * 100;
//
//                resultMap.put("completeRate", increaseRate2);//完成率上月增幅
//            }



        //上月增幅


        // 防止除数为0的情况
        if (alertLastMonth == 0) {
            System.out.println("上月预警数为0，无法计算增幅！");
            resultMap.put("alertRate", null);//预警上月增幅

        } else {
            // 计算增幅
            double increaseRate = ((double) (alertThisMonth - alertLastMonth) / alertLastMonth) * 100;

            resultMap.put("alertRate", increaseRate);//预警上月增幅

        }


        // 防止除数为0的情况
        if (totalOutputForLastMonth.equals(BigDecimal.ZERO)) {
            System.out.println("上月统计产值为0，无法计算增幅！");
            resultMap.put("outputRate", null);//统计产值上月增幅

        } else {
            // 计算增幅
            BigDecimal divide = (totalOutputForMonth.subtract(totalOutputForLastMonth)).divide(totalOutputForLastMonth,2, RoundingMode.HALF_DOWN);
            resultMap.put("outputRate", divide);//统计产值上月增幅
        }

        // 防止除数为0的情况
        if (size == 0) {
            System.out.println("上月卷册数为0，无法计算增幅！");
            resultMap.put("volumeRate", null);//卷册份数上月增幅
        } else {
            // 计算增幅
            double increaseRate = ((double) (size2 - size) / size) * 100;
            resultMap.put("volumeRate", increaseRate);//卷册份数上月增幅

        }


        //上月图纸完成计划率
        if (planFinishForLastMonth.size() == 0) {
        } else {
        }
        //本月至今图纸完成计划率
        if (planFinishForMonth.size() == 0) {
            resultMap.put("finishRateForMonth", 100);
        } else {
            resultMap.put("finishRateForMonth", (finishForMonth.size() + 0.00) / planFinishForMonth.size());
        }
        resultMap.put("totalNum",num);
        return CommonResponse.success(resultMap);
    }


    /**
     * @Description 专业工程量统计一览表- 工程量统计产值动态图
     * @Return
     */
    @RequestMapping(value = "/queryActionMap", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, BigDecimal>>> queryActionMap(Long thirdNodeUserId, Long major) {
        List<Map<String, BigDecimal>> result = infoMapper.selectActionMap(null, major);
        return CommonResponse.success("查询列表数据成功！", result);
    }


    /**
     * @Description 专业工程量统计一览表- 本年工作任务完成情况清单 -未完成
     * @Return
     */
    @RequestMapping(value = "/queryMajorJobUndoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryMajorJobUndoneList(@RequestBody QueryParam param) {
        Parameter orgParam = param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(orgId)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");//项目名称
        fuzzyFields.add("thirdNodeUserId");//统计人
        fuzzyFields.add("fourthNodeUserName");//责任人
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("flowState", new Parameter(QueryParam.NOT_IN, Arrays.asList(SettleFlowStateEnum.NINE.getCode(),SettleFlowStateEnum.TWO.getCode(),SettleFlowStateEnum.ONE.getCode(),SettleFlowStateEnum.THREE.getCode())));
        param.getParams().put("eighth_node_time",new Parameter(QueryParam.SQL, "((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')" +
                "          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));

        IPage<SettlementCenterDcDrwgrpInfoEntity> page = infoService.queryPage(param, false);

        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));


        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 专业工程量统计一览表- 本年工作任务完成情况清单 -已完成
     * @Return
     */
    @RequestMapping(value = "/queryMajorJobDoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryMajorJobDoneList(@RequestBody QueryParam param) {
        Parameter orgParam = param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(orgId)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");//项目名称
        fuzzyFields.add("thirdNodeUserId");//统计人
        fuzzyFields.add("fourthNodeUserName");//责任人
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("flowState",new Parameter(QueryParam.SQL, "(flow_state = 9 or flow_state = 2)"));
        param.getParams().put("eighth_node_time",new Parameter(QueryParam.SQL, "((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')" +
                "          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));

        IPage<SettlementCenterDcDrwgrpInfoEntity> page = infoService.queryPage(param, false);

        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));


        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param
     * @Description 本年工作任务完成情况清单导出(未完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportUndone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportUndone(Long major, HttpServletResponse response, @RequestBody QueryParam param) {
        Parameter orgParam = param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(orgId)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }
        Map<String, Object> beans = new HashMap<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("projectName");//项目名称
//        fuzzyFields.add("thirdNodeUserId");//统计人
//        fuzzyFields.add("fourthNodeUserName");//责任人
//      param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("flowState", new Parameter(QueryParam.NOT_IN, Arrays.asList(SettleFlowStateEnum.NINE.getCode(),SettleFlowStateEnum.TWO.getCode())));
        param.getParams().put("eighth_node_time",new Parameter(QueryParam.SQL, "((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')" +
                "          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
//        param.setPageSize(1);
        List<SettlementCenterDcDrwgrpInfoEntity> list = infoService.queryList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            List<SettlementCenterDcDrwgrpInfoEntity> collect = list.stream()
                    .filter(entiy -> entiy != null && entiy.getSettlementCenterMajor() != null && entiy.getSettlementCenterMajor().contains(major.toString()))
                    .collect(Collectors.toList());
//            List<SettlementCenterDcDrwgrpInfoEntity> collect = list.stream().filter(entiy -> entiy.getSettlementCenterMajor().equals(major)).collect(Collectors.toList());

            beans.put("records", collect);
        }

        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 本年工作任务完成情况清单导出(已完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportDone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDone(Long major, HttpServletResponse response, @RequestBody QueryParam param) {
        Parameter orgParam = param.getParams().get("orgId");
        if (orgParam != null && orgParam.getValue() != null) {
            String orgId = orgParam.getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(orgId)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }
        Map<String, Object> beans = new HashMap<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("projectName");//项目名称
//        fuzzyFields.add("thirdNodeUserId");//统计人
//        fuzzyFields.add("fourthNodeUserName");//责任人
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("flowState",new Parameter(QueryParam.SQL, "(flow_state = 9 or flow_state = 2)"));
        param.getParams().put("eighth_node_time",new Parameter(QueryParam.SQL, "((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')" +
                "          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        param.setPageSize(1);
        List<SettlementCenterDcDrwgrpInfoEntity> list = infoService.queryList(param);
        List<SettlementCenterDcDrwgrpInfoEntity> collect = list.stream().filter(entiy -> entiy.getSettlementCenterMajor().contains(major.toString())).collect(Collectors.toList());

        beans.put("records", collect);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }


    @RequestMapping(value = "/getRankingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse getRankingList(Long major,String orgId) {
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(orgId)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        Map<String, Object> resultMap = new HashMap<>();
        List<Map> rankingListForYear = infoService.getRankingListForYear(major,departmentIds,commonOrgIds);
        List<Map> rankingListForMonth = infoService.getRankingListForMonth(major,departmentIds,commonOrgIds);
        resultMap.put("rankingListForYear", rankingListForYear);
        resultMap.put("rankingListForMonth", rankingListForMonth);
        return CommonResponse.success(resultMap);
    }

    /**
     * @Description
     * @Return
     */
    @RequestMapping(value = "/queryMajorLedgerList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryMajorLedgerList(Long majorId, Integer pageNum, Integer pageSize,String orgId) {
        Map resultMap = new HashMap();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(orgId)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        int pageStart = pageSize * (pageNum - 1);//分页开始坐标
        List<Map> majorStatisticsLedgerList = new ArrayList<>();
        int total = 0;

        if (StringUtils.isNotBlank(orgId)){
            if (commonOrgIds.size()>0) {
                majorStatisticsLedgerList = infoService.getMajorStatisticsLedgerList(majorId, null, commonOrgIds, pageStart, pageSize);
                total = infoService.countMajorStatisticsLedgerList(majorId, null, commonOrgIds);
            }else {
                majorStatisticsLedgerList = infoService.getMajorStatisticsLedgerList(majorId, departmentIds, null, pageStart, pageSize);
                total = infoService.countMajorStatisticsLedgerList(majorId, departmentIds, null);
            }
        }else {
            majorStatisticsLedgerList = infoService.getMajorStatisticsLedgerList(majorId,null,null,pageStart,pageSize);
            total = infoService.countMajorStatisticsLedgerList(majorId,null,null);
        }


        resultMap.put("records",majorStatisticsLedgerList);
        resultMap.put("pages",total % pageSize > 0 ? total/pageSize + 1:total/pageSize);
        resultMap.put("size",pageSize);
        resultMap.put("total",total);
        resultMap.put("current",pageNum);

        return CommonResponse.success("查询列表数据成功！",resultMap);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param
     * @Description 统计台账导出(已完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportMajorLedger", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMajorLedger(Long majorId, Integer pageNum, Integer pageSize,String orgId, HttpServletResponse response) {
        Map resultMap = new HashMap();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(orgId)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        int pageStart = pageSize * (pageNum - 1);//分页开始坐标
        List<Map> majorStatisticsLedgerList = new ArrayList<>();
        int total = 0;

        if (StringUtils.isNotBlank(orgId)){
            if (commonOrgIds.size()>0) {
                majorStatisticsLedgerList = infoService.getMajorStatisticsLedgerList(majorId, null, commonOrgIds, pageStart, pageSize);
                total = infoService.countMajorStatisticsLedgerList(majorId, null, commonOrgIds);
            }else {
                majorStatisticsLedgerList = infoService.getMajorStatisticsLedgerList(majorId, departmentIds, null, pageStart, pageSize);
                total = infoService.countMajorStatisticsLedgerList(majorId, departmentIds, null);
            }
        }else {
            majorStatisticsLedgerList = infoService.getMajorStatisticsLedgerList(majorId,null,null,pageStart,pageSize);
            total = infoService.countMajorStatisticsLedgerList(majorId,null,null);
        }

        for (Map map : majorStatisticsLedgerList) {
            Object total_amount = map.get("total_amount");
            if (total_amount != null){
                BigDecimal totalAmount = new BigDecimal(total_amount.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("total_amount",totalAmount);
            }
            Object year_total_amount = map.get("year_total_amount");
            if (year_total_amount != null){
                BigDecimal yearTotalAmount = new BigDecimal(year_total_amount.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("year_total_amount",yearTotalAmount);
            }
            Object month_total_amount = map.get("month_total_amount");
            if (month_total_amount != null){
                BigDecimal monthTotalAmount = new BigDecimal(month_total_amount.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("month_total_amount",monthTotalAmount);
            }
            Object total_material_cost = map.get("total_material_cost");
            if (total_material_cost != null){
                BigDecimal totalMaterialCost = new BigDecimal(total_material_cost.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("total_material_cost",totalMaterialCost);
            }
            Object total_equipment_cost = map.get("total_equipment_cost");
            if (total_equipment_cost != null){
                BigDecimal totalEquipmentCost = new BigDecimal(total_equipment_cost.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("total_equipment_cost",totalEquipmentCost);
            }
            Object total_installation_cost = map.get("total_installation_cost");
            if (total_installation_cost != null){
                BigDecimal totalInstallationCost = new BigDecimal(total_installation_cost.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("total_installation_cost",totalInstallationCost);
            }
        }


        resultMap.put("records",majorStatisticsLedgerList);


        ExcelExport.getInstance().export("MajorOutputDetail-export.xlsx", resultMap, response);
    }

}
